/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.jdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class PostfixLabelProvider
extends SearchLabelProvider {
    private ITreeContentProvider fContentProvider = new LevelTreeContentProvider.FastJavaElementProvider();

    public PostfixLabelProvider(JavaSearchResultPage page) {
        super(page);
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    @Override
    public String getText(Object element) {
        String labelWithCounts = this.getLabelWithCounts(element, this.internalGetText(element));
        return String.valueOf(labelWithCounts) + this.getQualification(element);
    }

    private String getQualification(Object element) {
        StringBuffer res = new StringBuffer();
        ITreeContentProvider provider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.fContentProvider.getParent(element);
        Object lastElement = element;
        while (realParent != null && !(realParent instanceof IJavaModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                res.append(JavaElementLabels.CONCAT_STRING).append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.fContentProvider.getParent(realParent);
        }
        return res.toString();
    }

    @Override
    protected boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String internalGetText(Object element) {
        String text = super.getText(element);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getParticipantText(element);
    }

    private StyledString internalGetStyledText(Object element) {
        StyledString text = super.getStyledText(element);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getStyledParticipantText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof IClassFile ? type.getClassFile().equals(realParent) : realParent instanceof ICompilationUnit && type.getCompilationUnit().equals(realParent)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public StyledString getStyledText(Object element) {
        StyledString styledString = this.getColoredLabelWithCounts(element, this.internalGetStyledText(element));
        styledString.append(this.getQualification(element), StyledString.QUALIFIER_STYLER);
        return styledString;
    }
}

