/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.shared.menu;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.view.MAView;

public abstract class AbstractSentToCommandHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AbstractSentToCommandHandler.class);

    protected abstract String getCommandParameterPrimaryId();

    protected abstract String getCommandParameterSecondaryId();

    protected abstract String getCommandParameterShouldCreateViewId();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String primaryViewId = event.getParameter(this.getCommandParameterPrimaryId());
        String secondaryViewId = event.getParameter(this.getCommandParameterSecondaryId());
        boolean shouldCreateView = Boolean.parseBoolean(event.getParameter(this.getCommandParameterShouldCreateViewId()));
        secondaryViewId = shouldCreateView ? MEView.getSecondaryViewId() : secondaryViewId;
        try {
            IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(primaryViewId, secondaryViewId, 2);
            MAView maView = (MAView)viewPart;
            if (shouldCreateView) {
                maView.setViewName(MAView.getViewName((String)maView.getPartName(), (String)secondaryViewId));
            }
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            Collection selectionData = maView.getSelectionHelper().getElementsFromSelection(selection);
            maView.dataChanged(selectionData);
        }
        catch (PartInitException e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }
}

