/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.progress.view;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoProgressShell
extends Observable
implements Observer {
    Shell sShell = null;
    ProgressBar progressBar = null;
    private CLabel message = null;
    Text textArea = null;
    private Button details = null;
    private Button cancelOrClose = null;
    private Button pauseOrResume = null;
    Composite top;
    private Rectangle bounds;
    private Rectangle topBounds;
    protected boolean disposeAtEnd = false;
    protected boolean isStoppable = false;
    protected boolean isRunning = true;
    final Display display;
    StringBuffer detailedMessageCache = null;
    Observer model = null;

    public InfoProgressShell() {
        this.display = new Display();
        this.init();
    }

    public InfoProgressShell(Display display, Observer observer) {
        this.display = display;
        this.model = observer;
        this.addObserver(this.model);
        if (this.model instanceof Observable) {
            Observable observable = (Observable)((Object)this.model);
            observable.addObserver(this);
        }
        this.init();
    }

    private void init() {
        this.createSShell();
        Rectangle rect = this.sShell.getBounds();
        this.topBounds = new Rectangle(rect.x, rect.y, 600, 140);
        this.bounds = new Rectangle(rect.x, rect.y, this.topBounds.width, this.topBounds.height + 300);
        this.sShell.setBounds(this.topBounds);
        this.setDetailMode(false);
        this.setStoppable(false);
        this.detailedMessageCache = new StringBuffer();
    }

    public void setTitle(String titleString) {
        this.sShell.setText(titleString);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setMaximum(int valueI) {
        this.progressBar.setMaximum(valueI);
    }

    public void setSelection(int valueI) {
        this.progressBar.setSelection(valueI);
        float pourcent = (float)valueI / (float)this.getMaximum() * 100.0f;
        this.sShell.setText(String.valueOf((int)pourcent) + "%");
    }

    public void setStoppable(boolean isStoppable) {
        this.isStoppable = isStoppable;
        this.cancelOrClose.setEnabled(this.isStoppable);
    }

    public void setDisposeAtEnd(boolean disposeAtEnd) {
        this.disposeAtEnd = disposeAtEnd;
    }

    public void setVisible(boolean visibleB) {
        this.sShell.setVisible(visibleB);
    }

    public void setDetailMode(boolean showDetailB) {
        this.textArea.setVisible(showDetailB);
        Rectangle rect = this.sShell.getBounds();
        this.topBounds = new Rectangle(rect.x, rect.y, this.topBounds.width, this.topBounds.height);
        this.bounds = new Rectangle(rect.x, rect.y, this.bounds.width, this.bounds.height);
        if (!showDetailB) {
            this.details.setText(">>");
            this.sShell.setBounds(this.topBounds);
        } else {
            this.details.setText("<<");
            this.sShell.setBounds(this.bounds);
        }
    }

    public boolean isDetailMode() {
        return this.textArea.isVisible();
    }

    public boolean isDisposed() {
        return this.sShell.isDisposed();
    }

    public void setMessage(String messageString) {
        this.message.setText(messageString);
    }

    public void appendDetailedMessage(String messageString) {
        this.detailedMessageCache.append(messageString);
        this.detailedMessageCache.append(System.getProperty("line.separator"));
        try {
            this.display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (InfoProgressShell.this.isDisposed()) {
                        return;
                    }
                    StringBuffer stringBuffer = InfoProgressShell.this.detailedMessageCache;
                    synchronized (stringBuffer) {
                        InfoProgressShell.this.textArea.append(InfoProgressShell.this.detailedMessageCache.toString());
                        InfoProgressShell.this.detailedMessageCache.setLength(0);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearDetailedMessage() {
        try {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (InfoProgressShell.this.isDisposed()) {
                        return;
                    }
                    InfoProgressShell.this.textArea.setText("");
                    InfoProgressShell.this.detailedMessageCache.setLength(0);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void open() {
        Monitor monitor = this.display.getMonitors()[0];
        Rectangle screen = monitor.getBounds();
        Rectangle rect = this.sShell.getBounds();
        this.sShell.setBounds((screen.width - rect.width) / 2, (screen.height - rect.height) / 2, rect.width, rect.height);
        this.sShell.open();
        while (!this.sShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            if (arg instanceof Integer) {
                final Integer progress = (Integer)arg;
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InfoProgressShell.this.isDisposed()) {
                            return;
                        }
                        InfoProgressShell.this.setSelection(progress);
                    }
                });
            } else if (arg instanceof HashMap) {
                HashMap progress = (HashMap)arg;
                this.update(progress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(final HashMap<String, Object> properties) {
        String detailedMessage = (String)properties.get("DetailedMessage");
        if (detailedMessage != null) {
            this.appendDetailedMessage(detailedMessage);
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer min = (Integer)properties.get("Min");
                if (min != null) {
                    InfoProgressShell.this.progressBar.setMinimum(min.intValue());
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer max = (Integer)properties.get("Max");
                if (max != null) {
                    InfoProgressShell.this.setMaximum(max);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer progress = (Integer)properties.get("Progress");
                if (progress != null) {
                    InfoProgressShell.this.setSelection(progress);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Boolean finished = (Boolean)properties.get("Finished");
                if (finished != null) {
                    InfoProgressShell.this.setFinished(finished);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                String message = (String)properties.get("Message");
                if (message != null) {
                    InfoProgressShell.this.setMessage(message);
                }
            }
        });
    }

    protected void setFinished(boolean finished) {
        if (finished) {
            this.setSelection(this.getMaximum());
            if (this.disposeAtEnd) {
                this.close();
            } else {
                this.cancelOrClose.setText("Close");
                this.cancelOrClose.setEnabled(true);
            }
        }
    }

    private void createTop() {
        GridData gridData15 = new GridData();
        gridData15.grabExcessHorizontalSpace = false;
        gridData15.verticalAlignment = 1;
        gridData15.horizontalAlignment = 4;
        GridData gridData14 = new GridData();
        gridData14.grabExcessHorizontalSpace = true;
        gridData14.verticalAlignment = 2;
        gridData14.horizontalSpan = 3;
        gridData14.horizontalAlignment = 4;
        GridData gridData1 = new GridData();
        gridData1.widthHint = 100;
        gridData1.verticalAlignment = 2;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.horizontalAlignment = 3;
        GridData gridData = new GridData();
        gridData.heightHint = -1;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 100;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 3;
        gridData4.grabExcessHorizontalSpace = false;
        gridData4.widthHint = 100;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.verticalAlignment = 2;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalSpan = 3;
        gridData3.horizontalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        this.top = new Composite((Composite)this.sShell, 0);
        this.top.setLayout((Layout)gridLayout1);
        this.top.setLayoutData((Object)gridData15);
        this.message = new CLabel(this.top, 0);
        this.message.setText("");
        this.message.setLayoutData((Object)gridData14);
        this.progressBar = new ProgressBar(this.top, 65536);
        this.progressBar.setLayoutData((Object)gridData3);
        this.details = new Button(this.top, 0);
        this.details.setText(">>");
        this.details.setLayoutData((Object)gridData);
        this.pauseOrResume = new Button(this.top, 0);
        this.pauseOrResume.setText("Pause");
        this.pauseOrResume.setLayoutData((Object)gridData4);
        this.cancelOrClose = new Button(this.top, 0);
        this.cancelOrClose.setText("Cancel");
        this.cancelOrClose.setLayoutData((Object)gridData1);
        this.pauseOrResume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.switchActive();
            }
        });
        this.cancelOrClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.close();
            }
        });
        this.details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.switchDetail();
            }
        });
    }

    protected void close() {
        this.deleteObserver(this.model);
        if (this.model instanceof Observable) {
            Observable observable = (Observable)((Object)this.model);
            observable.deleteObserver(this);
        }
        this.sShell.dispose();
    }

    protected void switchActive() {
        this.isRunning = !this.isRunning;
        this.setChanged();
        this.notifyObservers();
        if (this.isRunning) {
            this.pauseOrResume.setText("Pause");
        } else {
            this.pauseOrResume.setText("Resume");
        }
    }

    protected void switchDetail() {
        this.setDetailMode(!this.isDetailMode());
    }

    private void createSShell() {
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        this.sShell = new Shell(82000);
        this.sShell.setText("");
        this.sShell.setLayout((Layout)new GridLayout());
        this.createTop();
        this.textArea = new Text((Composite)this.sShell, 2570);
        this.textArea.setEditable(false);
        this.textArea.setBackground(Display.getCurrent().getSystemColor(1));
        this.textArea.setLayoutData((Object)gridData2);
        this.textArea.setEnabled(true);
    }
}

