/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.ExtensionPriorityComparator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.SequenceMessageExt;
import org.polarsys.capella.core.refinement.scenarios.core.Messages;
import org.polarsys.capella.core.refinement.scenarios.core.RefinementServices;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.Node;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.ScenarioRepresentation;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.RefinementException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IMapper;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IResolver;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IScheduler;

public abstract class ScenarioRefinement
implements IProcessor {
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    private static final int _MESSAGE_PROGRESS_STEP = 5;
    private static final int _PRE_POST_PROCESSOR_PROGRESS_STEP = 10;
    private static final String POSTPROCESSING_EXTENSION_ID = "postprocessingExtension";
    private static final String SCHEDULING_EXTENSION_ID = "schedulingExtension";
    private static final String RESOLVING_EXTENSION_ID = "resolvingExtension";
    private static final String MAPPING_EXTENSION_ID = "mappingExtension";
    private static final String PREPROCESSING_EXTENSION_ID = "preprocessingExtension";
    private static final String REFINEMENT_FRAMEWORK_PLUGIN_ID = "org.polarsys.capella.core.refinement.framework";
    protected Scenario _srcDiagram = null;
    protected Scenario _tgtDiagram = null;
    protected NamedElement _tgtElement = null;
    protected boolean _isIntraLayerRefinement = false;
    private boolean loadAdditionalProcessors = true;
    private IScheduler pluggedSchedulers = null;
    private List<IMapper> pluggedMappers = null;
    private List<IProcessor> pluggedPreprocessors = null;
    private List<IProcessor> pluggedPostprocessors = null;
    private List<IResolver> pluggedResolvers = null;
    protected static String REFINED_SCENARIO_PREFIX = "L{0} - ";

    public ScenarioRefinement(Scenario srcDiagram, NamedElement target) {
        this(srcDiagram, target, false);
    }

    public ScenarioRefinement(Scenario srcDiagram, NamedElement target, boolean isIntraLayer) {
        this(srcDiagram, target, isIntraLayer, true);
    }

    public ScenarioRefinement(Scenario srcDiagram, NamedElement target, boolean isIntraLayer, boolean loadAdditionalProcessors) {
        this._srcDiagram = srcDiagram;
        this._tgtElement = target;
        this._isIntraLayerRefinement = isIntraLayer;
        this.loadAdditionalProcessors = loadAdditionalProcessors;
        this.addPluggedModules();
    }

    @Override
    public Object getName() {
        return "Scenario Refinement";
    }

    @Override
    public Object getResult() {
        return this._tgtDiagram;
    }

    public boolean isIntraLayerRefinement() {
        return this._isIntraLayerRefinement;
    }

    protected void forceTargetScenario(Scenario tgtDiagram) {
        this._tgtDiagram = tgtDiagram;
    }

    @Override
    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    @Override
    public void setContext(ModelElement context) {
        if (context instanceof Scenario) {
            this._srcDiagram = (Scenario)context;
            for (IProcessor processor : this.pluggedPreprocessors) {
                processor.setContext(context);
            }
            for (IProcessor processor : this.pluggedPostprocessors) {
                processor.setContext(context);
            }
        }
    }

    public Scenario getContext() {
        return this._srcDiagram;
    }

    @Override
    public void setTarget(NamedElement target) {
        this._tgtElement = target;
        for (IProcessor processor : this.pluggedPreprocessors) {
            processor.setTarget(target);
        }
        for (IProcessor processor : this.pluggedPostprocessors) {
            processor.setTarget(target);
        }
    }

    public NamedElement getTarget() {
        if (this._tgtElement instanceof Part) {
            return ((Part)this._tgtElement).getType();
        }
        return this._tgtElement;
    }

    private void addPlug(IMapper mapper) {
        this.addPlug(-1, mapper);
    }

    private void addPlug(IResolver resolver) {
        this.addPlug(-1, resolver);
    }

    private void addPlug(IScheduler scheduler) {
        this.pluggedSchedulers = scheduler;
    }

    private void addPlug(IProcessor processor, IProcessor.ProcessingType type) {
        this.addPlug(-1, processor, type);
    }

    private void addPlug(int order, IMapper mapper) {
        if (this.pluggedMappers == null) {
            this.pluggedMappers = new ArrayList<IMapper>();
        }
        if (order < 0 || order > this.pluggedMappers.size()) {
            this.pluggedMappers.add(mapper);
        } else {
            this.pluggedMappers.add(order, mapper);
        }
    }

    private void addPlug(int order, IResolver resolver) {
        if (this.pluggedResolvers == null) {
            this.pluggedResolvers = new ArrayList<IResolver>();
        }
        if (order < 0 || order > this.pluggedMappers.size()) {
            this.pluggedResolvers.add(resolver);
        } else {
            this.pluggedResolvers.add(order, resolver);
        }
    }

    private void addPlug(int order, IProcessor processor, IProcessor.ProcessingType type) {
        switch (type) {
            case PREPROCESSING: {
                if (this.pluggedPreprocessors == null) {
                    this.pluggedPreprocessors = new ArrayList<IProcessor>();
                }
                if (order < 0 || order > this.pluggedPreprocessors.size()) {
                    this.pluggedPreprocessors.add(processor);
                    break;
                }
                this.pluggedPreprocessors.add(order, processor);
                break;
            }
            case POSTPROCESSING: {
                if (this.pluggedPostprocessors == null) {
                    this.pluggedPostprocessors = new ArrayList<IProcessor>();
                }
                if (order < 0 || order > this.pluggedPostprocessors.size()) {
                    this.pluggedPostprocessors.add(processor);
                    break;
                }
                this.pluggedPostprocessors.add(order, processor);
            }
        }
    }

    protected boolean isInteracting(InteractionUse use, NamedElement elt) {
        boolean startResult = false;
        boolean finishResult = false;
        if (use != null && elt != null) {
            FragmentEnd finishEnd;
            FragmentEnd startEnd = (FragmentEnd)use.getStart();
            if (startEnd != null) {
                startResult = this.isInteracting(startEnd, elt);
            }
            if ((finishEnd = (FragmentEnd)use.getFinish()) != null) {
                finishResult = this.isInteracting(finishEnd, elt);
            }
        }
        return startResult || finishResult;
    }

    private boolean isInteracting(SequenceMessage msg, NamedElement elt) {
        boolean sndResult = false;
        boolean rcvResult = false;
        if (msg != null && elt != null) {
            MessageEnd rcvMsgEnd;
            MessageEnd sndMsgEnd = msg.getSendingEnd();
            if (sndMsgEnd != null) {
                sndResult = this.isInteracting((AbstractEnd)sndMsgEnd, elt);
            }
            if ((rcvMsgEnd = msg.getReceivingEnd()) != null) {
                rcvResult = this.isInteracting((AbstractEnd)rcvMsgEnd, elt);
            }
        }
        return sndResult || rcvResult;
    }

    private boolean isInteracting(ExecutionEnd execEnd, NamedElement elt) {
        MessageEnd msgEnd;
        Execution exec;
        boolean result = false;
        if (execEnd != null && elt != null && !(result = this.isInteracting((AbstractEnd)execEnd, elt)) && (exec = execEnd.getExecution()) != null && (msgEnd = MessageEndExt.getOppositeMessageEnd((MessageEnd)((MessageEnd)exec.getStart()))) != null) {
            result = this.isInteracting((AbstractEnd)msgEnd, elt);
        }
        return result;
    }

    private boolean isInteracting(AbstractEnd absEnd, NamedElement elt) {
        AbstractInstance inst;
        InstanceRole instRole;
        boolean result = false;
        if (absEnd != null && elt != null && (instRole = absEnd.getCovered()) != null && (inst = instRole.getRepresentedInstance()) != null) {
            if (elt instanceof Part) {
                result = elt.equals(inst);
            } else {
                Type type = inst.getType();
                if (type instanceof AbstractExchangeItem) {
                    for (Object objectRef : EObjectExt.getReferencers((EObject)type, (EReference)CommunicationPackage.Literals.COMMUNICATION_LINK__EXCHANGE_ITEM)) {
                        EObject owner = ((CommunicationLink)objectRef).eContainer();
                        if (!elt.equals(owner)) continue;
                        return true;
                    }
                } else {
                    result = elt.equals(type);
                }
            }
        }
        return result;
    }

    private boolean isInteracting(FragmentEnd absEnd, NamedElement elt) {
        boolean result = false;
        if (absEnd != null && elt != null) {
            for (InstanceRole instRole : absEnd.getCoveredInstanceRoles()) {
                AbstractInstance inst = instRole.getRepresentedInstance();
                if (inst == null) continue;
                if (elt instanceof Part) {
                    result |= elt.equals(inst);
                    continue;
                }
                Type type = inst.getType();
                if (type instanceof AbstractExchangeItem) {
                    for (Object objectRef : EObjectExt.getReferencers((EObject)type, (EReference)CommunicationPackage.Literals.COMMUNICATION_LINK__EXCHANGE_ITEM)) {
                        EObject owner = ((CommunicationLink)objectRef).eContainer();
                        if (!elt.equals(owner)) continue;
                        return true;
                    }
                    continue;
                }
                result |= elt.equals(type);
            }
        }
        return result;
    }

    private void preprocessing(IProgressMonitor progressMonitor) throws ProcessorException {
        try {
            if (this.pluggedPreprocessors != null) {
                int totalWork = 10 * this.pluggedPreprocessors.size();
                progressMonitor.beginTask(Messages.PreProcessing_Progress, totalWork);
                for (IProcessor preProcessor : this.pluggedPreprocessors) {
                    preProcessor.execute(progressMonitor);
                    Object processorName = preProcessor.getName();
                    if (processorName != null) {
                        String loggedMsg = MessageFormat.format(Messages.PreProcessing_Succeeded, processorName);
                        this._logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
                    }
                    progressMonitor.worked(10);
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void postprocessing(IProgressMonitor progressMonitor) throws ProcessorException {
        try {
            if (this.pluggedPostprocessors != null) {
                int totalWork = 10 * this.pluggedPostprocessors.size();
                progressMonitor.beginTask(Messages.PostProcessing_Progress, totalWork);
                for (IProcessor postProcessor : this.pluggedPostprocessors) {
                    postProcessor.execute(progressMonitor);
                    Object processorName = postProcessor.getName();
                    if (processorName != null) {
                        String loggedMsg = MessageFormat.format(Messages.PostProcessing_Succeeded, processorName);
                        this._logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
                    }
                    progressMonitor.worked(10);
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void refineMsg(ScenarioRepresentation srcTree, ScenarioRepresentation tgtTree, Scenario tgtDiagram, List<AbstractEnd> unmappedMsg, Node<InteractionFragment> currentSrcNode, AbstractEnd absMsg, InstanceRole instRole, Component decomposedCpnt, AbstractEventOperation invokedOperation, MessageEndExt.COMPONENT_TYPE type) {
        ArrayList<AbstractInstance> candidateAbstractInstances = null;
        List<AbstractInstance> targetfinalAbstractInstances = null;
        NamedElement tgtElement = this._tgtElement instanceof Part ? ((Part)this._tgtElement).getType() : this._tgtElement;
        candidateAbstractInstances = new ArrayList<AbstractInstance>();
        for (IMapper m : this.pluggedMappers) {
            for (AbstractInstance candidateCpnt : m.candidateComponents(instRole.getRepresentedInstance(), this._isIntraLayerRefinement, decomposedCpnt, tgtElement, srcTree.getScenario(), absMsg)) {
                if (candidateAbstractInstances.contains(candidateCpnt)) continue;
                candidateAbstractInstances.add(candidateCpnt);
            }
        }
        targetfinalAbstractInstances = new ArrayList<AbstractInstance>();
        for (IMapper m : this.pluggedMappers) {
            for (AbstractInstance mappedCpnt : m.componentMapping(type, invokedOperation, candidateAbstractInstances, absMsg)) {
                if (targetfinalAbstractInstances.contains(mappedCpnt)) continue;
                targetfinalAbstractInstances.add(mappedCpnt);
            }
        }
        AbstractInstance finalAbstractInstance = null;
        if (targetfinalAbstractInstances.size() > 0) {
            if (targetfinalAbstractInstances.size() == 1) {
                finalAbstractInstance = (AbstractInstance)targetfinalAbstractInstances.get(0);
            } else {
                for (IResolver resolver : this.pluggedResolvers) {
                    targetfinalAbstractInstances = resolver.resolving(targetfinalAbstractInstances, srcTree, tgtTree, absMsg, type);
                    if (targetfinalAbstractInstances.size() != 1) continue;
                    finalAbstractInstance = targetfinalAbstractInstances.get(0);
                    break;
                }
            }
        }
        if (finalAbstractInstance == null) {
            unmappedMsg.add(absMsg);
            if (absMsg instanceof MessageEnd) {
                this.logUnmappedMessage(((MessageEnd)absMsg).getMessage(), type);
            }
        }
        if (this.pluggedSchedulers != null) {
            this.pluggedSchedulers.doOrdering(srcTree, tgtTree, finalAbstractInstance, currentSrcNode, tgtElement);
        }
    }

    private void refine(ScenarioRepresentation srcTree, Scenario tgtDiagram, ScenarioRepresentation tgtTree, Node<InteractionFragment> currentSrcNode, InteractionState state, List<AbstractEnd> unmappedMsg, IProgressMonitor progressMonitor) {
        AbstractInstance cpntInst;
        InstanceRole instRole = state.getCovered();
        if (instRole != null && (cpntInst = instRole.getRepresentedInstance()) != null) {
            AbstractType abstractType = cpntInst.getAbstractType();
        }
    }

    private void refine(ScenarioRepresentation srcTree, Scenario tgtDiagram, ScenarioRepresentation tgtTree, Node<InteractionFragment> currentSrcNode, InteractionOperand operand, List<AbstractEnd> unmappedMsg, IProgressMonitor progressMonitor) {
        if (this.pluggedSchedulers != null) {
            this.pluggedSchedulers.doOrdering(srcTree, tgtTree, null, currentSrcNode, null);
        }
    }

    private void refine(ScenarioRepresentation srcTree, Scenario tgtDiagram, ScenarioRepresentation tgtTree, Node<InteractionFragment> currentSrcNode, FragmentEnd fragment, List<AbstractEnd> unmappedMsg, IProgressMonitor progressMonitor) {
        if ((!this._isIntraLayerRefinement || this.isInteracting(fragment, this._tgtElement)) && this.pluggedSchedulers != null) {
            this.pluggedSchedulers.doOrdering(srcTree, tgtTree, null, currentSrcNode, this._tgtElement);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refine(ScenarioRepresentation srcTree, Scenario tgtDiagram, ScenarioRepresentation tgtTree, Node<InteractionFragment> currentSrcNode, AbstractEnd absMsg, List<AbstractEnd> unmappedMsg, IProgressMonitor progressMonitor) {
        InstanceRole instRole = absMsg.getCovered();
        if (instRole == null) throw new ProcessorException(Messages.ErrorAbstractEndNotLinkedToInstanceRole, this);
        AbstractInstance cpntInst = instRole.getRepresentedInstance();
        if (cpntInst == null) {
            tgtTree.cleanClonedElements();
            String message = MessageFormat.format(Messages.ErrorInstanceRoleNotLinked, instRole.getName());
            throw new ProcessorException(message, this);
        }
        AbstractType instType = cpntInst.getAbstractType();
        if (instType == null) {
            tgtTree.cleanClonedElements();
            String message = MessageFormat.format(Messages.ErrorInstanceNotTyped, cpntInst.getName());
            throw new ProcessorException(message, this);
        }
        boolean skipMsg = false;
        Component decomposedCpnt = this._isIntraLayerRefinement ? this.getDecomposedComponent() : null;
        MessageEndExt.COMPONENT_TYPE type = MessageEndExt.COMPONENT_TYPE.UNDEFINED;
        AbstractEventOperation invokedOperation = this.getOperation(absMsg);
        if (absMsg instanceof MessageEnd) {
            MessageEnd srcMsg = (MessageEnd)absMsg;
            type = MessageEndExt.getMessageEndType((MessageEnd)srcMsg);
            SequenceMessage srcSeqMsg = srcMsg.getMessage();
            if (srcSeqMsg == null) throw new ProcessorException(Messages.ErrorMessageEndNotLinkedToSequenceMessage, this);
            if (srcSeqMsg.getKind() == MessageKind.REPLY) {
                if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
                    type = MessageEndExt.COMPONENT_TYPE.SENDER;
                } else if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
                    type = MessageEndExt.COMPONENT_TYPE.RECEIVER;
                }
                SequenceMessage callbranch = SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)srcSeqMsg);
                if (callbranch != null && (unmappedMsg.contains(callbranch.getSendingEnd()) || unmappedMsg.contains(callbranch.getReceivingEnd()))) {
                    skipMsg = true;
                }
            }
            if (this._isIntraLayerRefinement) {
                skipMsg |= this.evaluateMessageSkip(srcSeqMsg, decomposedCpnt);
            }
            this.logMessageMapping(skipMsg, srcSeqMsg, type);
        } else if (absMsg instanceof ExecutionEnd) {
            type = MessageEndExt.COMPONENT_TYPE.RECEIVER;
            if (this._isIntraLayerRefinement) {
                skipMsg = this.evaluateMessageSkip((ExecutionEnd)absMsg, decomposedCpnt);
            }
        }
        if (skipMsg) return;
        this.refineMsg(srcTree, tgtTree, tgtDiagram, unmappedMsg, currentSrcNode, absMsg, instRole, decomposedCpnt, invokedOperation, type);
    }

    private void refine(ScenarioRepresentation srcTree, Scenario tgtDiagram, IProgressMonitor progressMonitor) {
        ArrayList<AbstractEnd> unmappedMsg = new ArrayList<AbstractEnd>();
        ScenarioRepresentation tgtTree = this.loadDiagram(tgtDiagram);
        this.linkDiagrams(srcTree, tgtTree);
        for (Node<InteractionFragment> currentSrcNode : srcTree.walk()) {
            InteractionFragment interactionFragment = currentSrcNode.getData();
            if (interactionFragment instanceof AbstractEnd) {
                this.refine(srcTree, tgtDiagram, tgtTree, currentSrcNode, (AbstractEnd)interactionFragment, unmappedMsg, progressMonitor);
            } else if (interactionFragment instanceof FragmentEnd) {
                this.refine(srcTree, tgtDiagram, tgtTree, currentSrcNode, (FragmentEnd)interactionFragment, unmappedMsg, progressMonitor);
            } else if (interactionFragment instanceof InteractionOperand) {
                this.refine(srcTree, tgtDiagram, tgtTree, currentSrcNode, (InteractionOperand)interactionFragment, unmappedMsg, progressMonitor);
            } else if (interactionFragment instanceof InteractionState) {
                this.refine(srcTree, tgtDiagram, tgtTree, currentSrcNode, (InteractionState)interactionFragment, unmappedMsg, progressMonitor);
            }
            progressMonitor.worked(5);
        }
        tgtTree.export(srcTree);
        String loggedMsg = MessageFormat.format(Messages.Processing_Succeeded, this.getName());
        this._logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
    }

    private AbstractEventOperation getOperation(AbstractEnd absMsg) {
        AbstractEventOperation invokedOp = AbstractEndExt.getOperation((AbstractEnd)absMsg);
        AbstractEventOperation finalOp = null;
        if (invokedOp != null) {
            finalOp = RefinementServices.getDelegatedOperation((CapellaElement)this._srcDiagram, (CapellaElement)this._tgtDiagram, invokedOp);
        }
        return finalOp;
    }

    @Override
    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        try {
            try {
                this.preprocessing(progressMonitor);
                ScenarioRepresentation srcTree = this.loadDiagram(this._srcDiagram);
                if (srcTree != null) {
                    ArrayList<Scenario> existingScenarios = new ArrayList<Scenario>();
                    if (this._tgtDiagram == null) {
                        NamedElement tgtElement = this._tgtElement instanceof Part ? ((Part)this._tgtElement).getType() : this._tgtElement;
                        for (CapellaElement target : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)this._srcDiagram, (EClass)InteractionPackage.Literals.SCENARIO)) {
                            if (!EcoreUtil2.isContainedBy((EObject)target, (EObject)tgtElement)) continue;
                            this._tgtDiagram = (Scenario)target;
                            existingScenarios.add(this._tgtDiagram);
                        }
                    } else {
                        existingScenarios.add(this._tgtDiagram);
                    }
                    int totalWork = 5 * srcTree.walk().size() * existingScenarios.size();
                    for (Scenario tgtDiagram : existingScenarios) {
                        String message = MessageFormat.format(Messages.ScenarioRefinement_Progress, this._srcDiagram.getName(), tgtDiagram.getName());
                        progressMonitor.beginTask(message, totalWork);
                        this.refine(srcTree, tgtDiagram, progressMonitor);
                        progressMonitor.done();
                    }
                    this.postprocessing(progressMonitor);
                }
                String loggedMsg = MessageFormat.format(Messages.ScenarioRefinement_Succeeded, this._srcDiagram.getName());
                this._logger.info((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
            }
            catch (RefinementException ex) {
                String loggedMsg = MessageFormat.format(Messages.ScenarioRefinement_Failed, this._srcDiagram.getName(), ex.getMessage());
                this._logger.error((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void addPluggedModules() {
        Object loggedMsg;
        Scenario srcDiagram = this.getContext();
        NamedElement target = this.getTarget();
        ExtensionPriorityComparator priorityComparator = new ExtensionPriorityComparator();
        if (this.loadAdditionalProcessors) {
            List<IConfigurationElement> preprocessorProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)PREPROCESSING_EXTENSION_ID));
            Collections.sort(preprocessorProvider, priorityComparator);
            for (IConfigurationElement configurationElement : preprocessorProvider) {
                loggedMsg = MessageFormat.format(Messages.NewPreProcessorProvider, configurationElement.getAttribute("id"));
                this._logger.debug((Object)new EmbeddedMessage((String)loggedMsg, "Refinement", (Object)srcDiagram));
                IProcessor processor = (IProcessor)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                if (processor == null) continue;
                processor.setContext((ModelElement)srcDiagram);
                processor.setTarget(target);
                this.addPlug(processor, IProcessor.ProcessingType.PREPROCESSING);
            }
        }
        List<IConfigurationElement> mapperProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)MAPPING_EXTENSION_ID));
        Collections.sort(mapperProvider, priorityComparator);
        for (IConfigurationElement configurationElement : mapperProvider) {
            loggedMsg = MessageFormat.format(Messages.NewMapperProvider, configurationElement.getAttribute("id"));
            this._logger.debug((Object)new EmbeddedMessage((String)loggedMsg, "Refinement", (Object)srcDiagram));
            IMapper mapper = (IMapper)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
            if (mapper == null) continue;
            this.addPlug(mapper);
        }
        List<IConfigurationElement> resolverProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)RESOLVING_EXTENSION_ID));
        Collections.sort(resolverProvider, priorityComparator);
        for (IConfigurationElement configurationElement : resolverProvider) {
            String loggedMsg2 = MessageFormat.format(Messages.NewResolverProvider, configurationElement.getAttribute("id"));
            this._logger.debug((Object)new EmbeddedMessage(loggedMsg2, "Refinement", (Object)srcDiagram));
            IResolver resolver = (IResolver)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
            if (resolver == null) continue;
            this.addPlug(resolver);
        }
        List<IConfigurationElement> schedulerProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)SCHEDULING_EXTENSION_ID));
        Collections.sort(schedulerProvider, priorityComparator);
        for (IConfigurationElement configurationElement : schedulerProvider) {
            String loggedMsg3 = MessageFormat.format(Messages.NewSchedulerProvider, configurationElement.getAttribute("id"));
            this._logger.debug((Object)new EmbeddedMessage(loggedMsg3, "Refinement", (Object)srcDiagram));
            IScheduler scheduler = (IScheduler)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
            if (scheduler == null) continue;
            this.addPlug(scheduler);
        }
        if (this.loadAdditionalProcessors) {
            List<IConfigurationElement> postprocessorProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)POSTPROCESSING_EXTENSION_ID));
            Collections.sort(postprocessorProvider, priorityComparator);
            for (IConfigurationElement configurationElement : postprocessorProvider) {
                String loggedMsg4 = MessageFormat.format(Messages.NewPostProcessorProvider, configurationElement.getAttribute("id"));
                this._logger.debug((Object)new EmbeddedMessage(loggedMsg4, "Refinement", (Object)srcDiagram));
                IProcessor processor = (IProcessor)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                if (processor == null) continue;
                processor.setContext((ModelElement)srcDiagram);
                processor.setTarget(target);
                this.addPlug(processor, IProcessor.ProcessingType.POSTPROCESSING);
            }
        }
    }

    private void linkDiagrams(ScenarioRepresentation srcDiagram, ScenarioRepresentation tgtDiagram) {
        srcDiagram.clean();
        for (Node<InteractionFragment> tgtNode : tgtDiagram.walk()) {
            InteractionFragment tgtMsg = tgtNode.getData();
            if (tgtMsg == null) continue;
            for (CapellaElement sc : RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)tgtMsg, (EClass)InteractionPackage.Literals.ABSTRACT_END)) {
                for (Node<InteractionFragment> srcNode : srcDiagram.walk()) {
                    if (srcNode.getData() != sc) continue;
                    tgtNode.relatedNode = srcNode;
                    srcNode.relatedNode = tgtNode;
                }
            }
        }
    }

    private ScenarioRepresentation loadDiagram(Scenario diagram) {
        ScenarioRepresentation tree = null;
        if (diagram != null) {
            tree = new ScenarioRepresentation(diagram);
        }
        return tree;
    }

    private void logMessageMapping(boolean skipMsg, SequenceMessage srcSeqMsg, MessageEndExt.COMPONENT_TYPE type) {
        String loggedMsg = skipMsg ? (srcSeqMsg.getKind() == MessageKind.REPLY ? MessageFormat.format(Messages.SkeepSequenceMessageReplyMapping, srcSeqMsg.getName()) : MessageFormat.format(Messages.SkeepSequenceMessageMapping, srcSeqMsg.getName())) : (type == MessageEndExt.COMPONENT_TYPE.RECEIVER ? (srcSeqMsg.getKind() == MessageKind.REPLY ? MessageFormat.format(Messages.TryMapSequenceMessageReplyReceiver, srcSeqMsg.getName()) : MessageFormat.format(Messages.TryMapSequenceMessageReceiver, srcSeqMsg.getName())) : (srcSeqMsg.getKind() == MessageKind.REPLY ? MessageFormat.format(Messages.TryMapSequenceMessageReplySender, srcSeqMsg.getName()) : MessageFormat.format(Messages.TryMapSequenceMessageSender, srcSeqMsg.getName())));
        this._logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
    }

    private void logUnmappedMessage(SequenceMessage srcSeqMsg, MessageEndExt.COMPONENT_TYPE type) {
        String loggedMsg = type == MessageEndExt.COMPONENT_TYPE.RECEIVER ? (srcSeqMsg.getKind() == MessageKind.REPLY ? MessageFormat.format(Messages.UnmappedSequenceMessageReplyReceiver, srcSeqMsg.getName()) : MessageFormat.format(Messages.UnmappedSequenceMessageReceiver, srcSeqMsg.getName())) : (srcSeqMsg.getKind() == MessageKind.REPLY ? MessageFormat.format(Messages.UnmappedSequenceMessageReplySender, srcSeqMsg.getName()) : MessageFormat.format(Messages.UnmappedSequenceMessageSender, srcSeqMsg.getName()));
        this._logger.warn((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._srcDiagram));
    }

    private boolean evaluateMessageSkip(SequenceMessage sequenceMessage, Component decomposedCpnt) {
        if (this._tgtElement instanceof Part) {
            return !this.isInteracting(sequenceMessage, this._tgtElement);
        }
        if (this._tgtElement instanceof Component) {
            return !this.isInteracting(sequenceMessage, (NamedElement)decomposedCpnt);
        }
        if (this._tgtElement instanceof LogicalArchitecture) {
            return !this.isInteracting(sequenceMessage, (NamedElement)decomposedCpnt);
        }
        return false;
    }

    private boolean evaluateMessageSkip(ExecutionEnd executionEnd, Component decomposedCpnt) {
        if (this._tgtElement instanceof Part) {
            return !this.isInteracting(executionEnd, this._tgtElement);
        }
        if (this._tgtElement instanceof Component) {
            return !this.isInteracting(executionEnd, (NamedElement)decomposedCpnt);
        }
        if (this._tgtElement instanceof LogicalArchitecture) {
            return !this.isInteracting(executionEnd, (NamedElement)decomposedCpnt);
        }
        return false;
    }

    private Component getDecomposedComponent() {
        if (this._tgtElement instanceof Part) {
            return (Component)((Part)this._tgtElement).getAbstractType();
        }
        if (this._tgtElement instanceof Component) {
            return (Component)this._tgtElement;
        }
        if (this._tgtElement instanceof LogicalArchitecture) {
            return (Component)this._tgtElement.eContainer();
        }
        return null;
    }

    protected void applyNamingRule(NamedElement scenario, NamedElement target) {
        this.applyNamingRule(scenario, target, scenario.getName());
    }

    protected void applyNamingRule(NamedElement scenario, NamedElement target, String name) {
        String scName = ScenarioRefinement.evaluateNamingRule(target, name);
        if (!scenario.getName().equals(scName)) {
            scenario.setName(scName);
        }
    }

    public static String evaluateNamingRule(NamedElement target, String name) {
        return name;
    }
}

