/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.shared.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.kitalpha.massactions.activator.MAActivator;
import org.polarsys.kitalpha.massactions.core.config.IMAConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAMenuConfiguration;
import org.polarsys.kitalpha.massactions.core.selection.LazyRowSelectionProvider;
import org.polarsys.kitalpha.massactions.core.table.IMATable;
import org.polarsys.kitalpha.massactions.core.table.layer.IMAComponent;
import org.polarsys.kitalpha.massactions.shared.helper.MASelectionHelper;
import org.polarsys.kitalpha.massactions.shared.messages.Messages;
import org.polarsys.kitalpha.massactions.shared.view.menucreator.MAColumnFilterMenuCreator;

public abstract class MAView
extends ViewPart
implements IMAComponent {
    private static final Log log = LogFactory.getLog(MAView.class);
    protected static AtomicLong idGenerator = new AtomicLong();
    protected Set<EObject> data;
    protected TransactionalEditingDomain editingDomain;
    protected IMATable table;
    protected Composite parent;
    protected MASelectionHelper selectionHelper;
    protected Action clearViewAction;
    protected Action newViewAction;
    protected Action filterAction;
    protected Action exportToCSVAction;
    protected LazyRowSelectionProvider selectionProvider;
    private static final String COLUMN_HEADER_MENU_SUFFIX = ".columnHeader";
    private static final String ROW_HEADER_MENU_SUFFIX = ".rowHeader";
    private static final String CORNER_MENU_SUFFIX = ".corner";
    private static final String BODY_MENU_SUFFIX = ".body";

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.data = new LinkedHashSet<EObject>();
        this.table = this.createTable(parent);
        this.configureDropAction();
        this.configureBarActions();
        this.configureSelectionProvider();
    }

    public abstract IMATable createTable(Composite var1);

    protected void actionsSetEnabled(boolean enabled) {
        this.filterAction.setEnabled(enabled);
        this.clearViewAction.setEnabled(enabled);
        this.exportToCSVAction.setEnabled(enabled);
    }

    public void dataChanged(Collection<EObject> newData) {
        StringBuilder dialogTitleBuilder = new StringBuilder(this.getTitle());
        StringBuilder dialogContentBuilder = new StringBuilder();
        boolean showDialogMessage = true;
        int numberOfSelectedElements = newData.size();
        boolean selectionShareSameDomain = this.getSelectionHelper().selectionSharesSameEditingDomain(newData);
        if (selectionShareSameDomain) {
            if (this.editingDomain == null) {
                this.editingDomain = this.getSelectionHelper().getEditingDomainForFirstElement(newData);
            }
            if (this.editingDomain != null && this.getSelectionHelper().isEditingDomainEqual(newData, this.editingDomain)) {
                showDialogMessage = false;
                boolean wasInitialized = this.table.isInitialized();
                this.data.addAll(newData);
                ArrayList<EObject> fastAccessData = new ArrayList<EObject>(this.data);
                this.table.dataChanged(fastAccessData);
                if (!wasInitialized) {
                    this.actionsSetEnabled(true);
                    this.selectionProvider.enable();
                    this.layout();
                    this.configureContextMenus();
                }
            } else {
                dialogContentBuilder.append(MessageFormat.format(Messages.MA_VIEW_MESSAGE_INFO_1, numberOfSelectedElements));
            }
        } else {
            dialogContentBuilder.append(MessageFormat.format(Messages.MA_VIEW_MESSAGE_INFO_2, numberOfSelectedElements));
        }
        if (showDialogMessage) {
            Shell activeSell = Display.getDefault().getActiveShell();
            String dialogTitle = dialogTitleBuilder.toString();
            String dialogContent = dialogContentBuilder.toString();
            MessageDialog.openInformation((Shell)activeSell, (String)dialogTitle, (String)dialogContent);
        }
    }

    public MASelectionHelper getSelectionHelper() {
        if (this.selectionHelper == null) {
            this.selectionHelper = this.createSelectionHelper();
        }
        return this.selectionHelper;
    }

    protected MASelectionHelper createSelectionHelper() {
        return new MASelectionHelper();
    }

    protected void configureDropAction() {
        int operations = 2;
        DropTarget target = new DropTarget((Control)this.parent, operations);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                Collection<EObject> validSelectionData = MAView.this.getSelectionHelper().getElementsFromSelection(selection);
                MAView.this.dataChanged(validSelectionData);
            }
        });
    }

    protected void configureBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.filterAction = this.createFilterAction();
        this.filterAction.setEnabled(false);
        toolBarManager.add((IAction)this.filterAction);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.newViewAction = this.createNewViewAction();
        menuManager.add((IAction)this.newViewAction);
        this.clearViewAction = this.createClearViewAction();
        this.clearViewAction.setEnabled(false);
        menuManager.add((IAction)this.clearViewAction);
        menuManager.add((IContributionItem)new Separator());
        this.exportToCSVAction = this.createExportToCSVAction();
        this.exportToCSVAction.setEnabled(false);
        menuManager.add((IAction)this.exportToCSVAction);
    }

    protected Action createClearViewAction() {
        Action action = new Action(Messages.MA_VIEW_CLEAR_TOOLTIP_TEXT){

            public void run() {
                MAView.this.clearView();
            }
        };
        action.setToolTipText(Messages.MA_VIEW_CLEAR_TOOLTIP_TEXT);
        action.setImageDescriptor(MAActivator.getDefault().getImageRegistry().getDescriptor("IMAGE_CLEAR"));
        return action;
    }

    protected Action createFilterAction() {
        Action action = new Action(Messages.MA_VIEW_FILTER_TOOLTIP_TEXT, 4){

            public void run() {
            }
        };
        action.setToolTipText(Messages.MA_VIEW_FILTER_TOOLTIP_TEXT);
        action.setImageDescriptor(MAActivator.getDefault().getImageRegistry().getDescriptor("IMAGE_FILTER"));
        action.setMenuCreator((IMenuCreator)new MAColumnFilterMenuCreator(this.table));
        return action;
    }

    protected Action createNewViewAction() {
        Action action = new Action(Messages.MA_VIEW_NEW_VIEW_TOOLTIP_TEXT){

            public void run() {
                IWorkbenchPartReference workbenchRef = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePartReference();
                String primaryViewId = workbenchRef.getId();
                String secondaryViewId = MAView.getSecondaryViewId();
                try {
                    MAView view = (MAView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(primaryViewId, secondaryViewId, 1);
                    view.setViewName(MAView.getViewName(workbenchRef.getPartName(), secondaryViewId));
                }
                catch (PartInitException e) {
                    log.error((Object)e.getMessage());
                }
            }
        };
        action.setToolTipText(Messages.MA_VIEW_NEW_VIEW_TOOLTIP_TEXT);
        action.setImageDescriptor(this.getNewViewIconDescriptor());
        return action;
    }

    protected ImageDescriptor getNewViewIconDescriptor() {
        return MAActivator.getDefault().getImageRegistry().getDescriptor("IMAGE_ADD");
    }

    protected Action createExportToCSVAction() {
        Action action = new Action(Messages.MA_VIEW_EXPORT_TO_CSV_TOOLTIP_TEXT){

            public void run() {
                NatTable natTable = MAView.this.table.getNatTable();
                ExportCommand exportCommand = new ExportCommand(natTable.getConfigRegistry(), natTable.getShell());
                natTable.doCommand((ILayerCommand)exportCommand);
            }
        };
        action.setToolTipText(Messages.MA_VIEW_EXPORT_TO_CSV_TOOLTIP_TEXT);
        action.setImageDescriptor(MAActivator.getDefault().getImageRegistry().getDescriptor("IMAGE_EXPORT_CSV"));
        return action;
    }

    protected void configureSelectionProvider() {
        this.selectionProvider = new LazyRowSelectionProvider(this.table);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    protected void configureContextMenus() {
        IMAConfiguration configuration = this.table.getTableBaseConfig();
        if (configuration instanceof MAConfiguration) {
            MAMenuConfiguration config = ((MAConfiguration)configuration).getMenuConfiguration();
            this.getSite().registerContextMenu(String.valueOf(this.getSite().getId()) + ROW_HEADER_MENU_SUFFIX, config.getRowHeaderMenuManager(), (ISelectionProvider)this.selectionProvider);
            this.getSite().registerContextMenu(String.valueOf(this.getSite().getId()) + COLUMN_HEADER_MENU_SUFFIX, config.getColumnHeaderMenuManager(), (ISelectionProvider)this.selectionProvider);
            this.getSite().registerContextMenu(String.valueOf(this.getSite().getId()) + CORNER_MENU_SUFFIX, config.getCornerMenuManager(), (ISelectionProvider)this.selectionProvider);
            this.getSite().registerContextMenu(String.valueOf(this.getSite().getId()) + BODY_MENU_SUFFIX, config.getBodyMenuManager(), (ISelectionProvider)this.selectionProvider);
        }
    }

    public static String getViewName(String baseName, String secondaryViewId) {
        return String.valueOf(baseName) + " " + secondaryViewId;
    }

    public static String getSecondaryViewId() {
        return String.valueOf(idGenerator.incrementAndGet());
    }

    protected String getCurrentSecondaryViewId() {
        return String.valueOf(idGenerator.get());
    }

    public void setViewName(String viewName) {
        this.setPartName(viewName);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void layout() {
        this.parent.layout();
    }

    public void clearView() {
        this.editingDomain = null;
        this.data.clear();
        this.table.dispose();
        this.actionsSetEnabled(false);
    }

    public void dispose() {
        super.dispose();
        this.table.dispose();
        this.table = null;
        this.clearViewAction = null;
        this.filterAction = null;
        this.newViewAction = null;
        this.exportToCSVAction = null;
        this.selectionProvider = null;
        this.data = null;
        this.editingDomain = null;
    }

    public IMATable getTable() {
        return this.table;
    }

    public Set<EObject> getData() {
        return this.data;
    }

    public boolean belongsToSession(Session session) {
        return session.getTransactionalEditingDomain().equals(this.editingDomain);
    }
}

