/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.projection.exchanges.ComponentExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.EntityExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.IExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.NodePhysicalComponentExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.PhysicalActorExchangesCreator;

public class ConnectionCreatorFactory {
    public static IExchangesCreator createConnectionCreator(Component component_p, Part part_p) {
        if (component_p instanceof Entity) {
            return new EntityExchangesCreator(component_p);
        }
        if (component_p instanceof LogicalComponent || component_p instanceof LogicalActor) {
            return new ComponentExchangesCreator(component_p, part_p);
        }
        if (component_p instanceof System || component_p instanceof Actor) {
            return new ComponentExchangesCreator(component_p, part_p);
        }
        if (component_p instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent pc = (AbstractPhysicalComponent)component_p;
            PhysicalComponentNature nature = pc.getNature();
            if (pc instanceof PhysicalActor) {
                return new PhysicalActorExchangesCreator(component_p, part_p);
            }
            if (nature == PhysicalComponentNature.NODE) {
                return new NodePhysicalComponentExchangesCreator(component_p, part_p);
            }
        }
        return new DefaultExchangesCreator(component_p);
    }
}

