/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.color;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.ui.color.EnvironmentSystemColorFactory;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.ColorStep;
import org.eclipse.sirius.viewpoint.description.ComputedColor;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;

public class RGBValuesProvider {
    private static final RGBValues RED = RGBValuesProvider.makeColor(255, 0, 0);
    private static final RGBValues GREEN = RGBValuesProvider.makeColor(0, 255, 0);
    private static final Predicate<ColorStep> WELL_DEFINED_STEP = new Predicate<ColorStep>(){

        public boolean apply(ColorStep input) {
            return input.getAssociatedColor() != null && input.getAssociatedValue() != null && !"".equals(input.getAssociatedValue());
        }
    };

    public RGBValues getRGBValues(FixedColor object) {
        if (object != null) {
            return RGBValues.create(object.getRed(), object.getGreen(), object.getBlue());
        }
        return ViewpointFactory.eINSTANCE.createRGBValues();
    }

    public RGBValues getRGBValues(ComputedColor object, EObject evaluationContext, IInterpreter interpreter) {
        Integer blue;
        Integer green;
        Integer red = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Red());
        if (red == null) {
            red = 0;
        }
        if ((green = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Green())) == null) {
            green = 0;
        }
        if ((blue = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Blue())) == null) {
            blue = 0;
        }
        return RGBValuesProvider.makeColor(red, green, blue);
    }

    public RGBValues getRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        if (object.getColorSteps().isEmpty() || !Iterables.any(object.getColorSteps(), WELL_DEFINED_STEP)) {
            return this.getDefaultRGBValues(object, evaluationContext, interpreter);
        }
        return this.getInterpolatedRGBValues(object, evaluationContext, interpreter);
    }

    private RGBValues getInterpolatedRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        Integer closestLowerBound = Integer.MIN_VALUE;
        FixedColor closestLowerFixedColor = null;
        Integer minBound = Integer.MAX_VALUE;
        FixedColor minFixedColor = null;
        Integer closestUpperBound = Integer.MAX_VALUE;
        FixedColor closestUpperFixedColor = null;
        Integer maxBound = Integer.MIN_VALUE;
        FixedColor maxFixedColor = null;
        Integer value = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_ColorValueComputationExpression());
        if (value == null) {
            return this.getDefaultRGBValues(object, evaluationContext, interpreter);
        }
        for (ColorStep colorStep : Iterables.filter(object.getColorSteps(), WELL_DEFINED_STEP)) {
            Integer associatedValue = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, colorStep, (EStructuralFeature)DescriptionPackage.eINSTANCE.getColorStep_AssociatedValue());
            if (associatedValue != null && associatedValue > closestLowerBound && associatedValue <= value) {
                closestLowerBound = associatedValue;
                closestLowerFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue != null && associatedValue < closestUpperBound && associatedValue >= value) {
                closestUpperBound = associatedValue;
                closestUpperFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue != null && associatedValue < minBound) {
                minBound = associatedValue;
                minFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue == null || associatedValue <= maxBound) continue;
            maxBound = associatedValue;
            maxFixedColor = colorStep.getAssociatedColor();
        }
        if (closestLowerFixedColor == null) {
            closestLowerBound = minBound;
            closestLowerFixedColor = minFixedColor;
        }
        if (closestUpperFixedColor == null) {
            closestUpperBound = maxBound;
            closestUpperFixedColor = maxFixedColor;
        }
        closestLowerBound = closestLowerBound == null ? Integer.valueOf(0) : closestLowerBound;
        Integer n = closestUpperBound = closestUpperBound == null ? Integer.valueOf(1) : closestUpperBound;
        if (closestUpperBound <= closestLowerBound) {
            closestUpperBound = closestLowerBound + 1;
        }
        if (value < closestLowerBound) {
            value = (int)closestLowerBound;
        }
        if (value > closestUpperBound) {
            value = (int)closestUpperBound;
        }
        if (closestUpperBound <= closestLowerBound) {
            closestUpperBound = closestLowerBound + 1;
        }
        if (value > closestUpperBound) {
            value = closestUpperBound;
        }
        if (value < closestLowerBound) {
            value = closestLowerBound;
        }
        float scale = ((float)value.intValue() - (float)closestLowerBound.intValue()) / (float)(closestUpperBound - closestLowerBound);
        int valRed = (int)((float)closestLowerFixedColor.getRed() + (float)(closestUpperFixedColor.getRed() - closestLowerFixedColor.getRed()) * scale);
        int valGreen = (int)((float)closestLowerFixedColor.getGreen() + (float)(closestUpperFixedColor.getGreen() - closestLowerFixedColor.getGreen()) * scale);
        int valBlue = (int)((float)closestLowerFixedColor.getBlue() + (float)(closestUpperFixedColor.getBlue() - closestLowerFixedColor.getBlue()) * scale);
        return RGBValuesProvider.makeColor(valRed, valGreen, valBlue);
    }

    private RGBValues getDefaultRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        Integer min = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_MinValueComputationExpression());
        Integer max = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_MaxValueComputationExpression());
        Integer value = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_ColorValueComputationExpression());
        min = min == null ? Integer.valueOf(0) : min;
        max = max == null ? Integer.valueOf(1) : max;
        Integer n = value = value == null ? min : value;
        if (max <= min) {
            max = min + 1;
        }
        if (value < min) {
            value = (int)min;
        }
        if (value > max) {
            value = (int)max;
        }
        if (max <= min) {
            max = min + 1;
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        float scale = ((float)value.intValue() - (float)min.intValue()) / (float)(max - min);
        int valRed = (int)((float)GREEN.getRed() + (float)(RED.getRed() - GREEN.getRed()) * scale);
        int valGreen = (int)((float)GREEN.getGreen() + (float)(RED.getGreen() - GREEN.getGreen()) * scale);
        int valBlue = (int)((float)GREEN.getBlue() + (float)(RED.getBlue() - GREEN.getBlue()) * scale);
        return RGBValuesProvider.makeColor(valRed, valGreen, valBlue);
    }

    private static RGBValues makeColor(int red, int green, int blue) {
        return RGBValues.create(EnvironmentSystemColorFactory.clamp(red, 0, 255), EnvironmentSystemColorFactory.clamp(green, 0, 255), EnvironmentSystemColorFactory.clamp(blue, 0, 255));
    }

    private static Integer getIntFromAcceleoExpression(IInterpreter interpreter, EObject context, EObject descriptionObject, EStructuralFeature eFeature) {
        String computationExpression = (String)descriptionObject.eGet(eFeature);
        try {
            return interpreter.evaluateInteger(context, computationExpression);
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, eFeature, e);
            return 0;
        }
    }
}

