/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.helpers.CommonStructureHelper;

public class EPBSStructureHelper {
    public static PhysicalArchitecture getPhysicalArchitecture(SystemEngineering systemEngineering_p) {
        if (systemEngineering_p != null) {
            for (ModellingArchitecture arch : systemEngineering_p.getOwnedArchitectures()) {
                if (!(arch instanceof PhysicalArchitecture)) continue;
                return (PhysicalArchitecture)arch;
            }
        }
        return null;
    }

    public static PhysicalFunction getRootPhysicalFunction(SystemEngineering systemEngineering_p) {
        PhysicalFunctionPkg functionPkg;
        PhysicalArchitecture physicalArchitecture = EPBSStructureHelper.getPhysicalArchitecture(systemEngineering_p);
        if (physicalArchitecture != null && (functionPkg = (PhysicalFunctionPkg)physicalArchitecture.getOwnedFunctionPkg()) != null && !functionPkg.getOwnedPhysicalFunctions().isEmpty()) {
            return (PhysicalFunction)functionPkg.getOwnedPhysicalFunctions().get(0);
        }
        return null;
    }

    public static PhysicalComponent getRootPhysicalComponent(SystemEngineering systemEngineering_p) {
        PhysicalArchitecture physicalArchitecture = EPBSStructureHelper.getPhysicalArchitecture(systemEngineering_p);
        if (physicalArchitecture != null) {
            return physicalArchitecture.getOwnedPhysicalComponent();
        }
        return null;
    }

    public static Command getEPBSArchitectureCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createEPBSArchitectureCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemEngineering_p, (Object)new CommandParameter((Object)systemEngineering_p, (Object)CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES, (Object)EpbsFactory.eINSTANCE.createEPBSArchitecture(NamingConstants.CreateEPBSArchCmd_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createEPBSArchitectureCmd);
        CommandWrapper createEPBSArchitectureContentCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdEPBSArchitecture;
                Collection res = createEPBSArchitectureCmd.getResult();
                if (res.size() == 1 && (createdEPBSArchitecture = res.iterator().next()) instanceof EPBSArchitecture) {
                    return EPBSStructureHelper.getEPBSArchitectureCreationCmd(editingDomain_p, systemEngineering_p, (EPBSArchitecture)createdEPBSArchitecture);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createEPBSArchitectureContentCmd);
        return cmd;
    }

    public static Command getEPBSArchitectureCreationCmd(EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, EPBSArchitecture epbsArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        PhysicalArchitecture physicalArchitecture = EPBSStructureHelper.getPhysicalArchitecture(systemEngineering_p);
        cmd.append(CommonStructureHelper.getLinkCreationCmd(editingDomain_p, EpbsPackage.Literals.PHYSICAL_ARCHITECTURE_REALIZATION, EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_PHYSICAL_ARCHITECTURE_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)epbsArchitecture_p, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)physicalArchitecture));
        cmd.append(CommonStructureHelper.getRequirementPkgCreationCmd(editingDomain_p, (BlockArchitecture)epbsArchitecture_p));
        cmd.append(CommonStructureHelper.getCapabilityRealizationPkgCreationCmd(editingDomain_p, (BlockArchitecture)epbsArchitecture_p));
        cmd.append(EPBSStructureHelper.getRootConfigurationItemCreationCmd(editingDomain_p, systemEngineering_p, epbsArchitecture_p));
        return cmd;
    }

    public static Command getRootConfigurationItemCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p, EPBSArchitecture epbsArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createEPBSContextCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)epbsArchitecture_p, (Object)new CommandParameter((Object)epbsArchitecture_p, (Object)EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_EPBS_CONTEXT, (Object)EpbsFactory.eINSTANCE.createEPBSContext(NamingConstants.CreateEPBSArchCmd_epbsContext_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createEPBSContextCmd);
        final Command createConfigurationItemCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)epbsArchitecture_p, (Object)new CommandParameter((Object)epbsArchitecture_p, (Object)EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_CONFIGURATION_ITEM, (Object)EpbsFactory.eINSTANCE.createConfigurationItem(NamingConstants.CreateEPBSArchCmd_configurationItem_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createConfigurationItemCmd);
        CommandWrapper setKindCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdConfigurationItem;
                Collection res = createConfigurationItemCmd.getResult();
                if (res.size() == 1 && (createdConfigurationItem = res.iterator().next()) instanceof EObject) {
                    return new SetCommand(editingDomain_p, (EObject)createdConfigurationItem, (EStructuralFeature)EpbsPackage.Literals.CONFIGURATION_ITEM__KIND, (Object)ConfigurationItemKind.SYSTEM_CI);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setKindCmd);
        CommandWrapper createPhysicalComponentRealizationCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdConfigurationItem;
                Collection res = createConfigurationItemCmd.getResult();
                if (res.size() == 1 && (createdConfigurationItem = res.iterator().next()) instanceof EObject) {
                    PhysicalComponent rootPhysicalComponent = EPBSStructureHelper.getRootPhysicalComponent(systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(editingDomain_p, EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION, EpbsPackage.Literals.CONFIGURATION_ITEM__OWNED_PHYSICAL_ARTIFACT_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdConfigurationItem, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootPhysicalComponent);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPhysicalComponentRealizationCmd);
        CommandWrapper createPartCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdContext;
                Collection res = createEPBSContextCmd.getResult();
                if (res.size() == 1 && (createdContext = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdContext, (Object)new CommandParameter(createdContext, (Object)CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES, (Object)CsFactory.eINSTANCE.createPart()), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPartCmd);
        CommandWrapper setPartNameCmd = new CommandWrapper((Command)createPartCmd, createConfigurationItemCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createConfigurationItemCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createConfigurationItemCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createConfigurationItemCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdConfigurationItem = res2.iterator().next();
                    if (createdPart instanceof EObject && createdConfigurationItem instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)((AbstractNamedElement)createdConfigurationItem).getName());
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartNameCmd);
        CommandWrapper setPartTypeCmd = new CommandWrapper((Command)createPartCmd, createConfigurationItemCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createConfigurationItemCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createConfigurationItemCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createConfigurationItemCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdConfigurationItem = res2.iterator().next();
                    if (createdPart instanceof EObject && createdConfigurationItem instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, createdConfigurationItem);
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartTypeCmd);
        return cmd;
    }
}

