/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.extension.migration.egf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.extension.migration.egf.EcoreGenModelGenerator;

public class GenerateGenModelsTask
implements ITaskProduction {
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        ArrayList<GenModel> genModels = new ArrayList<GenModel>();
        this.generateGenModel(genModels, "/org.polarsys.capella.common.data.def/model/ModellingCore.ecore", "org.polarsys.capella.common.data.core.gen", "org.polarsys.capella.common.data");
        this.generateGenModel(genModels, "/org.polarsys.capella.common.data.def/model/Behavior.ecore", "org.polarsys.capella.common.data.behavior.gen", "org.polarsys.capella.common.data");
        this.generateGenModel(genModels, "/org.polarsys.capella.common.data.def/model/Activity.ecore", "org.polarsys.capella.common.data.activity.gen", "org.polarsys.capella.common.data");
        this.generateGenModel(genModels, "/org.polarsys.capella.core.data.def/model/CapellaModeller.ecore", "org.polarsys.capella.core.data.gen", "org.polarsys.capella.core.data");
        this.generateGenModel(genModels, "/org.polarsys.capella.common.re.gen/model/re.ecore", "org.polarsys.capella.common.re.gen", "org.polarsys.capella.common");
        this.generateGenModel(genModels, "/org.polarsys.capella.common.libraries.gen/model/libraries.ecore", "org.polarsys.capella.common.libraries.gen", "org.polarsys.capella.common");
    }

    private void generateGenModel(final List<GenModel> genModels_p, String ecorePath_p, String pluginId_p, String basePackage_p) {
        EcoreGenModelGenerator genModelGenerator = new EcoreGenModelGenerator(){

            @Override
            protected void addExternalGenModels(List<GenModel> genModelsP) {
                super.addExternalGenModels(genModelsP);
                genModelsP.addAll(genModels_p);
            }

            @Override
            public void setGenModelParameters(GenModel genModel_p) {
                super.setGenModelParameters(genModel_p);
                int year = Calendar.getInstance().get(1);
                genModel_p.setCopyrightText(" Copyright (c) 2006, " + year + " THALES GLOBAL SERVICES.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n\n Contributors:\n    Thales - initial API and implementation");
                if ("CapellaModeller".equals(genModel_p.getModelName())) {
                    for (GenPackage pack : genModel_p.getGenPackages()) {
                        if (!"Capellamodeller".equals(pack.getPrefix())) continue;
                        pack.setFileExtensions("melodymodeller");
                    }
                }
            }
        };
        genModelGenerator.setInputPath((IPath)new Path(ecorePath_p));
        genModelGenerator.setPluginId(pluginId_p);
        genModelGenerator.setBasePackagePrefix(basePackage_p);
        genModelGenerator.setModelDirectory("generated");
        genModelGenerator.setJdkComplianceLevel(GenJDKLevel.JDK60_LITERAL);
        genModelGenerator.setResourceType(GenResourceKind.XMI_LITERAL);
        genModelGenerator.setRootExtendsClass("org.eclipse.emf.ecore.impl.EObjectImpl");
        genModelGenerator.setRootExtendsInterface("org.eclipse.emf.ecore.EObject");
        genModelGenerator.setOperationReflection(false);
        GenModel model = genModelGenerator.execute((Monitor)new BasicMonitor());
        this.adaptGenPackagesToEcoreAnnotations(model);
        genModels_p.add(model);
    }

    private void adaptGenPackagesToEcoreAnnotations(GenModel model) {
        for (GenPackage genPackage : model.getAllGenPackagesWithClassifiers()) {
            String annotation = null;
            EPackage ecorePackage = genPackage.getEcorePackage();
            annotation = EcoreUtil.getAnnotation((EModelElement)ecorePackage, (String)"http://www.polarsys.org/kitalpha/emde/1.0.0/extension", (String)"childCreationExtenders");
            if (annotation != null) {
                genPackage.setChildCreationExtenders(Boolean.parseBoolean(annotation));
            }
            if ((annotation = EcoreUtil.getAnnotation((EModelElement)ecorePackage, (String)"http://www.polarsys.org/kitalpha/emde/1.0.0/extension", (String)"extensibleProviderFactory")) != null) {
                genPackage.setExtensibleProviderFactory(Boolean.parseBoolean(annotation));
            }
            try {
                genPackage.eResource().save(Collections.EMPTY_MAP);
                genPackage.getEcorePackage().eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

