/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;

public class DecompositionItem {
    public static final int ASSIGNED = 1;
    public static final int UNASSIGNED = 2;
    public static final int AMBIGUOUS = 3;
    private String name;
    private Object value;
    private int status;
    private String statusMessage;
    private DecompositionComponent parentComponent;
    private List<DecompositionItemService> serviceItems = new ArrayList<DecompositionItemService>();
    private boolean alreadyDecomposed;
    private String path;
    private List<Object> originInterfaces;
    private boolean isInterfaceUsage;
    private Map<Integer, Set<String>> statusDecompositionMap;
    private Set<String> messages;

    public DecompositionItem() {
        this(null, null, -1, false, "");
    }

    public DecompositionItem(String name, Object value, int status) {
        this.setName(name);
        this.setValue(value);
        this.setStatus(status);
        this.setStatusMessage("");
        this.statusDecompositionMap = new HashMap<Integer, Set<String>>(1);
        this.setMessages(new TreeSet<String>());
        this.originInterfaces = new ArrayList<Object>();
    }

    public DecompositionItem(String name, Object value, int status, boolean used, String path) {
        this(name, value, status);
        this.setInterfaceUsage(used);
        this.setPath(path);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean equals(Object object) {
        if (object instanceof DecompositionItem) {
            if (this == object) {
                return true;
            }
            if (this.getValue() == null) {
                return false;
            }
            DecompositionItem item = (DecompositionItem)object;
            Object value1 = this.getValue();
            Object value2 = item.getValue();
            if (value1 instanceof Interface && value2 instanceof Interface) {
                return value1.equals(value2) && this.isInterfaceUsage() == item.isInterfaceUsage();
            }
            if (value1 instanceof CommunicationLink && value2 instanceof CommunicationLink) {
                return CommunicationLinkExt.isSameCommunication((CommunicationLink)((CommunicationLink)value1), (CommunicationLink)((CommunicationLink)value2));
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public boolean isInterfaceUsage() {
        return this.isInterfaceUsage;
    }

    public void setInterfaceUsage(boolean used) {
        this.isInterfaceUsage = used;
    }

    public DecompositionComponent getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(DecompositionComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    public String toString() {
        return this.getName();
    }

    public DecompositionItem getCopy() {
        DecompositionItem copy = new DecompositionItem(this.getName(), this.getValue(), this.getStatus(), this.isInterfaceUsage(), this.getPath());
        for (DecompositionItemService itemSce : this.getServiceItems()) {
            DecompositionItemService itemSceCopy = itemSce.getCopy();
            itemSceCopy.setParentDecompositionItem(copy);
            copy.addServiceItems(itemSceCopy);
        }
        return copy;
    }

    public boolean isAlreadyDecomposed() {
        return this.alreadyDecomposed;
    }

    public void setAlreadyDecomposed(boolean alreadyDecomposed) {
        this.alreadyDecomposed = alreadyDecomposed;
    }

    public void addDecompositionNameForStatus(int status, String decompositionName) {
        Set<Object> tmp = null;
        if (this.statusDecompositionMap.containsKey(status)) {
            tmp = this.statusDecompositionMap.get(status);
            tmp.add(decompositionName);
            return;
        }
        tmp = new TreeSet<String>();
        tmp.add(decompositionName);
        this.statusDecompositionMap.put(status, tmp);
    }

    public void removeStatus(String message) {
        for (int key : this.statusDecompositionMap.keySet()) {
            Set<String> tmp = this.statusDecompositionMap.get(key);
            if (!tmp.remove(message)) continue;
            return;
        }
    }

    public boolean isInternal() {
        Interface currentItf;
        if (this.getValue() == null) {
            return true;
        }
        if (this.getValue() instanceof Interface && this.getParentComponent().getValue() != null && !RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)(currentItf = (Interface)this.getValue()), (EClass)CsPackage.Literals.INTERFACE).isEmpty()) {
            LogicalComponent lc = (LogicalComponent)this.getParentComponent().getValue();
            for (CapellaElement meloElt : LogicalComponentExt.getAllInterfacesInLogicalComponent((LogicalComponent)lc)) {
                Interface itf = (Interface)meloElt;
                if (!currentItf.equals(itf)) continue;
                return true;
            }
        }
        return false;
    }

    public void addStatusMessage(String message) {
        this.messages.add(message);
    }

    public Set<Integer> getStatusKeys() {
        return this.statusDecompositionMap.keySet();
    }

    public Set<String> getDecompositionNames(int key) {
        return this.statusDecompositionMap.get(key);
    }

    public Set<String> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<String> assignments) {
        this.messages = assignments;
    }

    public void clearMessages() {
        this.statusDecompositionMap.clear();
        this.setMessages(new TreeSet<String>());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<DecompositionItemService> getServiceItems() {
        return this.serviceItems;
    }

    public void setServiceItems(List<DecompositionItemService> items) {
        this.serviceItems = items;
    }

    public void addServiceItems(DecompositionItemService items) {
        this.serviceItems.add(items);
    }

    public void removeItem(DecompositionItemService itemSce) {
        this.serviceItems.remove(itemSce);
    }

    public List<Object> getOriginInterfaces() {
        return this.originInterfaces;
    }

    public void addOriginInterfaces(Object originInterface) {
        this.originInterfaces.add(originInterface);
    }
}

