/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.ui.toolkit.dialogs.MdeElementListSelectionDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.FieldsViewer;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionGeneralViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionLabelProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeCellModifier;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeNodeContentProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionVisitor;
import org.polarsys.capella.core.ui.toolkit.decomposition.IDecompositionDataConstants;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;
import org.polarsys.capella.core.ui.toolkit.decomposition.RenameDecompositionDialog;
import org.polarsys.capella.core.ui.toolkit.viewers.NamedElementFullLabelProvider;
import org.polarsys.capella.core.ui.toolkit.viewers.NamedElementLabelProvider;

public class DecompositionTargetViewer
extends FieldsViewer
implements IDecompositionDataConstants {
    private SelectionListener _buttonClickedListener;
    private Text _decompNameText;
    private DecompositionModel _decompositionModel;
    private ToolBar _decompToolBar;
    private DecompositionGeneralViewer _generalViewer;
    private ToolItem _newDecompItem;
    private ToolItem _newTargetItem;
    private ToolItem _removeDecompItem;
    private ToolItem _removeTargetItem;
    private Group _rightComposite;
    private List<CapellaElement> _shortcutItems;
    private CTabFolder _tabFolder;
    private Menu _targetMenu;
    private ToolBar _targetToolBar;
    private TreeViewer _targetTreeViewer;

    public DecompositionTargetViewer(Composite parent_p, DecompositionGeneralViewer viewer_p) {
        super(parent_p);
        this._generalViewer = viewer_p;
        this._decompositionModel = this._generalViewer.getDecompositionModel();
        this.initializeListeners();
        this.createViewer(parent_p);
    }

    public void addShortcutInput(CapellaElement element_p) {
        if (this._shortcutItems != null) {
            this._shortcutItems.add(element_p);
        }
    }

    private void addTargetComponentValidationListener(final Text text_p, final Decomposition decomposition_p) {
        text_p.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event_p) {
            }

            public void keyReleased(KeyEvent event_p) {
                String newName = text_p.getText();
                if (newName != null) {
                    if (newName.trim().length() == 0) {
                        DecompositionTargetViewer.this._generalViewer.showErrorMessage(Messages.getString("LCDecompGeneralViewer.rename.empty.errormsg"));
                        return;
                    }
                    if (newName.trim().length() > 0) {
                        if (!DecompositionUtil.isValidName(newName.trim(), decomposition_p)) {
                            DecompositionTargetViewer.this._generalViewer.showErrorMessage(Messages.getString("LCDecompGeneralViewer.targetcomp.rename.errormsg"));
                        } else {
                            DecompositionTargetViewer.this._generalViewer.showErrorMessage(null);
                        }
                    }
                }
            }
        });
    }

    protected Button createButton(Composite parent_p, String text_p, String tooltip_p, Object data_p) {
        Button button = new Button(parent_p, 8);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 0;
        gdData.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)gdData);
        button.setText(text_p);
        button.setToolTipText(tooltip_p);
        button.setData(data_p);
        button.addSelectionListener(this._buttonClickedListener);
        return button;
    }

    public void createDecompositionTab(Decomposition decomposition_p) {
        if (this._tabFolder == null || this._tabFolder.isDisposed()) {
            this._tabFolder = new CTabFolder((Composite)this._rightComposite, 0x1000000);
            this._tabFolder.addSelectionListener(this._buttonClickedListener);
            this._tabFolder.setMinimumCharacters(16);
            this._tabFolder.setBorderVisible(true);
            this._tabFolder.setSimple(false);
            this.setTabEditor();
        }
        Group comp = new Group((Composite)this._tabFolder, 0x1000020);
        comp.setText(Messages.getString("LCDecompGeneralViewer.current.decomp"));
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        Composite buttonComposite = new Composite((Composite)comp, 0x1000000);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.marginLeft = -5;
        layout.marginRight = -5;
        buttonComposite.setLayout((Layout)layout);
        this.createTargetToolItems(buttonComposite);
        GridData gdData = new GridData(768);
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)gdData);
        gdData = new GridData(1808);
        gdData.horizontalSpan = 6;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        Composite second = new Composite((Composite)comp, 0);
        second.setLayoutData((Object)gdData);
        second.setLayout((Layout)new FillLayout());
        this._tabFolder.setLayoutData((Object)gdData);
        this.createTargetContent(second);
        CTabItem item = new CTabItem(this._tabFolder, 0x1000000);
        item.setControl((Control)comp);
        item.setText(decomposition_p.getName());
        item.setData((Object)decomposition_p);
        this._targetTreeViewer.setInput((Object)decomposition_p);
        item.setData("TARGET_TREEVIEWER", (Object)this._targetTreeViewer);
        item.setData("REMOVE_TARGET_COMPONENT", (Object)this._removeTargetItem);
        CellEditor editor = this._targetTreeViewer.getCellEditors()[0];
        Text text = (Text)editor.getControl();
        this.addTargetComponentValidationListener(text, decomposition_p);
        this.setTreeCellEditor(item);
        this._rightComposite.layout();
        this._tabFolder.setSelection(item);
        this._generalViewer.getDecompositionModel().refreshStatus(decomposition_p);
        this._generalViewer.refreshItems(this._targetTreeViewer);
    }

    void createDND() {
        this._generalViewer.createDragDropSourceTargets(this._targetTreeViewer);
    }

    public Composite createInternalComposite(Composite parent_p) {
        return parent_p;
    }

    protected void createTargetContent(Composite composite_p) {
        this._targetTreeViewer = new TreeViewer(composite_p, 2818);
        this._targetTreeViewer.setColumnProperties(new String[]{"Component"});
        Tree tree = this._targetTreeViewer.getTree();
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)tree, 2048)};
        this._targetTreeViewer.setCellEditors(cellEditors);
        this._targetTreeViewer.setCellModifier((ICellModifier)new DecompositionTreeCellModifier(this._targetTreeViewer));
        this._targetTreeViewer.setLabelProvider((IBaseLabelProvider)new DecompositionLabelProvider(false, this._generalViewer.getDecompositionModel().getImgRegistry()));
        this._targetTreeViewer.setContentProvider((IContentProvider)new DecompositionTreeNodeContentProvider(this._decompositionModel));
        this._generalViewer.addSelectionListenerToViewer(this._targetTreeViewer);
    }

    private void createTargetToolItems(Composite customPart_p) {
        this._targetToolBar = new ToolBar(customPart_p, 256);
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        this._newTargetItem = this.createToolItem(this._targetToolBar, Messages.getString("LCDecompGeneralViewer.addtarget.tooltip"), "NEW_TARGET_COMPONENT", imgRegistry.get("toolitem.add"), 4);
        this._removeTargetItem = this.createToolItem(this._targetToolBar, Messages.getString("LCDecompGeneralViewer.removetarget.tooltip"), "REMOVE_TARGET_COMPONENT", imgRegistry.get("toolitem.remove"), 8);
        this._removeTargetItem.setEnabled(false);
    }

    private ToolItem createToolItem(ToolBar toolbar_p, String tooltip_p, Object data_p, Image image_p, int style) {
        ToolItem item = new ToolItem(toolbar_p, style);
        item.setData(data_p);
        item.setToolTipText(tooltip_p);
        item.setImage(image_p);
        item.addSelectionListener(this._buttonClickedListener);
        return item;
    }

    private void createViewer(Composite parent_p) {
        parent_p.setLayout((Layout)new FillLayout());
        this._rightComposite = new Group(parent_p, 0x1000020);
        this._rightComposite.setText(Messages.getString("LCDecompGeneralViewer.alterantive.decomp"));
        GridLayout rightLayout = new GridLayout();
        rightLayout.numColumns = 1;
        rightLayout.verticalSpacing = 5;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this._rightComposite.setLayout((Layout)rightLayout);
        Composite decompActionsComposite = new Composite((Composite)this._rightComposite, 0x1000000);
        GridLayout layout = new GridLayout();
        decompActionsComposite.setLayout((Layout)layout);
        layout.numColumns = 5;
        layout.marginLeft = -5;
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        decompActionsComposite.setLayoutData((Object)gdData);
        this._decompToolBar = new ToolBar(decompActionsComposite, 256);
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        this._newDecompItem = this.createToolItem(this._decompToolBar, Messages.getString("LCDecompGeneralViewer.adddecomp.tooltip"), "NEW_DECOMPOSITION", imgRegistry.get("toolitem.add"), 8);
        this._removeDecompItem = this.createToolItem(this._decompToolBar, Messages.getString("LCDecompGeneralViewer.removedecomp.tooltip"), "REMOVE_DECOMPOSITION", imgRegistry.get("toolitem.remove"), 8);
        this._newDecompItem.setEnabled(false);
        this._removeDecompItem.setEnabled(false);
        this.initMenus();
    }

    public Text getDecompNameText() {
        return this._decompNameText;
    }

    public DecompositionModel getDecompositionModel() {
        return this._decompositionModel;
    }

    public Object getInput() {
        return null;
    }

    public CTabFolder getTabFolder() {
        return this._tabFolder;
    }

    public TreeViewer getTargetTreeViewer() {
        return this._targetTreeViewer;
    }

    protected void handleButtonClicked(Widget button_p) {
        if (button_p.getData().equals("NEW_DECOMPOSITION")) {
            DecompositionVisitor.addNewDecomposition(this);
        } else if (button_p.getData().equals("REMOVE_DECOMPOSITION")) {
            DecompositionVisitor.removeSelectedDecomposition(this);
        } else if (button_p.getData().equals("REMOVE_ALL_DECOMPOSITION")) {
            DecompositionVisitor.removeAllDecomposition(this);
        } else if (button_p.getData().equals("RENAME_DECOMPOSITION")) {
            DecompositionVisitor.renameSelectedDecomposition(this);
        } else if (button_p.getData().equals("NEW_TARGET_COMPONENT")) {
            DecompositionVisitor.addNewTargetComponent(this);
        } else if (button_p.getData().equals("RENAME_TARGET_COMPONENT")) {
            DecompositionVisitor.renameTargetComponent(this);
        } else if (button_p.getData().equals("REMOVE_TARGET_COMPONENT")) {
            DecompositionVisitor.removeSelectedTargetComponent(this);
        } else if (button_p.getData().equals("REMOVE_ALL_TARGET_COMPONENTS")) {
            DecompositionVisitor.removeAllTargetComponent(this);
        } else if (button_p.getData().equals("DETACH_INTERFACE")) {
            DecompositionVisitor.detachInterface(this);
        } else if (button_p.getData().equals("REUSE_TARGET_COMPONENT")) {
            DecompositionVisitor.reuseComponent(this);
        }
    }

    protected void handleMenuSelected(Widget widget_p) {
        MenuItem item = (MenuItem)widget_p;
        if (item.getData().equals("NEW_TARGET_COMPONENT")) {
            DecompositionVisitor.addNewTargetComponent(this);
        } else if (item.getData().equals("REUSE_TARGET_COMPONENT")) {
            NamedElementLabelProvider _labelProvider = new NamedElementLabelProvider();
            NamedElementFullLabelProvider _statusLabelProvider = new NamedElementFullLabelProvider();
            MdeElementListSelectionDialog selectionDialog = new MdeElementListSelectionDialog(this._targetTreeViewer.getControl().getShell(), (ILabelProvider)_labelProvider, (ILabelProvider)_statusLabelProvider);
            selectionDialog.setTitle(Messages.getString("LCDecomp.title.label"));
            selectionDialog.setMultipleSelection(false);
            selectionDialog.setMatchEmptyString(true);
            selectionDialog.setIgnoreCase(true);
            selectionDialog.setHelpAvailable(true);
            DecompositionComponent sourceComponent = this._decompositionModel.getSourceComponent();
            Object value = sourceComponent.getValue();
            if (value instanceof LogicalComponent) {
                LogicalComponent lc = (LogicalComponent)value;
                Collection allAncestors = ComponentExt.getComponentAncestors((Component)lc);
                Collection allDescendants = ComponentExt.getAllSubUsedComponents((Component)lc);
                Collection allLCS = BlockArchitectureExt.getAllComponents((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)lc));
                allLCS.removeAll(allAncestors);
                allLCS.removeAll(allDescendants);
                allLCS.remove(lc);
                ArrayList<LogicalComponent> lclist = new ArrayList<LogicalComponent>();
                for (Component component : allLCS) {
                    if (!(component instanceof LogicalComponent)) continue;
                    lclist.add((LogicalComponent)component);
                }
                selectionDialog.setElements(lclist.toArray());
            }
            if (selectionDialog.open() == 0) {
                this._tabFolder.getSelection().setData("REUSE_TARGET_COMPONENT", selectionDialog.getFirstResult());
                DecompositionVisitor.reuseComponent(this);
            }
        }
    }

    protected void handleTabItemChanged(Widget widget_p) {
        this._generalViewer.createDNDForTargetViewer((CTabFolder)widget_p);
    }

    private void initializeListeners() {
        this._buttonClickedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                Widget widget = event_p.widget;
                if (widget instanceof Button || widget instanceof ToolItem) {
                    if (event_p.detail == 4 && widget.getData().equals("NEW_TARGET_COMPONENT")) {
                        Point point = new Point(event_p.x, event_p.y);
                        point = Display.getCurrent().map((Control)DecompositionTargetViewer.this._targetToolBar, null, point);
                        DecompositionTargetViewer.this._targetMenu.setLocation(point);
                        DecompositionTargetViewer.this._targetMenu.setVisible(true);
                    } else {
                        DecompositionTargetViewer.this.handleButtonClicked(widget);
                    }
                } else if (widget instanceof CTabFolder) {
                    DecompositionTargetViewer.this.handleTabItemChanged(widget);
                } else if (widget instanceof MenuItem) {
                    DecompositionTargetViewer.this.handleMenuSelected(widget);
                }
            }
        };
    }

    private void initMenus() {
        this._targetMenu = new Menu((Control)this._rightComposite.getShell());
        MenuItem lcMenuItem = new MenuItem(this._targetMenu, 8);
        lcMenuItem.setText(Messages.getString("LCDecomp.lc.menu.label"));
        lcMenuItem.addSelectionListener(this._buttonClickedListener);
        lcMenuItem.setData((Object)"NEW_TARGET_COMPONENT");
        MenuItem lcShortcutMenuItem = new MenuItem(this._targetMenu, 8);
        lcShortcutMenuItem.setText(Messages.getString("LCDecomp.lcreuse.menu.label"));
        lcShortcutMenuItem.addSelectionListener(this._buttonClickedListener);
        lcShortcutMenuItem.setData((Object)"REUSE_TARGET_COMPONENT");
    }

    void refreshItems(TreeViewer viewer) {
        if (this._tabFolder == null || this._tabFolder.isDisposed()) {
            this._generalViewer.refreshItems(null);
            return;
        }
        this._generalViewer.refreshItems(viewer);
    }

    public void removeShortcutInput(Object element_p) {
        if (this._shortcutItems != null) {
            this._shortcutItems.remove(element_p);
        }
    }

    public void setDecompNameText(Text decompNameText_p) {
        this._decompNameText = decompNameText_p;
    }

    public void setDecompositionFieldsEnabled(int size_p) {
        this._removeDecompItem.setEnabled(size_p > 1);
    }

    public void setDecompositionModel(DecompositionModel decompositionModel_p) {
        this._decompositionModel = decompositionModel_p;
    }

    void setDecompositionName(boolean flag) {
        List<Decomposition> list = this._decompositionModel.getDecompositions();
        int size = list.size();
        Decomposition firstDecomp = (Decomposition)this._tabFolder.getItem(0).getData();
        String name = Messages.getString("LCDecompGeneralViewer.decomposition.name");
        firstDecomp.setName(size > 1 ? (flag ? String.valueOf(name) + "0" : String.valueOf(name) + "1") : "");
        this._tabFolder.getItem(0).setText(firstDecomp.getName());
    }

    void setDefaultSelectedTabIndex() {
        this._tabFolder.setSelection(0);
        this._generalViewer.createDNDForTargetViewer(this._tabFolder);
    }

    public void setDetachInterfaceButtonEnabled(boolean isEnabled_p) {
    }

    public void setInput(Object input_p) {
    }

    void setRemoveTCButtonEnabled(boolean isEnabled_p) {
        ToolItem removeItem = (ToolItem)this._tabFolder.getSelection().getData("REMOVE_TARGET_COMPONENT");
        if (removeItem != null) {
            removeItem.setEnabled(isEnabled_p);
        }
    }

    private void setTabEditor() {
        if (this._tabFolder != null) {
            this._tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent me_p) {
                    if (DecompositionTargetViewer.this._tabFolder.getItemCount() > 1) {
                        CTabItem item = DecompositionTargetViewer.this._tabFolder.getSelection();
                        Point pt = new Point(me_p.x, me_p.y);
                        RenameDecompositionDialog popup = new RenameDecompositionDialog(DecompositionTargetViewer.this._tabFolder.getShell(), 540676, true, false, false, false, null, Messages.getString("LCDecompGeneralViewer.renamedecomp.popupinfo"), item, pt, DecompositionTargetViewer.this);
                        popup.open();
                        item.addListener(8, DecompositionUtil.getRenameDecompListener(item));
                    }
                }
            });
        }
    }

    public void setTabFolder(CTabFolder tabFolder_p) {
        this._tabFolder = tabFolder_p;
    }

    public void setTargetTreeViewer(TreeViewer targetTreeViewer_p) {
        this._targetTreeViewer = targetTreeViewer_p;
    }

    private void setTreeCellEditor(CTabItem item_p) {
        final TreeViewer viewer = (TreeViewer)item_p.getData("TARGET_TREEVIEWER");
        Tree tree = viewer.getTree();
        tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Object data;
                ((DecompositionTreeCellModifier)viewer.getCellModifier()).setEnabled(false);
                DecompositionTargetViewer.this._generalViewer.showErrorMessage(null);
                if (event != null && (data = event.data) != null && data.equals("rename")) {
                    DecompositionComponent comp = (DecompositionComponent)event.item.getData();
                    DecompositionTargetViewer.this._decompositionModel.setPathForNewTargetComponent(comp);
                    DecompositionTargetViewer.this._generalViewer.updateStatusBar(comp);
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event_p) {
                DecompositionVisitor.renameTargetComponent(DecompositionTargetViewer.this);
            }
        });
    }

    void showErrorMessage(String msg) {
        this._generalViewer.showErrorMessage(msg);
    }
}

