/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.re.ReNamedElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.ui.search.PatternFactory;
import org.polarsys.capella.core.ui.search.ReplaceInDescriptionSaxParser;
import org.polarsys.kitalpha.emde.model.Element;

public class CommandFactory {
    public static ICommand createReplaceAllInNameCommand(final Set<Element> matchingElements_p, final String findString_p, final String replaceString_p, final boolean caseSensitive, final boolean ignoreWildCards, boolean wholeWord, boolean regExSearch) {
        if (matchingElements_p.isEmpty()) {
            return null;
        }
        return new AbstractReadWriteCommand(){

            public void run() {
                for (Element elt : matchingElements_p) {
                    String label = null;
                    if (elt instanceof AbstractNamedElement) {
                        label = ((AbstractNamedElement)elt).getName();
                    }
                    if (elt instanceof ReNamedElement) {
                        label = ((ReNamedElement)elt).getName();
                    }
                    if (label == null) {
                        return;
                    }
                    String wildCardFindString = findString_p;
                    if (!ignoreWildCards) {
                        wildCardFindString = CommandFactory.wildCardsToRegexForName(findString_p);
                    }
                    String newName = CommandFactory.replaceAll(label, wildCardFindString, replaceString_p, caseSensitive, ignoreWildCards);
                    if (elt instanceof AbstractNamedElement) {
                        ((AbstractNamedElement)elt).setName(newName);
                    }
                    if (!(elt instanceof ReNamedElement)) continue;
                    ((ReNamedElement)elt).setName(newName);
                }
            }
        };
    }

    public static ICommand createReplaceAllInSummary(final Set<Element> matchingElements_p, final String findString_p, final String replaceString_p, boolean caseSensitive, final boolean ignoreWildCards, boolean wholeWord, boolean regExSearch) {
        if (matchingElements_p.isEmpty()) {
            return null;
        }
        return new AbstractReadWriteCommand(){

            public void run() {
                for (Element elt : matchingElements_p) {
                    if (!(elt instanceof CapellaElement)) continue;
                    CapellaElement capellaElt = (CapellaElement)elt;
                    String label = capellaElt.getSummary();
                    String wildCardFindString = findString_p;
                    if (!ignoreWildCards) {
                        wildCardFindString = CommandFactory.wildCardsToRegex(findString_p);
                    }
                    String newSummary = label.replaceAll(wildCardFindString, replaceString_p);
                    capellaElt.setSummary(newSummary);
                }
            }
        };
    }

    public static ICommand createReplaceAllInDescription(final Set<Element> matchingElements_p, final String findString_p, final String replaceString_p, boolean caseSensitive, final boolean ignoreWildCards, boolean wholeWord, boolean regExSearch) {
        if (matchingElements_p.isEmpty()) {
            return null;
        }
        return new AbstractReadWriteCommand(){

            public void run() {
                for (Element elt : matchingElements_p) {
                    if (!(elt instanceof CapellaElement)) continue;
                    String wildCardFindString = findString_p;
                    if (!ignoreWildCards) {
                        wildCardFindString = CommandFactory.wildCardsToRegex(findString_p);
                    }
                    ReplaceInDescriptionSaxParser parser = new ReplaceInDescriptionSaxParser();
                    parser.replace(wildCardFindString, replaceString_p, (EObject)elt);
                }
            }
        };
    }

    static String replaceAll(String name_p, String regex_p, String replacement_p, boolean caseSensitive_p, boolean ignoreWildCards_p) {
        Pattern p = PatternFactory.createPattern(regex_p, !caseSensitive_p, ignoreWildCards_p);
        Matcher m = p.matcher(name_p);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, replacement_p);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String wildCardsToRegex(String findString_p) {
        return findString_p.replace("?", ".?").replace("*", ".*?\\b");
    }

    public static String wildCardsToRegexForName(String findString_p) {
        return findString_p.replace("?", ".?").replace("*", ".*");
    }
}

