/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util.DataWidget;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;

public class EPFUtility {
    private static final Map<UIContainer, EPFUtility> EPF_Utility_List = new HashMap<UIContainer, EPFUtility>();
    protected ArrayList<DataWidget> generatedWidgetList = new ArrayList();
    protected ArrayList<UIContainer> generatedGroupList = new ArrayList();

    public static EPFUtility getEPFUtilityFor(UIContainer section) {
        EPFUtility result = EPF_Utility_List.get(section);
        if (result == null) {
            result = new EPFUtility();
            EPF_Utility_List.put(section, result);
        }
        return result;
    }

    public static void unloadResources() {
        EPF_Utility_List.clear();
    }

    public void registerClassToImportInMainClass(UIField uiField, String classQualifiedName) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        if (currentDataWidget != null && !currentDataWidget.generatedClassesImports.contains(classQualifiedName)) {
            currentDataWidget.generatedClassesImports.add(classQualifiedName);
        }
    }

    public ArrayList<DataWidget> getGeneratedWidgetList() {
        return this.generatedWidgetList;
    }

    public void generateDataforUIField(UIField uiField) {
        this.generatedWidgetList.add(new DataWidget(uiField));
    }

    public ArrayList<String> getSematicImportsFor(UIField uiField) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        return currentDataWidget.widgetSemanticImports;
    }

    public String getWidgetName(UIField uiField) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        return currentDataWidget != null ? currentDataWidget.widgetName : null;
    }

    public String getWidgetLabel(UIField uiField) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        return currentDataWidget != null ? currentDataWidget.widgetLabel : null;
    }

    public String getWidgetAccessor(UIField uiField) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        return currentDataWidget != null ? currentDataWidget.widgetFieldAccessorName : null;
    }

    public String getWidgetClassName(UIField uiField) {
        DataWidget currentDataWidget = this.getDataOf(uiField);
        return currentDataWidget != null ? currentDataWidget.widgetGraphicalClassName : null;
    }

    public DataWidget getDataOf(UIField uiField) {
        if (this.generatedWidgetList.isEmpty()) {
            return null;
        }
        for (DataWidget iWidgetData : this.generatedWidgetList) {
            if (!iWidgetData.uiField.equals(uiField)) continue;
            return iWidgetData;
        }
        return null;
    }
}

