/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class PluginUtility {
    public static void addPropertyTabsExtensions(String pluginName, Map<String, Map<String, String>> propertyTabs) throws CoreException {
        if (propertyTabs == null || propertyTabs.size() == 0) {
            return;
        }
        WorkspacePluginModel model = PluginUtility.getWorkspacePluginModel(pluginName);
        if (model == null) {
            return;
        }
        model.load();
        for (Map.Entry<String, Map<String, String>> tab : propertyTabs.entrySet()) {
            String contributorID = tab.getKey();
            Map<String, String> attrMap = propertyTabs.get(contributorID);
            PluginUtility.createPropertyTabsExtensionElement((IPluginModelBase)model, contributorID, attrMap);
        }
        model.save();
        model.dispose();
    }

    public static IPluginElement createPropertyTabsExtensionElement(IPluginModelBase pluginModelBase, String contributorID, Map<String, String> propertyTabAttributes) throws CoreException {
        IPluginElement propertyTabElement;
        IPluginExtension extension = null;
        try {
            extension = PluginUtility.createExtension(pluginModelBase, "org.eclipse.ui.views.properties.tabbed.propertyTabs");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (extension == null) {
            throw new IllegalStateException();
        }
        IPluginElement propertyTabsElement = PluginUtility.createPluginElement((IPluginParent)extension, "propertyTabs");
        if (propertyTabsElement != null) {
            propertyTabsElement.setAttribute("contributorId", contributorID);
        }
        if ((propertyTabElement = PluginUtility.createPluginElement((IPluginParent)propertyTabsElement, "propertyTab")) != null && propertyTabAttributes != null && !propertyTabAttributes.isEmpty()) {
            for (Map.Entry<String, String> attribute : propertyTabAttributes.entrySet()) {
                String attrName = attribute.getKey();
                String attrValue = propertyTabAttributes.get(attrName);
                propertyTabElement.setAttribute(attrName, attrValue);
            }
        }
        return propertyTabsElement;
    }

    public static IPluginExtension createExtension(IPluginModelBase pluginModelBase, String extensionPointId) throws CoreException {
        IPluginExtension extension = null;
        IPluginModelFactory pluginModelFactory = pluginModelBase.getPluginFactory();
        if (pluginModelFactory == null) {
            return null;
        }
        extension = pluginModelFactory.createExtension();
        if (extension == null) {
            return null;
        }
        extension.setPoint(extensionPointId);
        pluginModelBase.getExtensions().add(extension);
        return extension;
    }

    public static IPluginElement createPluginElement(IPluginParent parent, String name) throws CoreException {
        if (parent == null) {
            return null;
        }
        IPluginElement element = null;
        IExtensionsModelFactory factory = parent.getModel().getFactory();
        if (factory == null) {
            return null;
        }
        element = factory.createElement((IPluginObject)parent);
        if (element == null) {
            return null;
        }
        element.setName(name);
        parent.add((IPluginObject)element);
        return element;
    }

    public static WorkspacePluginModel getWorkspacePluginModel(String pluginName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginName);
        IFile file = PDEProject.getManifest((IProject)project);
        return file != null ? new WorkspacePluginModel(file, true) : null;
    }

    private PluginUtility() {
    }
}

