/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.capellamodeller.validation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.GeneralClass;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHKClassWithAbstractAttributes
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Class) {
            boolean isNotAbstractClass;
            Class classToValidate = (Class)eObj;
            boolean bl = isNotAbstractClass = !classToValidate.isAbstract();
            if (isNotAbstractClass) {
                ArrayList<IStatus> statuses = new ArrayList<IStatus>();
                this.validateAbstractClass(ctx, (GeneralClass)classToValidate, statuses);
                boolean isValidatedSuperClasses = this.validateAbstractSuperClass(ctx, (GeneralClass)classToValidate, (GeneralClass)classToValidate, statuses);
                if (isValidatedSuperClasses) {
                    IStatus failureStatus = ctx.createFailureStatus(new Object[]{"\"" + classToValidate.getName() + "\" (Class)", " inherited attribute", ""});
                    statuses.add(failureStatus);
                }
                if (!statuses.isEmpty()) {
                    return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private void validateAbstractClass(IValidationContext ctx, GeneralClass generalClass, Collection<IStatus> statuses) {
        EList properties = generalClass.getContainedProperties();
        for (Property property : properties) {
            if (property.getAssociation() == null) {
                boolean isAbstractAttr = property.isIsAbstract();
                if (!isAbstractAttr) continue;
                IStatus failureStatus = ctx.createFailureStatus(new Object[]{"\"" + generalClass.getName() + "\" (Class)", " attribute ", "\"" + property.getName() + "\" (Property)"});
                statuses.add(failureStatus);
                continue;
            }
            EList navigableMembers = property.getAssociation().getNavigableMembers();
            if (navigableMembers == null) continue;
            for (Property object : navigableMembers) {
                if (!object.isIsAbstract()) continue;
                IStatus failureStatus = ctx.createFailureStatus(new Object[]{"\"" + generalClass.getName() + "\" (Class)", " association role ", "\"" + property.getAssociation().getName() + "\" (Association)"});
                statuses.add(failureStatus);
            }
        }
    }

    private boolean validateAbstractSuperClass(IValidationContext ctx, GeneralClass classToValidate, GeneralClass generalClass, Collection<IStatus> statuses) {
        EList superGeneralizableElements = generalClass.getSuper();
        if (superGeneralizableElements != null && !superGeneralizableElements.isEmpty()) {
            for (Class cla : superGeneralizableElements) {
                boolean hasAbstractAttribute;
                boolean bl = hasAbstractAttribute = this.hasAbstractAttributeOrAssociationRole(classToValidate, cla, generalClass) || this.validateAbstractSuperClass(ctx, classToValidate, (GeneralClass)cla, statuses);
                if (!hasAbstractAttribute) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAbstractAttributeOrAssociationRole(GeneralClass classToValidate, Class generalClass, GeneralClass subClass) {
        EList properties = generalClass.getContainedProperties();
        for (Property property : properties) {
            if (property.getAssociation() == null) {
                boolean isAbstractAttr = property.isIsAbstract();
                if (!isAbstractAttr) continue;
                return !this.isOverridedProperty(classToValidate, subClass, property);
            }
            EList navigableMembers = property.getAssociation().getNavigableMembers();
            if (navigableMembers == null) continue;
            for (Property object : navigableMembers) {
                if (!object.isIsAbstract()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOverridedProperty(GeneralClass classToValidate, GeneralClass subClass, Property propertyToSearch) {
        EList properties = subClass.getContainedProperties();
        for (Property property : properties) {
            if (!property.getName().equals(propertyToSearch.getName())) continue;
            return true;
        }
        return this.isOverridedPropertyInSourceClass(classToValidate, propertyToSearch);
    }

    private boolean isOverridedPropertyInSourceClass(GeneralClass classToValidate, Property propertyToSearch) {
        EList properties = classToValidate.getContainedProperties();
        for (Property property : properties) {
            if (!property.getName().equals(propertyToSearch.getName())) continue;
            return true;
        }
        return false;
    }
}

