/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.validation.statetransition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class MDCHK_StateMachine_Function
extends AbstractModelConstraint {
    private static final String DO_ACTIVITY = "doActivity";
    private static final String ENTRY = "entry";
    private static final String EXIT = "exit";

    public IStatus validate(IValidationContext ctx) {
        State state = (State)ctx.getTarget();
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        EObject eContainer = state.eContainer();
        while (eContainer != null && !(eContainer instanceof Component) && !(eContainer instanceof Class)) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer instanceof Component) {
            boolean ok;
            List subComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)((Component)eContainer));
            subComponents.add((Component)eContainer);
            for (AbstractEvent activity : state.getDoActivity()) {
                ok = false;
                if (activity instanceof AbstractFunction) {
                    for (Component component : subComponents) {
                        ok |= component.getAllocatedFunctions().contains((Object)activity);
                    }
                }
                if (ok) continue;
                result.add(ctx.createFailureStatus(new Object[]{DO_ACTIVITY, activity.getName(), state.getName(), eContainer}));
            }
            for (AbstractEvent entry : state.getEntry()) {
                ok = false;
                if (entry instanceof AbstractFunction) {
                    for (Component component : subComponents) {
                        ok |= component.getAllocatedFunctions().contains((Object)entry);
                    }
                }
                if (ok) continue;
                result.add(ctx.createFailureStatus(new Object[]{ENTRY, entry.getName(), state.getName(), eContainer}));
            }
            for (AbstractEvent exit : state.getExit()) {
                ok = false;
                if (exit instanceof AbstractFunction) {
                    for (Component component : subComponents) {
                        ok |= component.getAllocatedFunctions().contains((Object)exit);
                    }
                }
                if (ok) continue;
                result.add(ctx.createFailureStatus(new Object[]{EXIT, exit.getName(), state.getName(), eContainer}));
            }
            if (!result.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, result);
            }
        }
        return ctx.createSuccessStatus();
    }
}

