/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition.IViewpointGenerationPrecondition;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition.Messages;

public class ViewpointGenerationPreconditionManager {
    public static final String PRECONDITION_EXTENSION_POINT_ID = "org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher.precondition";
    public static final String PRECONDITION_CONDITION_NAME = "condition";
    public static final String PRECONDITION_CONDITION_ATTR_NAME = "name";
    public static final String PRECONDITION_CONDITION_ATTR_CLASS = "class";
    public static final String PRECONDITION_CONDITION_ATTR_MESSAGE = "message";

    public static List<IStatus> checkPreconditions(Viewpoint viewpoint) throws CoreException {
        IExtension[] preconditions = ViewpointGenerationPreconditionManager.getPreconditions();
        if (preconditions.length > 0) {
            ArrayList<IStatus> failedPreconditionStatuses = new ArrayList<IStatus>();
            IExtension[] iExtensionArray = preconditions;
            int n = preconditions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurationElements;
                IExtension iExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurationElements = iExtension.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IStatus result;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
                    if (iConfigurationElement.getName().equals(PRECONDITION_CONDITION_NAME) && !(result = ViewpointGenerationPreconditionManager.checkCondition(viewpoint, iConfigurationElement)).equals(Status.OK_STATUS)) {
                        failedPreconditionStatuses.add(result);
                    }
                    ++n4;
                }
                ++n2;
            }
            return failedPreconditionStatuses;
        }
        return Collections.emptyList();
    }

    protected static IStatus checkCondition(Viewpoint viewpoint, IConfigurationElement conditionCE) throws CoreException {
        IViewpointGenerationPrecondition condition = (IViewpointGenerationPrecondition)conditionCE.createExecutableExtension(PRECONDITION_CONDITION_ATTR_CLASS);
        if (!condition.canGenerate(viewpoint)) {
            String cName = conditionCE.getAttribute(PRECONDITION_CONDITION_ATTR_NAME);
            String messageNok = Messages.bind((String)Messages.Precondition_Message_NOK, (Object)cName);
            String cMessage = conditionCE.getAttribute(PRECONDITION_CONDITION_ATTR_MESSAGE);
            String messageDetails = Messages.bind((String)Messages.Precondition_Message_Details, (Object)cMessage);
            StringBuffer buffer = new StringBuffer();
            buffer.append(messageNok);
            buffer.append(System.lineSeparator());
            buffer.append(messageDetails);
            return new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.generation.launcher", buffer.toString());
        }
        return Status.OK_STATUS;
    }

    protected static IExtension[] getPreconditions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PRECONDITION_EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            return extensionPoint.getExtensions();
        }
        return new IExtension[0];
    }
}

