/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.capellacommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class GetAvailable_StateTransitionTrigger__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = GetAvailable_StateTransitionTrigger__Lib.getAvailableElements(capellaElement);
        List currentElements = QueryInterpretor.executeQuery((String)"GetCurrent_StateTransitionTrigger", (Object)input, (IQueryContext)context);
        availableElements.removeAll(currentElements);
        return availableElements;
    }

    public static List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList();
        BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        if (element instanceof StateTransition) {
            Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
            for (IModel library : libraries) {
                BlockArchitecture correspondingBlock = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)currentBlock, (CapellaModel)((CapellaModel)library));
                for (BlockArchitecture block : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)correspondingBlock)) {
                    TreeIterator allContents = EcoreUtil.getAllContents((EObject)block, (boolean)false);
                    while (allContents.hasNext()) {
                        Object object = allContents.next();
                        if (!(object instanceof ExchangeItem) && !(object instanceof Operation)) continue;
                        availableElements.add((EObject)((CapellaElement)object));
                    }
                }
                TreeIterator allContents = EcoreUtil.getAllContents((EObject)correspondingBlock, (boolean)false);
                while (allContents.hasNext()) {
                    Object object = allContents.next();
                    if (!(object instanceof AbstractEvent) || object instanceof Event || object instanceof ExchangeItem || object instanceof Operation) continue;
                    availableElements.add((EObject)((CapellaElement)object));
                }
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }
}

