/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class AbstractDependenciesPkgExt {
    @Deprecated
    public static Collection<AbstractDependenciesPkg> getDependentPackages(AbstractDependenciesPkg pkg) {
        return AbstractDependenciesPkgExt.getDependencies(pkg);
    }

    public static Collection<AbstractDependenciesPkg> getDependencies2(AbstractDependenciesPkg pkg) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        if (pkg instanceof DataPkg) {
            dependencies.addAll(DataPkgExt.getDataPkgDependenciesHierarchy((DataPkg)pkg));
        }
        if (pkg instanceof InterfacePkg) {
            dependencies.addAll(InterfacePkgExt.getInterfacePkgDependenciesHierarchy((InterfacePkg)pkg));
        }
        return dependencies;
    }

    public static Collection<AbstractDependenciesPkg> getDependencies(AbstractDependenciesPkg pkg) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        if (pkg instanceof DataPkg) {
            dependencies.addAll(DataPkgExt.getDataPkgDependencies((DataPkg)pkg));
        }
        if (pkg instanceof InterfacePkg) {
            dependencies.addAll(InterfacePkgExt.getInterfacePkgDependencies((InterfacePkg)pkg));
        }
        return dependencies;
    }

    public static Collection<AbstractDependenciesPkg> getInverseDependencies(AbstractDependenciesPkg pkg) {
        ArrayList<AbstractDependenciesPkg> result = new ArrayList<AbstractDependenciesPkg>();
        ArrayList<AbstractDependenciesPkg> all = new ArrayList<AbstractDependenciesPkg>();
        Resource res = pkg.eResource();
        if (res != null) {
            ResourceSet rs = res.getResourceSet();
            TreeIterator it = rs.getAllContents();
            while (it.hasNext()) {
                Notifier next = (Notifier)it.next();
                if (!(next instanceof AbstractDependenciesPkg)) continue;
                all.add((AbstractDependenciesPkg)next);
            }
            for (AbstractDependenciesPkg current : all) {
                for (AbstractDependenciesPkg dependency : AbstractDependenciesPkgExt.getDependencies(current)) {
                    if (dependency != pkg) continue;
                    result.add(current);
                }
            }
        }
        return result;
    }

    private static void buildGraphOfDependencies(AbstractDependenciesPkg sourcePackage, Map<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> graphOfDependencies) {
        Collection<AbstractDependenciesPkg> sourcePackageDependencies = AbstractDependenciesPkgExt.getDependencies(sourcePackage);
        EObject itsContainer = sourcePackage.eContainer();
        while (itsContainer instanceof AbstractDependenciesPkg) {
            sourcePackageDependencies.addAll(AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)itsContainer));
            itsContainer = itsContainer.eContainer();
        }
        graphOfDependencies.put(sourcePackage, sourcePackageDependencies);
        for (AbstractDependenciesPkg aDependentPkg : sourcePackageDependencies) {
            if (graphOfDependencies.containsKey(aDependentPkg)) continue;
            AbstractDependenciesPkgExt.buildGraphOfDependencies(aDependentPkg, graphOfDependencies);
        }
    }

    public static boolean isADependencyAvailable(AbstractDependenciesPkg sourcePackage, AbstractDependenciesPkg targetPackage) {
        if (EcoreUtil.equals((EObject)sourcePackage, (EObject)targetPackage) || EcoreUtil.isAncestor((EObject)sourcePackage, (EObject)targetPackage)) {
            return true;
        }
        if (EcoreUtil.isAncestor((EObject)targetPackage, (EObject)sourcePackage)) {
            return false;
        }
        HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>> graphOfDependencies = new HashMap<AbstractDependenciesPkg, Collection<AbstractDependenciesPkg>>();
        AbstractDependenciesPkgExt.buildGraphOfDependencies(targetPackage, graphOfDependencies);
        for (AbstractDependenciesPkg aPackage : graphOfDependencies.keySet()) {
            if (!EcoreUtil.isAncestor((EObject)aPackage, (EObject)sourcePackage) && !aPackage.equals(sourcePackage)) continue;
            return false;
        }
        return true;
    }

    public static Collection<AbstractDependenciesPkg> getAllPackages(SystemEngineering root) {
        ArrayList<AbstractDependenciesPkg> returnedList = new ArrayList<AbstractDependenciesPkg>();
        PhysicalArchitecture pa = SystemEngineeringExt.getOwnedPhysicalArchitecture(root);
        returnedList.addAll(DataPkgExt.getAllDataPkgs((EObject)pa));
        returnedList.addAll(InterfacePkgExt.getAllInterfacePkgs((EObject)pa));
        return returnedList;
    }

    static void checkDependenciesAndAddToResult(Map<AbstractDependenciesPkg, Collection<EObject>> result, EObject eobject) {
        AbstractDependenciesPkg adp;
        if (eobject != null && (adp = (AbstractDependenciesPkg)EcoreUtil2.getFirstContainer((EObject)eobject, (EClass)CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG)) != null) {
            if (!result.containsKey(adp)) {
                HashSet set = new HashSet();
                result.put(adp, set);
            }
            result.get(adp).add(eobject);
        }
    }
}

