/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class PartExt {
    public static void addPart(AbstractType abstractType, Part part, ComponentArchitecture componentArchitecture) {
        SystemContext componentCtx = null;
        if (componentArchitecture instanceof SystemAnalysis) {
            componentCtx = ((SystemAnalysis)componentArchitecture).getOwnedSystemContext();
        } else if (componentArchitecture instanceof LogicalArchitecture) {
            componentCtx = ((LogicalArchitecture)componentArchitecture).getOwnedLogicalContext();
        } else if (componentArchitecture instanceof PhysicalArchitecture) {
            componentCtx = ((PhysicalArchitecture)componentArchitecture).getOwnedPhysicalContext();
        }
        if (componentCtx != null) {
            part.setAbstractType(abstractType);
            componentCtx.getOwnedFeatures().add((Object)part);
        }
    }

    public static final List<ComponentExchange> getComponentExchanges(Part part) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
        for (AbstractInformationFlow flow : part.getInformationFlows()) {
            if (!(flow instanceof ComponentExchange)) continue;
            componentExchanges.add((ComponentExchange)flow);
        }
        for (ComponentExchangeEnd end : FunctionalExt.getRelatedComponentExchangeEnds((Part)part)) {
            EObject owner = end.eContainer();
            if (!(owner instanceof ComponentExchange)) continue;
            componentExchanges.add((ComponentExchange)owner);
        }
        return componentExchanges;
    }

    public static List<Component> getComponentsOfParts(Collection<? extends Partition> parts) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Partition partition : parts) {
            if (!(partition.getAbstractType() instanceof Component)) continue;
            components.add((Component)partition.getAbstractType());
        }
        return components;
    }

    public static List<Part> getSubUsedParts(Part part) {
        return ComponentExt.getSubParts((PartitionableElement)((Component)part.getAbstractType()));
    }

    public static List<Part> getSubUsedAndDeployedParts(Part part) {
        ArrayList<Part> result = new ArrayList<Part>();
        result.addAll(PartExt.getDeployedParts(part));
        if (part.getAbstractType() != null) {
            result.addAll(ComponentExt.getSubParts((PartitionableElement)((Component)part.getAbstractType())));
        }
        return result;
    }

    public static List<DeployableElement> getDeployedElements(Part part) {
        ArrayList<DeployableElement> result = new ArrayList<DeployableElement>(1);
        EList deployments = part.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            PartDeploymentLink deploymentLink;
            DeployableElement deployedElement;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (deployedElement = (deploymentLink = (PartDeploymentLink)abstractDeployment).getDeployedElement()) == null) continue;
            result.add(deployedElement);
        }
        return result;
    }

    public static List<Part> getDeployedParts(Part part) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (DeployableElement element : PartExt.getDeployedElements(part)) {
            if (!(element instanceof Part)) continue;
            result.add((Part)element);
        }
        return result;
    }

    public static List<DeployableElement> getAllDeployableElements(Part part) {
        ArrayList<DeployableElement> result = new ArrayList<DeployableElement>(1);
        ArrayList<Part> parts = new ArrayList<Part>(1);
        List<DeployableElement> deployedElements = PartExt.getDeployedElements(part);
        result.addAll(deployedElements);
        for (DeployableElement deployableElement : deployedElements) {
            if (!(deployableElement instanceof Part)) continue;
            parts.add((Part)deployableElement);
        }
        for (Part partx : parts) {
            result.addAll(PartExt.getAllDeployableElements(partx));
        }
        return result;
    }

    public static boolean isDeploying(Part partDeployer, Part deployed) {
        EList deployments = partDeployer.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            PartDeploymentLink deploymentLink;
            DeployableElement deployedElement;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (deployedElement = (deploymentLink = (PartDeploymentLink)abstractDeployment).getDeployedElement()) == null || !deployedElement.equals(deployed)) continue;
            return true;
        }
        return false;
    }

    public static List<DeploymentTarget> getDeployingElements(Part part) {
        ArrayList<DeploymentTarget> result = new ArrayList<DeploymentTarget>(1);
        EList deployingLinks = part.getDeployingLinks();
        for (AbstractDeploymentLink abstractDeployment : deployingLinks) {
            PartDeploymentLink deploymentLink;
            DeploymentTarget location;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (location = (deploymentLink = (PartDeploymentLink)abstractDeployment).getLocation()) == null) continue;
            result.add(location);
        }
        return result;
    }

    public static List<Component> getAllDeployableComponents(Component component) {
        ArrayList<Component> result = new ArrayList<Component>(1);
        EList abstractTypedElements = component.getAbstractTypedElements();
        for (AbstractTypedElement abstractTypedElement : abstractTypedElements) {
            if (!(abstractTypedElement instanceof Part)) continue;
            Part part = (Part)abstractTypedElement;
            List<DeployableElement> deployedElements = PartExt.getAllDeployableElements(part);
            for (DeployableElement deployableElement : deployedElements) {
                AbstractType abstractType;
                if (!(deployableElement instanceof Part) || (abstractType = ((Part)deployableElement).getAbstractType()) == null || !(abstractType instanceof Component)) continue;
                result.add((Component)abstractType);
            }
        }
        return result;
    }

    public static List<Part> getAllPartsFromBlockArch(BlockArchitecture architecture) {
        ArrayList<CapellaElement> components = new ArrayList<CapellaElement>();
        ArrayList<Part> result = new ArrayList<Part>();
        BlockArchitectureExt.getAllComponentsFromBlockArchitecture(architecture, components);
        for (CapellaElement aComponent : components) {
            if (!(aComponent instanceof Component)) continue;
            Component currentComponent = (Component)aComponent;
            for (Partition aPartition : currentComponent.getRepresentingPartitions()) {
                if (!(aPartition instanceof Part)) continue;
                result.add((Part)aPartition);
            }
        }
        return result;
    }

    public static List<Part> getAllPartsFromPhysicalArchitecture(PhysicalArchitecture blockArch) {
        ArrayList<CapellaElement> components = new ArrayList<CapellaElement>();
        ArrayList<Part> result = new ArrayList<Part>();
        BlockArchitectureExt.getAllComponentsFromPA((BlockArchitecture)blockArch, components);
        for (CapellaElement aComponent : components) {
            if (!(aComponent instanceof AbstractPhysicalComponent)) continue;
            AbstractPhysicalComponent currentComponent = (AbstractPhysicalComponent)aComponent;
            for (Partition aPartition : currentComponent.getRepresentingPartitions()) {
                if (!(aPartition instanceof Part)) continue;
                result.add((Part)aPartition);
            }
        }
        return result;
    }

    public static Collection<Part> getFirstPartAncestors(Part currentPart) {
        LinkedList<Part> parents = new LinkedList<Part>();
        parents.addAll(PartExt.getDeployingElements(currentPart));
        Component directParent = ComponentExt.getDirectParent((Partition)currentPart);
        if (directParent != null) {
            parents.addAll((Collection<Part>)directParent.getRepresentingPartitions());
        }
        return parents;
    }
}

