/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPathReference;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.Messages;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.refmap.Pair;

public class PhysicalPathExt {
    static String PLUGIN_ID = "org.polarsys.capella.core.model.helpers";

    public static boolean isFirstPhysicalPathInvolvement(PhysicalPathInvolvement involment) {
        return involment.getInvolvedElement() != null && involment.getPreviousInvolvements().isEmpty();
    }

    public static boolean isLastPhysicalPathInvolvement(PhysicalPathInvolvement involment) {
        return involment.getInvolvedElement() != null && involment.getNextInvolvements().isEmpty();
    }

    public static Collection<PhysicalPathInvolvement> getFlatFirstPhysicalPathInvolvments(PhysicalPath physicalPath) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        LinkedList<PhysicalPath> toVisit = new LinkedList<PhysicalPath>();
        LinkedHashSet<PhysicalPath> visited = new LinkedHashSet<PhysicalPath>();
        toVisit.add(physicalPath);
        while (!toVisit.isEmpty()) {
            PhysicalPath chain = (PhysicalPath)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (PhysicalPathInvolvement involvement : chain.getOwnedPhysicalPathInvolvements()) {
                if (!PhysicalPathExt.isFirstPhysicalPathInvolvement(involvement)) continue;
                if (involvement.getInvolvedElement() instanceof PhysicalPath) {
                    toVisit.add((PhysicalPath)involvement.getInvolvedElement());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static Collection<PhysicalPathInvolvement> getFlatLastPhysicalPathInvolvments(PhysicalPath physicalPath) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        LinkedList<PhysicalPath> toVisit = new LinkedList<PhysicalPath>();
        LinkedHashSet<PhysicalPath> visited = new LinkedHashSet<PhysicalPath>();
        toVisit.add(physicalPath);
        while (!toVisit.isEmpty()) {
            PhysicalPath chain = (PhysicalPath)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (PhysicalPathInvolvement involvement : chain.getOwnedPhysicalPathInvolvements()) {
                if (!PhysicalPathExt.isLastPhysicalPathInvolvement(involvement)) continue;
                if (involvement.getInvolvedElement() instanceof PhysicalPath) {
                    toVisit.add((PhysicalPath)involvement.getInvolvedElement());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static List<PhysicalPath> getAllPhysicalPaths(BlockArchitecture architecture) {
        ArrayList<PhysicalPath> returnedList = new ArrayList<PhysicalPath>();
        if (architecture instanceof PhysicalArchitecture || architecture instanceof SystemAnalysis || architecture instanceof LogicalArchitecture) {
            for (Component aComponent : BlockArchitectureExt.getAllComponents(architecture)) {
                returnedList.addAll((Collection<PhysicalPath>)aComponent.getOwnedPhysicalPath());
            }
        }
        return returnedList;
    }

    public static Set<PhysicalPathInvolvement> getPreviousPhysicalLinkInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        LinkedList<PhysicalPathInvolvement> toVisit = new LinkedList<PhysicalPathInvolvement>();
        LinkedHashSet<PhysicalPathInvolvement> visited = new LinkedHashSet<PhysicalPathInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            PhysicalPathInvolvement involvment = (PhysicalPathInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (PhysicalPathInvolvement aPreviousInv : involvment.getPreviousInvolvements()) {
                if (aPreviousInv.getInvolvedElement() == null) continue;
                if (aPreviousInv.getInvolvedElement() instanceof PhysicalLink) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<PhysicalPathInvolvement> getFlatPreviousLinkInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement aPreviousInv : PhysicalPathExt.getFlatPreviousPhysicalPathInvolvements(involvement)) {
            if (aPreviousInv.getInvolvedElement() == null) continue;
            if (aPreviousInv.getInvolvedElement() instanceof PhysicalLink) {
                result.add(aPreviousInv);
                continue;
            }
            for (PhysicalPathInvolvement aaanv : PhysicalPathExt.getFlatPreviousPhysicalPathInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolvedElement() instanceof PhysicalLink)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static Set<PhysicalPathInvolvement> getNextPhysicalLinkInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        LinkedList<PhysicalPathInvolvement> toVisit = new LinkedList<PhysicalPathInvolvement>();
        LinkedHashSet<PhysicalPathInvolvement> visited = new LinkedHashSet<PhysicalPathInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            PhysicalPathInvolvement involvment = (PhysicalPathInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (PhysicalPathInvolvement aPreviousInv : involvment.getNextInvolvements()) {
                if (aPreviousInv.getInvolvedElement() == null) continue;
                if (aPreviousInv.getInvolvedElement() instanceof PhysicalLink) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<PhysicalPathInvolvement> getFlatNextExchangeInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement aPreviousInv : PhysicalPathExt.getFlatNextPhysicalPathInvolvements(involvement)) {
            if (aPreviousInv.getInvolvedElement() == null) continue;
            if (aPreviousInv.getInvolvedElement() instanceof PhysicalLink) {
                result.add(aPreviousInv);
                continue;
            }
            for (PhysicalPathInvolvement aaanv : PhysicalPathExt.getFlatNextPhysicalPathInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolvedElement() instanceof PhysicalLink)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static Set<PhysicalPathInvolvement> getFlatPreviousPhysicalPathInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement in : involvement.getPreviousInvolvements()) {
            if (in.getInvolvedElement() instanceof PhysicalPath) {
                result.addAll(PhysicalPathExt.getFlatFirstPhysicalPathInvolvments((PhysicalPath)in.getInvolvedElement()));
                result.addAll(PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)in.getInvolvedElement()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static Set<PhysicalPathInvolvement> getFlatNextPhysicalPathInvolvements(PhysicalPathInvolvement involvement) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement in : involvement.getNextInvolvements()) {
            if (in.getInvolvedElement() instanceof PhysicalPath) {
                result.addAll(PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)in.getInvolvedElement()));
                result.addAll(PhysicalPathExt.getFlatFirstPhysicalPathInvolvments((PhysicalPath)in.getInvolvedElement()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static Set<Part> getFlatPhysicalPathFirstParts(PhysicalPath physicalPath) {
        LinkedHashSet<Part> result = new LinkedHashSet<Part>();
        for (PhysicalPathInvolvement inv : PhysicalPathExt.getFlatFirstPhysicalPathInvolvments(physicalPath)) {
            if (!(inv.getInvolvedElement() instanceof Part)) continue;
            result.add((Part)inv.getInvolvedElement());
        }
        return result;
    }

    public static Set<Part> getFlatPhysicalPathLastParts(PhysicalPath physicalPath) {
        LinkedHashSet<Part> result = new LinkedHashSet<Part>();
        for (PhysicalPathInvolvement inv : PhysicalPathExt.getFlatLastPhysicalPathInvolvments(physicalPath)) {
            if (!(inv.getInvolvedElement() instanceof Part)) continue;
            result.add((Part)inv.getInvolvedElement());
        }
        return result;
    }

    public static Collection<PhysicalLink> getFlatOutgoingIncomingLinks(PhysicalPathInvolvement element) {
        LinkedHashSet<Part> targetFunctions = new LinkedHashSet<Part>();
        LinkedHashSet<PhysicalLink> targetExchanges = new LinkedHashSet<PhysicalLink>();
        AbstractPathInvolvedElement involvedElement = element.getInvolvedElement();
        if (involvedElement instanceof PhysicalLink) {
            targetExchanges.add((PhysicalLink)involvedElement);
        } else if (involvedElement instanceof Part) {
            targetFunctions.add((Part)involvedElement);
        } else if (involvedElement instanceof PhysicalPath) {
            targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)involvedElement));
            targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)involvedElement));
        }
        for (Part function : targetFunctions) {
            targetExchanges.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)function));
        }
        return targetExchanges;
    }

    @Deprecated
    public static Collection<PhysicalLink> getFlatIncomingLinks(PhysicalPathInvolvement element) {
        LinkedHashSet<Part> targetFunctions = new LinkedHashSet<Part>();
        LinkedHashSet<PhysicalLink> targetExchanges = new LinkedHashSet<PhysicalLink>();
        AbstractPathInvolvedElement involvedElement = element.getInvolvedElement();
        if (involvedElement instanceof PhysicalLink) {
            targetExchanges.add((PhysicalLink)involvedElement);
        } else if (involvedElement instanceof Part) {
            targetFunctions.add((Part)involvedElement);
        } else if (involvedElement instanceof PhysicalPath) {
            targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)involvedElement));
        }
        for (Part function : targetFunctions) {
            targetExchanges.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)function));
        }
        return targetExchanges;
    }

    @Deprecated
    public static Collection<PhysicalLink> getFlatOutgoingLinks(PhysicalPathInvolvement element) {
        LinkedHashSet<Part> sourceFunctions = new LinkedHashSet<Part>();
        LinkedHashSet<PhysicalLink> sourceExchanges = new LinkedHashSet<PhysicalLink>();
        AbstractPathInvolvedElement involvedElement = element.getInvolvedElement();
        if (involvedElement instanceof PhysicalLink) {
            sourceExchanges.add((PhysicalLink)involvedElement);
        } else if (involvedElement instanceof Part) {
            sourceFunctions.add((Part)involvedElement);
        } else if (involvedElement instanceof PhysicalPath) {
            sourceFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)involvedElement));
        }
        for (Part function : sourceFunctions) {
            sourceExchanges.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)function));
        }
        return sourceExchanges;
    }

    public static boolean isPhysicalPathValid(PhysicalPath path) {
        if (!PhysicalPathExt.isPhysicalPathWellFormed(path)) {
            return false;
        }
        EList sources = path.getFirstPhysicalPathInvolvements();
        if (sources.isEmpty()) {
            return false;
        }
        for (PhysicalPathInvolvement source : sources) {
            if (!PhysicalPathExt.containsACycle(source, new HashSet<PhysicalPathInvolvement>())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static Collection<PhysicalLink> getFlatIncomingLinks(PhysicalPath path) {
        LinkedHashSet<Part> targetFunctions = new LinkedHashSet<Part>();
        LinkedHashSet<PhysicalLink> targetExchanges = new LinkedHashSet<PhysicalLink>();
        targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts(path));
        for (Part function : targetFunctions) {
            targetExchanges.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)function));
        }
        return targetExchanges;
    }

    public static Collection<PhysicalLink> getFlatOutgoingIncomingLinks(PhysicalPath path) {
        LinkedHashSet<Part> targetFunctions = new LinkedHashSet<Part>();
        LinkedHashSet<PhysicalLink> targetExchanges = new LinkedHashSet<PhysicalLink>();
        targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts(path));
        targetFunctions.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts(path));
        for (Part function : targetFunctions) {
            targetExchanges.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)function));
        }
        return targetExchanges;
    }

    public static boolean isPhysicalPathWellFormed(PhysicalPath path) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (path.getOwnedPhysicalPathInvolvements().isEmpty()) {
            return false;
        }
        for (PhysicalPathInvolvement inv : PhysicalPathExt.getFlatInvolvements(path)) {
            if (!PhysicalPathExt.isPhysicalPathInvolvementValid(inv)) {
                return false;
            }
            if (!(inv.getInvolvedElement() instanceof PhysicalLink)) continue;
            PhysicalLink link = (PhysicalLink)inv.getInvolvedElement();
            Set<PhysicalPathInvolvement> previouses = PhysicalPathExt.getFlatPreviousPhysicalPathInvolvements(inv);
            Set<PhysicalPathInvolvement> nexts = PhysicalPathExt.getFlatNextPhysicalPathInvolvements(inv);
            LinkedHashSet<Part> previousParts = new LinkedHashSet<Part>();
            LinkedHashSet<Part> nextParts = new LinkedHashSet<Part>();
            for (PhysicalPathInvolvement involvment : previouses) {
                if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof Part)) continue;
                previousParts.add((Part)involvment.getInvolved());
            }
            for (PhysicalPathInvolvement involvment : nexts) {
                if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof Part)) continue;
                nextParts.add((Part)involvment.getInvolved());
            }
            LinkedHashSet linkedParts = new LinkedHashSet();
            linkedParts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)link));
            linkedParts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)link));
            previousParts.retainAll(linkedParts);
            nextParts.retainAll(linkedParts);
            for (Part previousPart : previousParts) {
                for (Part nextPart : nextParts) {
                    graph.addNode((Object)previousPart, (Object)nextPart);
                }
            }
        }
        if (graph.isEmpty()) {
            return false;
        }
        return graph.isAConnectedGraph();
    }

    public static Part getSourcePart(PhysicalPathInvolvement involvement) {
        if (involvement == null || involvement.getInvolvedElement() == null || !(involvement.getInvolvedElement() instanceof PhysicalLink) || involvement.getNextInvolvements().isEmpty() || ((PhysicalPathInvolvement)involvement.getNextInvolvements().get(0)).getInvolvedElement() == null) {
            return null;
        }
        PhysicalLink involvedLink = (PhysicalLink)involvement.getInvolvedElement();
        Part end1 = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)involvedLink);
        Part end2 = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)involvedLink);
        AbstractPathInvolvedElement nextInvoledElement = ((PhysicalPathInvolvement)involvement.getNextInvolvements().get(0)).getInvolvedElement();
        if (end1.equals(nextInvoledElement)) {
            return end2;
        }
        return end1;
    }

    public static Part getTargetPart(PhysicalPathInvolvement involvement) {
        if (involvement == null || involvement.getInvolvedElement() == null || !(involvement.getInvolvedElement() instanceof PhysicalLink) || involvement.getNextInvolvements().isEmpty() || ((PhysicalPathInvolvement)involvement.getNextInvolvements().get(0)).getInvolvedElement() == null) {
            return null;
        }
        PhysicalLink involvedLink = (PhysicalLink)involvement.getInvolvedElement();
        Part end1 = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)involvedLink);
        Part end2 = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)involvedLink);
        AbstractPathInvolvedElement nextInvoledElement = ((PhysicalPathInvolvement)involvement.getNextInvolvements().get(0)).getInvolvedElement();
        if (end1.equals(nextInvoledElement)) {
            return end1;
        }
        return end2;
    }

    public static IStatus isPhysicalPathInvolvementValidWithStatus(PhysicalPathInvolvement inv) {
        IStatus status = Status.OK_STATUS;
        String element = Messages.PhysicalPathExt_PhysicalComponent;
        String link = Messages.PhysicalPathExt_PhysicalLink;
        String path = Messages.PhysicalPathExt_PhysicalPath;
        String aElement = String.valueOf(Messages.FunctionalChainExt_a) + element;
        String aLink = String.valueOf(Messages.FunctionalChainExt_a) + link;
        String aPath = String.valueOf(Messages.FunctionalChainExt_a) + path;
        if (inv.getInvolvedElement() == null) {
            return new Status(4, PLUGIN_ID, Messages.Involvement_InvolvedNull);
        }
        if (inv instanceof PhysicalPathReference) {
            if (!(inv.getInvolved() instanceof PhysicalPath)) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNot, (Object)aPath));
            }
        } else if (!(inv.getInvolved() instanceof Part) && !(inv.getInvolved() instanceof PhysicalLink)) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNotAndNot, (Object)aElement, (Object)aLink));
        }
        if (inv.getInvolvedElement() instanceof PhysicalLink && inv.getNextInvolvements().size() != 1) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementWithMultipleNext, (Object)aLink));
        }
        if (inv.getInvolvedElement() instanceof Part && inv.getNextInvolvements().isEmpty() && inv.getPreviousInvolvements().isEmpty()) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvementAlone, (Object)aElement));
        }
        for (PhysicalPathInvolvement aNext : inv.getNextInvolvements()) {
            if (inv.getInvolvedElement() instanceof Part) {
                if (aNext.getInvolvedElement() == null || !(aNext.getInvolvedElement() instanceof PhysicalLink)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsButNextIsNotA, (Object)aElement, (Object)aLink));
                }
                Part currentPart = (Part)inv.getInvolvedElement();
                if (currentPart.equals(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)((PhysicalLink)aNext.getInvolvedElement()))) || currentPart.equals(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)((PhysicalLink)aNext.getInvolvedElement())))) continue;
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToSourceNext, (Object)aElement, (Object)link));
            }
            if (inv.getInvolvedElement() instanceof PhysicalLink) {
                if (aNext.getInvolved() == null || !(aNext.getInvolved() instanceof Part) && !(aNext.getInvolved() instanceof PhysicalPath)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_NextIsNotOrNot, (Object[])new Object[]{aLink, aElement, aPath}));
                }
                if (!PhysicalPathExt.getFlatCommonPhysicalLinks(inv, aNext).isEmpty()) continue;
                if (aNext.getInvolved() instanceof PhysicalPath) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNextFunctionalChain, (Object[])new Object[]{aLink, element, path}));
                }
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNext, (Object[])new Object[]{aLink, element, element}));
            }
            if (!(inv.getInvolved() instanceof PhysicalPath) || !PhysicalPathExt.getFlatCommonPhysicalLinks(inv, aNext).isEmpty()) continue;
            if (aNext.getInvolved() instanceof PhysicalPath) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNextFunctionalChain, (Object[])new Object[]{aPath, element, path}));
            }
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToOutgoingNext, (Object[])new Object[]{aPath, link, link}));
        }
        return status;
    }

    public static boolean isPhysicalPathInvolvementValid(PhysicalPathInvolvement inv) {
        return PhysicalPathExt.isPhysicalPathInvolvementValidWithStatus(inv).isOK();
    }

    public static boolean containsACycle(PhysicalPathInvolvement involvement1, Set<PhysicalPathInvolvement> visitedInvolvements1) {
        HashSet<PhysicalPathInvolvement> visitedInvolvements = new HashSet<PhysicalPathInvolvement>();
        LinkedList<PhysicalPathInvolvement> toVisit = new LinkedList<PhysicalPathInvolvement>();
        toVisit.add(involvement1);
        while (!toVisit.isEmpty()) {
            PhysicalPathInvolvement involvment = (PhysicalPathInvolvement)toVisit.removeFirst();
            if (visitedInvolvements.contains(involvment)) {
                return true;
            }
            visitedInvolvements.add(involvment);
            for (PhysicalPathInvolvement aNext : involvment.getNextInvolvements()) {
                toVisit.add(aNext);
            }
        }
        return false;
    }

    public static PhysicalPath createPhysicalPath(Component container, Collection<PhysicalLink> involvedPhysicalLinks, Part source) {
        PhysicalPath newPath = CsFactory.eINSTANCE.createPhysicalPath();
        container.getOwnedPhysicalPath().add((Object)newPath);
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)newPath);
        StrictCompoundCommand command = CreationHelper.getAdditionnalCommand((EditingDomain)editingDomain, (ModelElement)newPath);
        if (command.canExecute()) {
            command.execute();
        }
        PhysicalPathInvolvement previousPartInvolvement = PhysicalPathExt.createInvolvement(newPath, (AbstractPathInvolvedElement)source);
        int size = involvedPhysicalLinks.size();
        int i = 0;
        while (i < size) {
            Pair<PhysicalLink, Part> nextLinkPartPair = PhysicalPathExt.getNextLinkPartPair(involvedPhysicalLinks, previousPartInvolvement.getInvolved());
            if (nextLinkPartPair != null) {
                involvedPhysicalLinks.remove(nextLinkPartPair.getFirstValue());
                PhysicalPathInvolvement linkInvolvement = PhysicalPathExt.createInvolvement(newPath, (AbstractPathInvolvedElement)nextLinkPartPair.getFirstValue());
                previousPartInvolvement.getNextInvolvements().add((Object)linkInvolvement);
                PhysicalPathInvolvement nextPartInvolvement = PhysicalPathExt.createInvolvement(newPath, (AbstractPathInvolvedElement)nextLinkPartPair.getSecondValue());
                linkInvolvement.getNextInvolvements().add((Object)nextPartInvolvement);
                previousPartInvolvement = nextPartInvolvement;
            }
            ++i;
        }
        return newPath;
    }

    public static PhysicalPathInvolvement createInvolvement(PhysicalPath path, AbstractPathInvolvedElement involved) {
        PhysicalPathInvolvement newInv = CsFactory.eINSTANCE.createPhysicalPathInvolvement();
        path.getOwnedPhysicalPathInvolvements().add((Object)newInv);
        newInv.setInvolved((InvolvedElement)involved);
        return newInv;
    }

    public static List<AbstractPathInvolvedElement> getInvolvedElements(PhysicalPath path) {
        ArrayList<AbstractPathInvolvedElement> involvedElements = new ArrayList<AbstractPathInvolvedElement>();
        for (PhysicalPathInvolvement inv : path.getOwnedPhysicalPathInvolvements()) {
            if (inv.getInvolvedElement() == null) continue;
            involvedElements.add(inv.getInvolvedElement());
        }
        return involvedElements;
    }

    public static Collection<PhysicalPathInvolvement> getFlatInvolvements(PhysicalPath path) {
        ArrayList<PhysicalPathInvolvement> involvments = new ArrayList<PhysicalPathInvolvement>();
        LinkedList<PhysicalPath> toVisit = new LinkedList<PhysicalPath>();
        LinkedHashSet<PhysicalPath> visited = new LinkedHashSet<PhysicalPath>();
        toVisit.add(path);
        while (!toVisit.isEmpty()) {
            PhysicalPath chain = (PhysicalPath)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (PhysicalPathInvolvement involvement : chain.getOwnedPhysicalPathInvolvements()) {
                if (involvement.getInvolvedElement() != null && involvement.getInvolvedElement() instanceof PhysicalPath) {
                    toVisit.add((PhysicalPath)involvement.getInvolvedElement());
                }
                involvments.add(involvement);
            }
        }
        return involvments;
    }

    public static Collection<PhysicalPathInvolvement> getFlatInvolvementsOf(PhysicalPath path, EClass involvedClass) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement involvement : PhysicalPathExt.getFlatInvolvements(path)) {
            if (involvement.getInvolvedElement() == null || !involvedClass.isInstance((Object)involvement.getInvolvedElement())) continue;
            result.add(involvement);
        }
        return result;
    }

    public static Collection<EObject> getFlatInvolvedElements(PhysicalPath aPath, EClass involvedClass) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (PhysicalPathInvolvement involvement : PhysicalPathExt.getFlatInvolvements(aPath)) {
            if (involvement.getInvolvedElement() == null || !involvedClass.isInstance((Object)involvement.getInvolvedElement())) continue;
            result.add((EObject)involvement.getInvolvedElement());
        }
        return result;
    }

    public static Collection<PhysicalLink> getFlatPhysicalLinks(PhysicalPath key) {
        LinkedHashSet<PhysicalLink> result = new LinkedHashSet<PhysicalLink>();
        for (PhysicalPathInvolvement involvement : PhysicalPathExt.getFlatInvolvementsOf(key, CsPackage.Literals.PHYSICAL_LINK)) {
            if (involvement.getInvolvedElement() == null) continue;
            result.add((PhysicalLink)involvement.getInvolvedElement());
        }
        return result;
    }

    public static Collection<PhysicalLink> getFlatCommonPhysicalLinks(PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        Collection<PhysicalLink> sourceExchanges = PhysicalPathExt.getFlatOutgoingIncomingLinks(source);
        Collection<PhysicalLink> targetExchanges = PhysicalPathExt.getFlatOutgoingIncomingLinks(target);
        sourceExchanges.retainAll(targetExchanges);
        return sourceExchanges;
    }

    public static Set<PhysicalPathInvolvement> getInvolvementsOf(PhysicalPath physicalPath, EClass involvedClass) {
        LinkedHashSet<PhysicalPathInvolvement> result = new LinkedHashSet<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement anInvolvement : physicalPath.getOwnedPhysicalPathInvolvements()) {
            if (anInvolvement.getInvolvedElement() == null || !involvedClass.isInstance((Object)anInvolvement.getInvolvedElement())) continue;
            result.add(anInvolvement);
        }
        return result;
    }

    public static void synchronizeAllocations(PhysicalPath pPath, ComponentExchange cExchange) {
        Port ceSource = cExchange.getSourcePort();
        Port ceTarget = cExchange.getTargetPort();
        if (ceSource instanceof ComponentPort && ceTarget instanceof ComponentPort) {
            PhysicalPathExt.synchronizeAllocations(pPath, (ComponentPort)ceSource, (ComponentPort)ceTarget);
        }
    }

    private static void synchronizeAllocations(PhysicalPath pPath, ComponentPort ceSource, ComponentPort ceTarget) {
        PhysicalLinkExt.synchronizeAllocations(PhysicalPathExt.getPhysicalPortFrom(pPath, (InformationsExchanger)ceSource), ceSource);
        PhysicalLinkExt.synchronizeAllocations(PhysicalPathExt.getPhysicalPortFrom(pPath, (InformationsExchanger)ceTarget), ceTarget);
    }

    public static List<ModelElement> evaluateImpactsOfUnsynchronizeAllocations(PhysicalPath pPath, ComponentExchange cExchange, boolean forceCleaning) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        Port ceSource = cExchange.getSourcePort();
        Port ceTarget = cExchange.getTargetPort();
        if (ceSource instanceof ComponentPort && ceTarget instanceof ComponentPort) {
            result.addAll(PhysicalPathExt.unsynchronizeAllocations(pPath, (ComponentPort)ceSource, (ComponentPort)ceTarget, forceCleaning));
        }
        return result;
    }

    private static List<ModelElement> unsynchronizeAllocations(PhysicalPath pPath, ComponentPort ceSource, ComponentPort ceTarget, boolean forceCleaning) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        if (forceCleaning || PhysicalLinkExt.getExchangesFrom((ComponentExchangeAllocator)pPath, (InformationsExchanger)ceSource).isEmpty()) {
            result.addAll(PhysicalLinkExt.unsynchronizeAllocations(PhysicalPathExt.getPhysicalPortFrom(pPath, (InformationsExchanger)ceSource), ceSource));
        }
        if (forceCleaning || PhysicalLinkExt.getExchangesFrom((ComponentExchangeAllocator)pPath, (InformationsExchanger)ceTarget).isEmpty()) {
            result.addAll(PhysicalLinkExt.unsynchronizeAllocations(PhysicalPathExt.getPhysicalPortFrom(pPath, (InformationsExchanger)ceTarget), ceTarget));
        }
        return result;
    }

    private static Pair<PhysicalLink, Part> getNextLinkPartPair(Collection<PhysicalLink> involvedPhysicalLinks, InvolvedElement involvedPart) {
        for (PhysicalLink physicalLink : involvedPhysicalLinks) {
            Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)physicalLink);
            Part targetPart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)physicalLink);
            if (sourcePart.equals(involvedPart)) {
                return new Pair<PhysicalLink, Part>(physicalLink, targetPart);
            }
            if (!targetPart.equals(involvedPart)) continue;
            return new Pair<PhysicalLink, Part>(physicalLink, sourcePart);
        }
        return null;
    }

    private static PhysicalPort getPhysicalPortFrom(PhysicalPath pPath, InformationsExchanger cPort) {
        AbstractPathInvolvedElement involvedElt;
        ArrayList<PhysicalLink> terminalLinks = new ArrayList<PhysicalLink>();
        for (PhysicalPathInvolvement first : PhysicalPathExt.getFlatFirstPhysicalPathInvolvments(pPath)) {
            for (PhysicalPathInvolvement next : first.getNextInvolvements()) {
                involvedElt = next.getInvolvedElement();
                if (!(involvedElt instanceof PhysicalLink) || terminalLinks.contains(involvedElt)) continue;
                terminalLinks.add((PhysicalLink)involvedElt);
            }
        }
        for (PhysicalPathInvolvement last : PhysicalPathExt.getFlatLastPhysicalPathInvolvments(pPath)) {
            for (PhysicalPathInvolvement previous : last.getPreviousInvolvements()) {
                involvedElt = previous.getInvolvedElement();
                if (!(involvedElt instanceof PhysicalLink) || terminalLinks.contains(involvedElt)) continue;
                terminalLinks.add((PhysicalLink)involvedElt);
            }
        }
        for (PhysicalLink link : terminalLinks) {
            PhysicalPort port = PhysicalLinkExt.getPhysicalPortFrom(link, cPort);
            if (port == null) continue;
            return port;
        }
        return null;
    }
}

