/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.listeners;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.helpers.cs.services.ExchangeItemAllocationExt;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemElementExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;

public class CapellaModelDataListenerForExchangeItemsAndCommunicationLinks
extends CapellaModelDataListener {
    public void notifyChanged(Notification notification) {
        if (this.filterNotification(notification)) {
            return;
        }
        if (notification.getEventType() != 1 && notification.getEventType() != 3) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (feature != null) {
            Object notifier;
            if (notification.getEventType() == 1 && (feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__EXCHANGE_MECHANISM) || feature.equals(InformationPackage.Literals.EXCHANGE_ITEM_ELEMENT__KIND))) {
                Object notifier2 = notification.getNotifier();
                if (notifier2 instanceof ExchangeItem) {
                    final ExchangeItem item = (ExchangeItem)notifier2;
                    this.executeCommand((EObject)item, (ICommand)new AbstractReadWriteCommand(){

                        public void run() {
                            for (CommunicationLink link : CapellaModelDataListenerForExchangeItemsAndCommunicationLinks.getRelatedCommunicationLinks((AbstractExchangeItem)item)) {
                                CommunicationLinkExt.changeExchangeItem((CommunicationLink)link, (ExchangeItem)item);
                            }
                            for (ExchangeItemAllocation alloc : CapellaModelDataListenerForExchangeItemsAndCommunicationLinks.getRelatedAllocations((AbstractExchangeItem)item)) {
                                ExchangeItemAllocationExt.changeExchangeItem((ExchangeItemAllocation)alloc, (ExchangeItem)item);
                            }
                            for (ExchangeItemElement element : item.getOwnedElements()) {
                                ExchangeItemElementExt.changeExchangeItemElementKind((ExchangeItemElement)element, (ExchangeMechanism)item.getExchangeMechanism());
                            }
                        }
                    });
                } else if (notifier2 instanceof ExchangeItemElement) {
                    final ExchangeItemElement eie = (ExchangeItemElement)notifier2;
                    this.executeCommand((EObject)eie, (ICommand)new AbstractReadWriteCommand(){

                        public void run() {
                            if (eie.eContainer() != null) {
                                ExchangeItemElementExt.changeExchangeItemElementDirection((ExchangeItemElement)eie, (ExchangeMechanism)((ExchangeItem)eie.eContainer()).getExchangeMechanism());
                            }
                        }
                    });
                }
            } else if (notification.getEventType() == 3 && feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__OWNED_ELEMENTS) && (notifier = notification.getNotifier()) instanceof ExchangeItem) {
                final ExchangeItem item = (ExchangeItem)notifier;
                final Object newValue = notification.getNewValue();
                if (newValue != null && newValue instanceof ExchangeItemElement) {
                    this.executeCommand((EObject)item, (ICommand)new AbstractReadWriteCommand(){

                        public void run() {
                            ExchangeItemElementExt.changeExchangeItemElementKind((ExchangeItemElement)((ExchangeItemElement)newValue), (ExchangeMechanism)item.getExchangeMechanism());
                        }
                    });
                }
            }
        }
    }

    public static Collection<CommunicationLink> getRelatedCommunicationLinks(AbstractExchangeItem sndItem) {
        HashSet<CommunicationLink> result = new HashSet<CommunicationLink>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)sndItem, (EReference)CommunicationPackage.Literals.COMMUNICATION_LINK__EXCHANGE_ITEM)) {
            result.add((CommunicationLink)objectRef);
        }
        return result;
    }

    public static Collection<ExchangeItemAllocation> getRelatedAllocations(AbstractExchangeItem item) {
        HashSet<ExchangeItemAllocation> result = new HashSet<ExchangeItemAllocation>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)item, (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM)) {
            result.add((ExchangeItemAllocation)objectRef);
        }
        return result;
    }
}

