/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActor;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalContext;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.listeners.CapellaContainmentTreeListener;

public class PartComponentMoveListener
extends CapellaContainmentTreeListener {
    public boolean isPrecommitOnly() {
        return true;
    }

    protected Command handleContainmentTreeChange(Map<EObject, Notification> deleted, Map<EObject, Notification> moved) {
        CompoundCommand c = new CompoundCommand();
        for (EObject m : moved.keySet()) {
            Object notifier = moved.get(m).getNotifier();
            boolean isSingletonComponents = true;
            if (notifier instanceof EObject && CapellaProjectHelper.isSingletonComponentsDriven((EObject)((EObject)notifier)) != CapellaProjectHelper.TriStateBoolean.True) {
                isSingletonComponents = false;
            }
            if (!isSingletonComponents || !this.isCrossProjectMove(m, (EObject)moved.get(m).getNotifier())) continue;
            this.handleMoved(m, moved.get(m), c);
        }
        return c;
    }

    private void handleMoved(EObject moved, Notification notif, CompoundCommand c) {
        if (moved instanceof Component) {
            this.handleComponentMove((Component)moved, notif, c);
        } else if (moved instanceof Part) {
            this.handlePartMove((Part)moved, notif, c);
        }
        for (EObject e : moved.eContents()) {
            this.handleMoved(e, notif, c);
        }
    }

    private void handlePartMove(Part movedPart, Notification notif, CompoundCommand c) {
        if (movedPart.getAbstractType() instanceof Component && EcoreUtil.getRootContainer((EObject)movedPart) != EcoreUtil.getRootContainer((EObject)movedPart.getAbstractType())) {
            EPBSArchitecture epbs;
            AbstractType t = movedPart.getAbstractType();
            EntityPkg newParent = null;
            if (t instanceof OperationalActor || t instanceof Entity) {
                OperationalAnalysis oa = (OperationalAnalysis)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)OaPackage.Literals.OPERATIONAL_ANALYSIS);
                if (oa != null) {
                    newParent = oa.getOwnedEntityPkg();
                }
            } else if (t instanceof Actor) {
                SystemAnalysis sa = (SystemAnalysis)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS);
                if (sa != null) {
                    newParent = sa.getOwnedActorPkg();
                }
            } else if (t instanceof LogicalActor) {
                LogicalArchitecture la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
                if (la != null) {
                    newParent = la.getOwnedLogicalActorPkg();
                }
            } else if (t instanceof LogicalComponent) {
                LogicalArchitecture la;
                EObject parentCandidate = movedPart.eContainer();
                while (parentCandidate != null) {
                    if (parentCandidate instanceof LogicalComponent) {
                        newParent = parentCandidate;
                        break;
                    }
                    parentCandidate = parentCandidate.eContainer();
                }
                if (newParent == null && (la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) != null) {
                    newParent = la.getOwnedLogicalComponent();
                }
            } else if (t instanceof PhysicalActor) {
                PhysicalArchitecture pa = (PhysicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)PaPackage.Literals.PHYSICAL_ACTOR);
                if (pa != null) {
                    newParent = pa.getOwnedPhysicalActorPkg();
                }
            } else if (t instanceof PhysicalComponent) {
                PhysicalArchitecture pa;
                newParent = EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
                if (newParent == null && (pa = (PhysicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) != null) {
                    newParent = pa.getOwnedPhysicalComponent();
                }
            } else if (t instanceof ConfigurationItem && (newParent = EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)EpbsPackage.Literals.CONFIGURATION_ITEM)) == null && (epbs = (EPBSArchitecture)EcoreUtil2.getFirstContainer((EObject)movedPart, (EClass)EpbsPackage.Literals.EPBS_ARCHITECTURE)) != null) {
                newParent = epbs.getOwnedConfigurationItem();
            }
            if (newParent != null) {
                c.append(AddCommand.create((EditingDomain)this.getTarget(), (Object)newParent, null, Collections.singleton(t)));
            }
        }
    }

    private void handleComponentMove(Component movedComponent, Notification notif, CompoundCommand c) {
        ArrayList<Partition> toMove = new ArrayList<Partition>();
        for (Partition e : movedComponent.getRepresentingPartitions()) {
            if (EcoreUtil.getRootContainer((EObject)e) == EcoreUtil.getRootContainer((EObject)movedComponent)) continue;
            toMove.add(e);
        }
        if (toMove.size() > 0) {
            OperationalContext newParent = null;
            if (movedComponent instanceof OperationalActor || movedComponent instanceof Entity) {
                OperationalAnalysis oa = (OperationalAnalysis)EcoreUtil2.getFirstContainer((EObject)movedComponent, (EClass)OaPackage.Literals.OPERATIONAL_ANALYSIS);
                if (oa != null) {
                    newParent = oa.getOwnedOperationalContext();
                }
            } else if (movedComponent instanceof Actor) {
                SystemAnalysis sa = (SystemAnalysis)EcoreUtil2.getFirstContainer((EObject)movedComponent, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS);
                if (sa != null) {
                    newParent = sa.getOwnedSystemContext();
                }
            } else if (movedComponent instanceof LogicalActor) {
                LogicalArchitecture la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedComponent, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
                if (la != null) {
                    newParent = la.getOwnedLogicalContext();
                }
            } else if (movedComponent instanceof PhysicalActor) {
                PhysicalArchitecture pa = (PhysicalArchitecture)EcoreUtil2.getFirstContainer((EObject)movedComponent, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE);
                if (pa != null) {
                    newParent = pa.getOwnedPhysicalContext();
                }
            } else {
                EObject parent = movedComponent.eContainer();
                while (parent != null) {
                    if (parent instanceof PartitionableElement) {
                        newParent = parent;
                        break;
                    }
                    parent = parent.eContainer();
                }
            }
            if (newParent != null) {
                c.append(AddCommand.create((EditingDomain)this.getTarget(), (Object)newParent, null, toMove));
            }
        }
    }

    private boolean isCrossProjectMove(EObject moved, EObject oldParent) {
        return LibraryManager.INSTANCE.getModel(moved) != LibraryManager.INSTANCE.getModel(oldParent);
    }
}

