/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils;

import java.text.MessageFormat;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cs.delegates.PartNamingHelper;
import org.polarsys.capella.core.data.helpers.cs.services.CompositeStructureNamingHelper;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalAnalysisNamingHelper;
import org.polarsys.capella.core.data.helpers.information.services.DataValueNamingHelper;
import org.polarsys.capella.core.data.helpers.information.services.InformationNamingHelper;
import org.polarsys.capella.core.data.helpers.interaction.services.InteractionNamingHelper;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.utils.Messages;

public class NamingHelper {
    public static String getValue(EObject element, EStructuralFeature feature) {
        IItemLabelProvider labelProvider;
        if (element instanceof DataValue) {
            return DataValueNamingHelper.getValue((DataValue)((DataValue)element), (EStructuralFeature)feature);
        }
        if (element instanceof Part) {
            return PartNamingHelper.getValue((Part)((Part)element));
        }
        if (element instanceof Property) {
            return InformationNamingHelper.getValue((Property)((Property)element));
        }
        if (element instanceof Operation) {
            return InformationNamingHelper.getValue((Operation)((Operation)element));
        }
        if (element instanceof SequenceMessage) {
            return InteractionNamingHelper.getValue((SequenceMessage)((SequenceMessage)element));
        }
        if (element instanceof FunctionalExchange) {
            return FunctionalAnalysisNamingHelper.getValue((FunctionalExchange)((FunctionalExchange)element));
        }
        if (element instanceof ExchangeItemAllocation) {
            return CompositeStructureNamingHelper.getValue((ExchangeItemAllocation)((ExchangeItemAllocation)element));
        }
        if (element instanceof AbstractNamedElement && !(element instanceof ConfigurationItem)) {
            String name = ((AbstractNamedElement)element).getName();
            if (name == null || "".equals(name)) {
                return MessageFormat.format(Messages.getString("UnnamedValue"), element.eClass().getName());
            }
            return name;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element);
        if (editingDomain != null && (labelProvider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)element, IItemLabelProvider.class)) != null) {
            return labelProvider.getText((Object)element);
        }
        return Messages.getString("UndefinedValue");
    }
}

