/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.links.helpers.commands;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.links.helpers.LinkInfo;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.sirius.analysis.CsServices;

public class CreateGeneralizationsCommand
extends AbstractCreateLinksCommand {
    protected Generalization _createdGeneralization;

    public CreateGeneralizationsCommand() {
        super("Generalization", LinkInfo.LinkStyle.LINE_SOLID_WITH_EMPTY_ARROW);
    }

    public void execute() {
        GeneralizableElement target = (GeneralizableElement)this.getTargets().iterator().next();
        GeneralizableElement source = (GeneralizableElement)this.getSources().iterator().next();
        this._createdGeneralization = CapellacoreFactory.eINSTANCE.createGeneralization();
        source.getOwnedGeneralizations().add((Object)this._createdGeneralization);
        this._createdGeneralization.setSub(source);
        this._createdGeneralization.setSuper(target);
    }

    @Override
    public EObject getCreatedLinkObject() {
        return this._createdGeneralization;
    }

    protected boolean prepare() {
        if (this.getTargets() == null || 1 != this.getTargets().size()) {
            return false;
        }
        if (this.getSources() == null || this.getSources().isEmpty()) {
            return false;
        }
        EObject target = (EObject)this.getTargets().iterator().next();
        BlockArchitecture targetBLockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        if (targetBLockArchitecture == null) {
            return false;
        }
        for (EObject eObject : this.getSources()) {
            BlockArchitecture sourceBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)eObject);
            if (targetBLockArchitecture == sourceBlockArchitecture || BlockArchitectureExt.getPreviousBlockArchitectures((BlockArchitecture)sourceBlockArchitecture).contains(targetBLockArchitecture)) continue;
            return false;
        }
        for (EObject eObject : this.getSources()) {
            if (CsServices.getService().canReconnectGeneralization(eObject, eObject, target)) continue;
            return false;
        }
        return true;
    }
}

