/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCECategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateFECategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdatePLCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public abstract class UpdateCategoriesController {
    Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public static boolean isValidSelection(List<EObject> selection) {
        if (WizardActionHelper.areAllElementFunctionalExchange(selection)) {
            return true;
        }
        if (WizardActionHelper.areAllElementsComponentExchanges(selection)) {
            return true;
        }
        return WizardActionHelper.areAllElementsPhysicalLinks(selection);
    }

    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (element == null) {
            return result;
        }
        return null;
    }

    public static UpdateCategoriesController createUpdateCategoriesController(List<EObject> selection) {
        if (selection.isEmpty()) {
            return null;
        }
        EObject first = selection.get(0);
        if (first instanceof FunctionalExchange) {
            return new UpdateFECategoriesController();
        }
        if (first instanceof ComponentExchange) {
            return new UpdateCECategoriesController();
        }
        if (first instanceof PhysicalLink) {
            return new UpdatePLCategoriesController();
        }
        return null;
    }

    protected void logResults(String message, List<EObject> categories) {
        for (EObject cat : categories) {
            if (!(cat instanceof NamedElement)) continue;
            this._logger.info((Object)new EmbeddedMessage(StringHelper.formatMessage((String)message, (Object[])new String[]{((NamedElement)cat).getName()}), "Model Management", (Object)cat));
        }
    }

    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
    }

    public List<EObject> getCommonCategories(List<EObject> selection) {
        return null;
    }
}

