/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdateFECategoriesController
extends UpdateCategoriesController {
    public static final String MESSAGE = "Update functional exchange categories";

    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof FunctionalExchange)) continue;
            for (EObject removed : categoriesToRemove) {
                ((ExchangeCategory)removed).getExchanges().remove((Object)e);
            }
            for (EObject added : categoriesToAdd) {
                ((ExchangeCategory)added).getExchanges().add((Object)((FunctionalExchange)e));
            }
        }
        this.logResults(Messages.UpdateFECategories_add_msg, categoriesToAdd);
        this.logResults(Messages.UpdateFECategories_remove_msg, categoriesToRemove);
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject fe : element) {
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(fe.eClass(), (EStructuralFeature)FaPackage.Literals.FUNCTIONAL_EXCHANGE__CATEGORIES);
            if (query == null) continue;
            result.addAll(query.getAvailableElements(fe));
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof FunctionalExchange) {
            result.addAll((Collection<EObject>)((FunctionalExchange)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof FunctionalExchange)) continue;
            result.retainAll((Collection<?>)((FunctionalExchange)eObject).getCategories());
        }
        return result;
    }
}

