/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.session;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.platform.sirius.ui.session.Messages;

class LocalSessionCreationOperation
extends WorkspaceModifyOperation {
    static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    List<URI> _semanticURIs;
    URI _airdURI;
    Session _session;

    public LocalSessionCreationOperation(List<URI> semanticURIs, URI airdURI) {
        this._semanticURIs = semanticURIs;
        this._airdURI = airdURI;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CapellaSessionHelper_CreateSession_Title, (int)1);
        try {
            monitor.beginTask("Representations resource creation", 3);
            monitor.subTask("Session creation");
            this._session = SessionFactory.INSTANCE.createSession(this._airdURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.subTask("Add semantic model to the session");
            TransactionHelper.getExecutionManager((Session)this._session).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    for (URI uri : LocalSessionCreationOperation.this._semanticURIs) {
                        LocalSessionCreationOperation.this._session.addSemanticResource(uri, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
        }
        catch (CoreException exception) {
            __logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        progress.worked(1);
    }

    public Session getCreatedSession() {
        return this._session;
    }
}

