/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.LogEntryCacheUpdateHandler;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.core.subscribers.BatchingChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CheckedInChangeSetCollector
extends BatchingChangeSetManager
implements LogEntryCacheUpdateHandler.ILogsFetchedListener {
    private static final String LOG_ENTRY_HANDLER = "org.eclipse.team.cvs.ui.LogEntryHandler";
    IDiffChangeListener diffTreeListener = new IDiffChangeListener(){

        public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
        }

        public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
            if (event.getTree().isEmpty()) {
                ChangeSet changeSet = CheckedInChangeSetCollector.this.getChangeSet(event.getTree());
                if (changeSet != null) {
                    CheckedInChangeSetCollector.this.remove(changeSet);
                }
            } else {
                ChangeSet changeSet = CheckedInChangeSetCollector.this.getChangeSet(event.getTree());
                if (changeSet != null) {
                    CheckedInChangeSetCollector.this.fireResourcesChangedEvent(changeSet, this.getAffectedPaths(event));
                }
            }
        }

        private IPath[] getAffectedPaths(IDiffChangeEvent event) {
            IDiff diff;
            HashSet<IPath> result = new HashSet<IPath>();
            IPath[] removed = event.getRemovals();
            int i = 0;
            while (i < removed.length) {
                IPath path = removed[i];
                result.add(path);
                ++i;
            }
            IDiff[] diffs = event.getAdditions();
            int j = 0;
            while (j < diffs.length) {
                diff = diffs[j];
                result.add(diff.getPath());
                ++j;
            }
            diffs = event.getChanges();
            j = 0;
            while (j < diffs.length) {
                diff = diffs[j];
                result.add(diff.getPath());
                ++j;
            }
            return result.toArray(new IPath[result.size()]);
        }
    };
    private final ISynchronizePageConfiguration configuration;
    private boolean disposed;
    private RemoteLogOperation.LogEntryCache logEntryCache;
    private final Subscriber subscriber;
    private HashSet updatedSets;

    public CheckedInChangeSetCollector(ISynchronizePageConfiguration configuration, Subscriber subscriber) {
        this.configuration = configuration;
        this.subscriber = subscriber;
    }

    public final ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void handleSetAdded(ChangeSet set) {
        ((DiffChangeSet)set).getDiffTree().addDiffChangeListener(this.diffTreeListener);
        super.handleSetAdded(set);
        if (this.updatedSets != null) {
            this.updatedSets.add(set);
            ((DiffTree)((DiffChangeSet)set).getDiffTree()).beginInput();
        }
    }

    protected void handleSetRemoved(ChangeSet set) {
        ((DiffChangeSet)set).getDiffTree().removeDiffChangeListener(this.diffTreeListener);
        super.handleSetRemoved(set);
    }

    protected ChangeSet getChangeSet(IDiffTree tree) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet changeSet = sets[i];
            if (((DiffChangeSet)changeSet).getDiffTree() == tree) {
                return changeSet;
            }
            ++i;
        }
        return null;
    }

    public void handleChange(IDiffChangeEvent event) {
        ArrayList<IPath> removals = new ArrayList<IPath>();
        ArrayList<IDiff> additions = new ArrayList<IDiff>();
        removals.addAll(Arrays.asList(event.getRemovals()));
        additions.addAll(Arrays.asList(event.getAdditions()));
        IDiff[] changed = event.getChanges();
        int i = 0;
        while (i < changed.length) {
            IDiff diff = changed[i];
            additions.add(diff);
            removals.add(diff.getPath());
            ++i;
        }
        if (!removals.isEmpty()) {
            this.remove(removals.toArray(new IPath[removals.size()]));
        }
        if (!additions.isEmpty()) {
            this.add(additions.toArray(new IDiff[additions.size()]));
        }
    }

    protected void remove(IPath[] paths) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            DiffChangeSet set = (DiffChangeSet)sets[i];
            set.remove(paths);
            ++i;
        }
    }

    public synchronized LogEntryCacheUpdateHandler getLogEntryHandler() {
        LogEntryCacheUpdateHandler handler = (LogEntryCacheUpdateHandler)((Object)this.getConfiguration().getProperty(LOG_ENTRY_HANDLER));
        if (handler == null) {
            handler = this.initializeLogEntryHandler(this.getConfiguration());
        }
        handler.setListener(this);
        return handler;
    }

    private LogEntryCacheUpdateHandler initializeLogEntryHandler(final ISynchronizePageConfiguration configuration) {
        LogEntryCacheUpdateHandler logEntryHandler = new LogEntryCacheUpdateHandler(configuration);
        configuration.setProperty(LOG_ENTRY_HANDLER, (Object)logEntryHandler);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void dispose() {
                super.dispose();
                LogEntryCacheUpdateHandler handler = (LogEntryCacheUpdateHandler)((Object)configuration.getProperty(CheckedInChangeSetCollector.LOG_ENTRY_HANDLER));
                if (handler != null) {
                    handler.shutdown();
                    configuration.setProperty(CheckedInChangeSetCollector.LOG_ENTRY_HANDLER, null);
                }
            }
        });
        return logEntryHandler;
    }

    protected void add(IDiff[] diffs) {
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            try {
                handler.fetch(this.getSyncInfos(diffs));
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
    }

    private SyncInfo[] getSyncInfos(IDiff[] diffs) {
        SyncInfoSet set = new SyncInfoSet();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            set.add(this.getConverter().asSyncInfo(diff, this.getSubscriber().getResourceComparator()));
            ++i;
        }
        return set.getSyncInfos();
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void dispose() {
        this.disposed = true;
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            handler.setListener(null);
        }
        this.getConfiguration().setProperty("org.eclipse.team.cvs.ui.CVSCheckedInCollector", null);
        this.logEntryCache = null;
        super.dispose();
    }

    private void handleRemoteChanges(SyncInfo[] infos, RemoteLogOperation.LogEntryCache logEntries, IProgressMonitor monitor) {
        try {
            this.beginSetUpdate();
            this.addLogEntries(infos, logEntries, monitor);
        }
        finally {
            this.endSetUpdate(monitor);
        }
    }

    private void beginSetUpdate() {
        this.updatedSets = new HashSet();
    }

    private void endSetUpdate(IProgressMonitor monitor) {
        for (DiffChangeSet set : this.updatedSets) {
            try {
                ((DiffTree)set.getDiffTree()).endInput(monitor);
            }
            catch (RuntimeException e) {
                CVSUIPlugin.log(4, "Internal error", e);
            }
        }
        this.updatedSets = null;
    }

    private void addLogEntries(SyncInfo[] commentInfos, RemoteLogOperation.LogEntryCache logs, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, commentInfos.length * 10);
            if (logs != null) {
                int i = 0;
                while (i < commentInfos.length) {
                    this.addSyncInfoToCommentNode(commentInfos[i], logs);
                    monitor.worked(10);
                    ++i;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addSyncInfoToCommentNode(SyncInfo info, RemoteLogOperation.LogEntryCache logs) {
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            ICVSRemoteResource remoteResource = handler.getRemoteResource(info);
            if (handler.getSubscriber() instanceof CVSCompareSubscriber && remoteResource != null) {
                this.addMultipleRevisions(info, logs, remoteResource);
            } else {
                this.addSingleRevision(info, logs, remoteResource);
            }
        }
    }

    private void addSingleRevision(SyncInfo info, RemoteLogOperation.LogEntryCache logs, ICVSRemoteResource remoteResource) {
        ILogEntry logEntry = logs.getLogEntry(remoteResource);
        if (remoteResource != null && !remoteResource.isFolder()) {
            try {
                String remoteRevision = ((ICVSRemoteFile)remoteResource).getRevision();
                if (this.isDeletedRemotely(info)) {
                    ILogEntry[] logEntries = logs.getLogEntries(remoteResource);
                    int i = 0;
                    while (i < logEntries.length) {
                        ILogEntry entry = logEntries[i];
                        String revision = entry.getRevision();
                        if (entry.isDeletion() && ResourceSyncInfo.isLaterRevision((String)revision, (String)remoteRevision)) {
                            logEntry = entry;
                        }
                        ++i;
                    }
                }
            }
            catch (TeamException teamException) {}
        }
        this.addRemoteChange(info, remoteResource, logEntry);
    }

    private void addMultipleRevisions(SyncInfo info, RemoteLogOperation.LogEntryCache logs, ICVSRemoteResource remoteResource) {
        ILogEntry[] logEntries = logs.getLogEntries(remoteResource);
        if (logEntries == null || logEntries.length == 0) {
            this.addRemoteChange(info, null, null);
        } else {
            int i = 0;
            while (i < logEntries.length) {
                ILogEntry entry = logEntries[i];
                this.addRemoteChange(info, remoteResource, entry);
                ++i;
            }
        }
    }

    private boolean isDeletedRemotely(SyncInfo info) {
        int kind = info.getKind();
        if (kind == 10) {
            return true;
        }
        return SyncInfo.getDirection((int)kind) == 12 && info.getRemote() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteChange(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        if (this.disposed) {
            return;
        }
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null && remoteResource != null && logEntry != null && handler.isRemoteChange((SyncInfo)info)) {
            if (this.requiresCustomSyncInfo((SyncInfo)info, remoteResource, logEntry)) {
                info = new CVSUpdatableSyncInfo(info.getKind(), info.getLocal(), info.getBase(), (IResourceVariant)((RemoteResource)logEntry.getRemoteFile()), this.getSubscriber());
                try {
                    info.init();
                }
                catch (TeamException teamException) {}
            }
            IDiff diff = this.getConverter().getDeltaFor(info);
            IResourceVariant base = info.getBase();
            IResourceVariant remote = info.getRemote();
            if (base == null && remote != null || remote == null && base != null || remote != null && base != null && !base.equals((Object)remote)) {
                CheckedInChangeSetCollector checkedInChangeSetCollector = this;
                synchronized (checkedInChangeSetCollector) {
                    CVSCheckedInChangeSet set = this.getChangeSetFor(logEntry);
                    if (set == null) {
                        set = this.createChangeSetFor(logEntry);
                        this.add((ChangeSet)set);
                    }
                    set.add(diff);
                }
            }
        }
    }

    private SyncInfoToDiffConverter getConverter() {
        SyncInfoToDiffConverter converter = (SyncInfoToDiffConverter)Adapters.adapt((Object)this.subscriber, SyncInfoToDiffConverter.class);
        if (converter == null) {
            converter = SyncInfoToDiffConverter.getDefault();
        }
        return converter;
    }

    private CVSCheckedInChangeSet createChangeSetFor(ILogEntry logEntry) {
        return new CVSCheckedInChangeSet(logEntry);
    }

    private CVSCheckedInChangeSet getChangeSetFor(ILogEntry logEntry) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (set instanceof CVSCheckedInChangeSet && set.getComment().equals(logEntry.getComment()) && ((CVSCheckedInChangeSet)set).getAuthor().equals(logEntry.getAuthor())) {
                return (CVSCheckedInChangeSet)set;
            }
            ++i;
        }
        return null;
    }

    private boolean requiresCustomSyncInfo(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        if (logEntry.isDeletion()) {
            return false;
        }
        IResourceVariant remote = info.getRemote();
        if (remote == null) {
            return true;
        }
        return !remote.equals((Object)remoteResource);
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            while (handler.getEventHandlerJob().getState() != 0) {
                monitor.worked(1);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                Policy.checkCanceled(monitor);
            }
        }
        monitor.worked(1);
    }

    @Override
    public void logEntriesFetched(SyncInfoSet set, RemoteLogOperation.LogEntryCache logEntryCache, IProgressMonitor monitor) {
        if (this.disposed) {
            return;
        }
        this.logEntryCache = logEntryCache;
        try {
            this.beginInput();
            this.handleRemoteChanges(set.getSyncInfos(), logEntryCache, monitor);
        }
        finally {
            this.endInput(monitor);
        }
    }

    public ICVSRemoteFile getImmediatePredecessor(ICVSRemoteFile file) throws TeamException {
        if (this.logEntryCache != null) {
            return this.logEntryCache.getImmediatePredecessor(file);
        }
        return null;
    }

    private class CVSUpdatableSyncInfo
    extends CVSSyncInfo {
        public int kind;

        public CVSUpdatableSyncInfo(int kind, IResource local, IResourceVariant base, IResourceVariant remote, Subscriber s) {
            super(local, base, remote, s);
            this.kind = kind;
        }

        protected int calculateKind() throws TeamException {
            return this.kind;
        }
    }
}

