/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemCapabilityInvolvement;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.oa.OperationalCapability;

public class CapabilityHelper {
    private static CapabilityHelper instance;

    private CapabilityHelper() {
    }

    public static CapabilityHelper getInstance() {
        if (instance == null) {
            instance = new CapabilityHelper();
        }
        return instance;
    }

    public Object doSwitch(Capability element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CtxPackage.Literals.CAPABILITY__INVOLVED_ACTORS)) {
            ret = this.getInvolvedActors(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__INVOLVED_SYSTEM)) {
            ret = this.getInvolvedSystem(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__PURPOSE_MISSIONS)) {
            ret = this.getPurposeMissions(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__PARTICIPATING_ACTORS)) {
            ret = this.getParticipatingActors(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__PARTICIPATING_SYSTEM)) {
            ret = this.getParticipatingSystem(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__REALIZED_OPERATIONAL_CAPABILITIES)) {
            ret = this.getRealizedOperationalCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__REALIZING_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizingCapabilityRealizations(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__PURPOSES)) {
            ret = this.getPurposes(element);
        }
        if (ret == null) {
            ret = AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)element, feature);
        }
        return ret;
    }

    protected List<CapabilityExploitation> getPurposes(Capability element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CtxPackage.Literals.CAPABILITY_EXPLOITATION__CAPABILITY);
    }

    protected List<ActorCapabilityInvolvement> getInvolvedActors(Capability element) {
        ArrayList<ActorCapabilityInvolvement> ret = new ArrayList<ActorCapabilityInvolvement>();
        for (Involvement involvement : element.getInvolvedInvolvements()) {
            if (!(involvement instanceof ActorCapabilityInvolvement)) continue;
            ret.add((ActorCapabilityInvolvement)involvement);
        }
        return ret;
    }

    protected SystemCapabilityInvolvement getInvolvedSystem(Capability element) {
        return element.getOwnedSystemCapabilityInvolvement();
    }

    protected List<Mission> getPurposeMissions(Capability element) {
        ArrayList<Mission> ret = new ArrayList<Mission>();
        for (CapabilityExploitation exploitation : element.getPurposes()) {
            Mission mission = exploitation.getMission();
            if (mission == null) continue;
            ret.add(mission);
        }
        return ret;
    }

    protected System getParticipatingSystem(Capability element) {
        SystemCapabilityInvolvement involvement = element.getOwnedSystemCapabilityInvolvement();
        if (involvement != null) {
            return involvement.getSystem();
        }
        return null;
    }

    protected List<Actor> getParticipatingActors(Capability element) {
        ArrayList<Actor> ret = new ArrayList<Actor>();
        for (ActorCapabilityInvolvement involvement : element.getInvolvedActors()) {
            Actor actor = involvement.getActor();
            if (actor == null) continue;
            ret.add(actor);
        }
        return ret;
    }

    protected List<OperationalCapability> getRealizedOperationalCapabilities(Capability element) {
        ArrayList<OperationalCapability> ret = new ArrayList<OperationalCapability>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof OperationalCapability)) continue;
            ret.add((OperationalCapability)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizingCapabilityRealizations(Capability element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizingCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }
}

