/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionHelper;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.OperationalActivity;

public class SystemFunctionHelper {
    private static SystemFunctionHelper instance;

    private SystemFunctionHelper() {
    }

    public static SystemFunctionHelper getInstance() {
        if (instance == null) {
            instance = new SystemFunctionHelper();
        }
        return instance;
    }

    public Object doSwitch(SystemFunction element, EStructuralFeature feature) {
        List<OperationalActivity> ret = null;
        if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__ALLOCATOR_ACTORS)) {
            ret = this.getAllocatorActors(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__ALLOCATOR_SYSTEMS)) {
            ret = this.getAllocatorSystems(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__REALIZED_OPERATIONAL_ACTIVITIES)) {
            ret = this.getRealizedOperationalActivities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__REALIZING_LOGICAL_FUNCTIONS)) {
            ret = this.getRealizingLogicalFunctions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__CONTAINED_SYSTEM_FUNCTIONS)) {
            ret = this.getContainedSystemFunctions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_FUNCTION__CHILDREN_SYSTEM_FUNCTIONS)) {
            ret = this.getChildrenSystemFunctions(element);
        }
        if (ret == null) {
            ret = AbstractFunctionHelper.getInstance().doSwitch((AbstractFunction)element, feature);
        }
        return ret;
    }

    protected List<Actor> getAllocatorActors(SystemFunction element) {
        ArrayList<Actor> ret = new ArrayList<Actor>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof Actor)) continue;
            ret.add((Actor)src);
        }
        return ret;
    }

    protected List<System> getAllocatorSystems(SystemFunction element) {
        ArrayList<System> ret = new ArrayList<System>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof System)) continue;
            ret.add((System)src);
        }
        return ret;
    }

    protected List<OperationalActivity> getRealizedOperationalActivities(SystemFunction element) {
        ArrayList<OperationalActivity> ret = new ArrayList<OperationalActivity>();
        for (FunctionRealization functionRealization : element.getOutFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatedFunction();
            if (!(abstractFunction instanceof OperationalActivity)) continue;
            ret.add((OperationalActivity)abstractFunction);
        }
        return ret;
    }

    protected List<LogicalFunction> getRealizingLogicalFunctions(SystemFunction element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (FunctionRealization functionRealization : element.getInFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatingFunction();
            if (!(abstractFunction instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)abstractFunction);
        }
        return ret;
    }

    protected List<SystemFunction> getContainedSystemFunctions(SystemFunction element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (AbstractFunction function : element.getOwnedFunctions()) {
            if (!(function instanceof SystemFunction)) continue;
            ret.add((SystemFunction)function);
        }
        return ret;
    }

    protected List<SystemFunction> getChildrenSystemFunctions(SystemFunction element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (AbstractFunction function : element.getSubFunctions()) {
            if (!(function instanceof SystemFunction)) continue;
            ret.add((SystemFunction)function);
        }
        return ret;
    }
}

