/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.ActorMissionInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.interaction.AbstractCapability;

public class ActorExt {
    public static void removeInvolvedCapability(Actor actor, AbstractCapability capabilityUseCase) {
        ActorCapabilityInvolvement actorCapabilityInvolvement = null;
        ListIterator it = actor.getParticipationsInCapabilities().listIterator();
        while (it.hasNext()) {
            ActorCapabilityInvolvement inv = (ActorCapabilityInvolvement)it.next();
            if (!inv.getCapability().equals(capabilityUseCase)) continue;
            actorCapabilityInvolvement = inv;
        }
        if (actorCapabilityInvolvement != null) {
            ((Capability)capabilityUseCase.eContainer()).getOwnedActorCapabilityInvolvements().remove(actorCapabilityInvolvement);
            actorCapabilityInvolvement.destroy();
        }
    }

    public static List<Capability> getInvolvedCapabilities(Actor actor) {
        ArrayList<Capability> involvedCapabilities = new ArrayList<Capability>();
        for (ActorCapabilityInvolvement actorCapabilityInvolvement : actor.getParticipationsInCapabilities()) {
            Capability capabilitySpecificationUseCase = actorCapabilityInvolvement.getCapability();
            if (capabilitySpecificationUseCase == null) continue;
            involvedCapabilities.add(capabilitySpecificationUseCase);
        }
        return involvedCapabilities;
    }

    public static void addInvolvedCapabilityUseCase(Actor actor, Capability capabilityUseCase) {
        if (actor != null && capabilityUseCase != null) {
            ActorCapabilityInvolvement capabilityInv = CtxFactory.eINSTANCE.createActorCapabilityInvolvement();
            capabilityInv.setInvolved((InvolvedElement)actor);
            ((Capability)capabilityUseCase.eContainer()).getOwnedActorCapabilityInvolvements().add((Object)capabilityInv);
        }
    }

    public static boolean isInteracting(Actor actor, AbstractCapability capabilityUseCase) {
        boolean isInteracting = false;
        for (ActorCapabilityInvolvement actorCapabilityInvolvement : actor.getParticipationsInCapabilities()) {
            if (!actorCapabilityInvolvement.getCapability().equals(capabilityUseCase)) continue;
            isInteracting = true;
            break;
        }
        return isInteracting;
    }

    public static boolean isInteracting(Actor actor, Mission mission) {
        boolean isInteracting = false;
        for (ActorMissionInvolvement actorMissionInvolvement : mission.getInvolvedActors()) {
            if (!actorMissionInvolvement.getActor().equals(actor)) continue;
            isInteracting = true;
            break;
        }
        return isInteracting;
    }
}

