/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.cs.delegates.BlockArchitectureHelper;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;

public class LaArchitectureHelper {
    private static LaArchitectureHelper instance;

    private LaArchitectureHelper() {
    }

    public static LaArchitectureHelper getInstance() {
        if (instance == null) {
            instance = new LaArchitectureHelper();
        }
        return instance;
    }

    public Object doSwitch(LogicalArchitecture element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(LaPackage.Literals.LOGICAL_ARCHITECTURE__ALLOCATED_SYSTEM_ANALYSIS_REALIZATIONS)) {
            ret = this.getAllocatedSystemAnalysisRealizations(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ARCHITECTURE__CONTAINED_CAPABILITY_REALIZATION_PKG)) {
            ret = this.getContainedCapabilityRealizationPkg(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ARCHITECTURE__CONTAINED_LOGICAL_FUNCTION_PKG)) {
            ret = this.getContainedLogicalFunctionPkg(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ARCHITECTURE__ALLOCATED_SYSTEM_ANALYSES)) {
            ret = this.getAllocatedSystemAnalyses(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ARCHITECTURE__ALLOCATING_PHYSICAL_ARCHITECTURES)) {
            ret = this.getAllocatingPhysicalArchitectures(element);
        }
        if (ret == null) {
            ret = BlockArchitectureHelper.getInstance().doSwitch((BlockArchitecture)element, feature);
        }
        return ret;
    }

    protected List<SystemAnalysisRealization> getAllocatedSystemAnalysisRealizations(LogicalArchitecture element) {
        ArrayList<SystemAnalysisRealization> ret = new ArrayList<SystemAnalysisRealization>();
        for (ArchitectureAllocation architectureAllocation : element.getProvisionedArchitectureAllocations()) {
            if (!(architectureAllocation instanceof SystemAnalysisRealization)) continue;
            ret.add((SystemAnalysisRealization)architectureAllocation);
        }
        return ret;
    }

    protected CapabilityRealizationPkg getContainedCapabilityRealizationPkg(LogicalArchitecture element) {
        AbstractCapabilityPkg abstractCapabilityPkg = element.getOwnedAbstractCapabilityPkg();
        if (abstractCapabilityPkg instanceof CapabilityRealizationPkg) {
            return (CapabilityRealizationPkg)abstractCapabilityPkg;
        }
        return null;
    }

    protected LogicalFunctionPkg getContainedLogicalFunctionPkg(LogicalArchitecture element) {
        FunctionPkg functionPkg = element.getOwnedFunctionPkg();
        if (functionPkg instanceof LogicalFunctionPkg) {
            return (LogicalFunctionPkg)functionPkg;
        }
        return null;
    }

    protected List<SystemAnalysis> getAllocatedSystemAnalyses(LogicalArchitecture element) {
        ArrayList<SystemAnalysis> ret = new ArrayList<SystemAnalysis>();
        for (BlockArchitecture architecture : element.getAllocatedArchitectures()) {
            if (!(architecture instanceof SystemAnalysis)) continue;
            ret.add((SystemAnalysis)architecture);
        }
        return ret;
    }

    protected List<PhysicalArchitecture> getAllocatingPhysicalArchitectures(LogicalArchitecture element) {
        ArrayList<PhysicalArchitecture> ret = new ArrayList<PhysicalArchitecture>();
        for (BlockArchitecture architecture : element.getAllocatingArchitectures()) {
            if (!(architecture instanceof PhysicalArchitecture)) continue;
            ret.add((PhysicalArchitecture)architecture);
        }
        return ret;
    }
}

