/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractActorHelper;
import org.polarsys.capella.core.data.helpers.pa.delegates.AbstractPhysicalComponentHelper;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.LogicalActorRealization;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class PhysicalActorHelper {
    private static PhysicalActorHelper instance;

    private PhysicalActorHelper() {
    }

    public static PhysicalActorHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalActorHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalActor element, EStructuralFeature feature) {
        List<PhysicalComponent> ret = null;
        if (feature.equals(PaPackage.Literals.PHYSICAL_ACTOR__LOGICAL_ACTOR_REALIZATIONS)) {
            ret = this.getLogicalActorRealizations(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ACTOR__ALLOCATED_PHYSICAL_FUNCTIONS)) {
            ret = this.getAllocatedPhysicalFunctions(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ACTOR__REALIZED_LOGICAL_ACTORS)) {
            ret = this.getRealizedLogicalActors(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ACTOR__DEPLOYED_PHYSICAL_COMPONENTS)) {
            ret = this.getDeployedPhysicalComponents(element);
        }
        if (ret == null) {
            ret = AbstractActorHelper.getInstance().doSwitch((AbstractActor)element, feature);
        }
        if (ret == null) {
            ret = AbstractPhysicalComponentHelper.getInstance().doSwitch((AbstractPhysicalComponent)element, feature);
        }
        return ret;
    }

    protected List<LogicalActorRealization> getLogicalActorRealizations(PhysicalActor element) {
        ArrayList<LogicalActorRealization> ret = new ArrayList<LogicalActorRealization>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            if (!(componentAllocation instanceof LogicalActorRealization)) continue;
            ret.add((LogicalActorRealization)componentAllocation);
        }
        return ret;
    }

    protected List<PhysicalFunction> getAllocatedPhysicalFunctions(PhysicalActor element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)function);
        }
        return ret;
    }

    protected List<LogicalActor> getRealizedLogicalActors(PhysicalActor element) {
        ArrayList<LogicalActor> ret = new ArrayList<LogicalActor>();
        for (Component cpnt : element.getAllocatedComponents()) {
            if (!(cpnt instanceof LogicalActor)) continue;
            ret.add((LogicalActor)cpnt);
        }
        return ret;
    }

    protected List<PhysicalComponent> getDeployedPhysicalComponents(PhysicalActor element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deploymentLink : ((Part)obj).getDeploymentLinks()) {
                AbstractType type;
                DeployableElement deployableElement = deploymentLink.getDeployedElement();
                if (deployableElement instanceof PhysicalComponent) {
                    ret.add((PhysicalComponent)deployableElement);
                    continue;
                }
                if (!(deployableElement instanceof Part) || !((type = ((Part)deployableElement).getAbstractType()) instanceof PhysicalComponent)) continue;
                ret.add((PhysicalComponent)type);
            }
        }
        return ret;
    }
}

