/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.migration.contribution.Messages;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.helpers.SemanticResourcesScope;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;

public class DAnnotationDescriptorContribution
extends AbstractMigrationContribution {
    public static final String contextual_elements = "CONTEXTUAL_ELEMENTS";
    public static final String allocating_diagrams = "INITIALIZATION_REALIZING";
    public static final String allocated_diagrams = "INITIALIZATION_REALIZED";
    HashMap<String, DRepresentationDescriptor> descriptors = new HashMap();
    HashMap<String, DRepresentation> diagrams = new HashMap();

    @Override
    public void dispose(MigrationContext context) {
        super.dispose(context);
        this.descriptors.clear();
        this.diagrams.clear();
    }

    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        super.unaryMigrationExecute(currentElement, context);
        if (currentElement instanceof DRepresentationDescriptor && ((DRepresentationDescriptor)currentElement).getRepPath() != null) {
            this.descriptors.put(((DRepresentationDescriptor)currentElement).getRepPath().getResourceURI().fragment(), (DRepresentationDescriptor)currentElement);
        }
        if (currentElement instanceof DRepresentation) {
            this.diagrams.put(((DRepresentation)currentElement).getUid(), (DRepresentation)currentElement);
        }
    }

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        super.postMigrationExecute(executionManager, resourceSet, context);
        int i = 0;
        for (String uid : this.diagrams.keySet()) {
            DRepresentation diagram = this.diagrams.get(uid);
            try {
                DRepresentationDescriptor descriptor = this.descriptors.get(diagram.getUid());
                if (descriptor == null) continue;
                int nb = this.migrate(diagram, descriptor, resourceSet);
                i += nb;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (i > 0) {
            Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
            Status status = new Status(1, "org.polarsys.capella.core.data.migration", NLS.bind((String)Messages.MigrationAction_AnnotationMigration, (Object)context.getName(), (Object)i));
            LogExt.log((Logger)logger, (IStatus)status);
        }
    }

    private int migrate(DRepresentation diagram, DRepresentationDescriptor descriptor, ResourceSet resourceSet) {
        Status status;
        Logger logger;
        int result = 0;
        if (DAnnotationHelper.deleteAnnotation((String)allocating_diagrams, (DModelElement)diagram)) {
            ++result;
        }
        if (DAnnotationHelper.deleteAnnotation((String)allocated_diagrams, (DModelElement)diagram)) {
            ++result;
        }
        DAnnotation annotation = null;
        annotation = RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (DRepresentation)diagram);
        if (annotation != null) {
            RepresentationHelper.removeAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (DRepresentation)diagram);
            DAnnotationHelper.createAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (DModelElement)descriptor);
            ++result;
        }
        if ((annotation = RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInLM", (DRepresentation)diagram)) != null) {
            RepresentationHelper.removeAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInLM", (DRepresentation)diagram);
            DAnnotationHelper.createAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInLM", (DModelElement)descriptor);
            ++result;
        }
        if ((annotation = RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/StatusReview", (DRepresentation)diagram)) != null) {
            DAnnotation created = DAnnotationHelper.createAnnotation((String)"http://www.polarsys.org/capella/core/StatusReview", (DModelElement)descriptor);
            if (annotation.getDetails() != null) {
                created.getDetails().putAll(annotation.getDetails());
            }
            RepresentationHelper.removeAnnotation((String)"http://www.polarsys.org/capella/core/StatusReview", (DRepresentation)diagram);
            ++result;
        }
        if ((annotation = RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/ProgressStatus", (DRepresentation)diagram)) != null) {
            if (annotation.getDetails() != null) {
                String statusValue = (String)annotation.getDetails().get((Object)"value");
                try {
                    IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellacorePackage.Literals.CAPELLA_ELEMENT__STATUS);
                    if (query != null) {
                        List statuses = query.getAvailableElements((EObject)((CapellaElement)CapellaAdapterHelper.resolveSemanticObject((Object)descriptor, (boolean)true)));
                        EnumerationPropertyLiteral literal = null;
                        for (EObject review : statuses) {
                            if (!(review instanceof EnumerationPropertyLiteral) || !((EnumerationPropertyLiteral)review).getLabel().equals(statusValue)) continue;
                            literal = (EnumerationPropertyLiteral)review;
                        }
                        if (literal != null) {
                            DAnnotation created = DAnnotationHelper.createAnnotation((String)"http://www.polarsys.org/capella/core/ProgressStatus", (DModelElement)descriptor);
                            created.getReferences().clear();
                            created.getReferences().add(literal);
                            ++result;
                        } else {
                            logger = ReportManagerRegistry.getInstance().subscribe("Default");
                            status = new Status(2, "org.polarsys.capella.core.data.migration", NLS.bind((String)Messages.MigrationAction_MissingStatusMigration, (Object)descriptor.getName(), (Object)statusValue));
                            LogExt.log((Logger)logger, (IStatus)status);
                        }
                    }
                }
                catch (Exception query) {
                    // empty catch block
                }
            }
            RepresentationHelper.removeAnnotation((String)"http://www.polarsys.org/capella/core/StatusReview", (DRepresentation)diagram);
        }
        if ((annotation = RepresentationHelper.getAnnotation((String)contextual_elements, (DRepresentation)diagram)) != null) {
            DAnnotation newAnnotation = null;
            for (String id : annotation.getDetails().values()) {
                EObject object = IdManager.getInstance().getEObject(id, (IScope)new SemanticResourcesScope(resourceSet));
                if (object != null) {
                    if (newAnnotation == null) {
                        newAnnotation = DAnnotationHelper.createAnnotation((String)"http://www.polarsys.org/capella/dannotation/ContextualElements", (DModelElement)descriptor);
                    }
                    newAnnotation.getReferences().add((Object)object);
                    continue;
                }
                logger = ReportManagerRegistry.getInstance().subscribe("Default");
                status = new Status(2, "org.polarsys.capella.core.data.migration", NLS.bind((String)Messages.MigrationAction_MissingContextualElementMigration, (Object)descriptor.getName(), (Object)id));
                LogExt.log((Logger)logger, (IStatus)status);
            }
            RepresentationHelper.removeAnnotation((String)contextual_elements, (DRepresentation)diagram);
            ++result;
        }
        return result;
    }
}

