/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.properties.controllers.SequenceLocalHelper;
import org.polarsys.capella.core.model.helpers.ActorExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;

public class InterfaceHelper {
    private static InterfaceHelper _instance = null;

    public static InterfaceHelper getInstance() {
        if (_instance == null) {
            _instance = new InterfaceHelper();
        }
        return _instance;
    }

    private InterfaceHelper() {
    }

    public static boolean isSharedDataAccess(InstanceRole src, InstanceRole tgt) {
        if (src != null && src.getRepresentedInstance() instanceof ExchangeItemInstance) {
            return true;
        }
        return tgt != null && tgt.getRepresentedInstance() instanceof ExchangeItemInstance;
    }

    public static void affectExchangeItem(SequenceMessage sequenceMessage, AbstractEventOperation operation) {
        MessageKind kind;
        ExchangeItemAllocation allocation;
        ExchangeItem item;
        if (operation != null) {
            SequenceMessage reply;
            MessageEnd send;
            String operationName = operation instanceof ExchangeItemAllocation ? ((ExchangeItemAllocation)operation).getAllocatedItem().getName() : operation.getName();
            MessageEnd receive = sequenceMessage.getReceivingEnd();
            if (receive != null) {
                EventReceiptOperation eventReceiptOperation = InterfaceHelper.getOrCreateReceiptEvent(receive);
                eventReceiptOperation.setOperation(operation);
                eventReceiptOperation.setName("rcvOp_" + operationName + "_" + sequenceMessage.getKind().getName());
                sequenceMessage.getReceivingEnd().setName("rcvMsgEnd_" + operationName + "_" + sequenceMessage.getKind().getName());
            }
            if ((send = sequenceMessage.getSendingEnd()) != null) {
                EventSentOperation eventSentOperation = InterfaceHelper.getOrCreateSentEvent(send);
                eventSentOperation.setOperation(operation);
                eventSentOperation.setName("sndOp_" + operation.getName() + "_" + sequenceMessage.getKind().getName());
                sequenceMessage.getSendingEnd().setName("sndMsgEnd_" + operationName + "_" + sequenceMessage.getKind().getName());
                sequenceMessage.setName(operationName);
            }
            if ((reply = SequenceLocalHelper.getOppositeSequenceMessage(sequenceMessage)) != null) {
                MessageEnd receiveReply = reply.getReceivingEnd();
                EventReceiptOperation eventReceiptOperationReply = InterfaceHelper.getOrCreateReceiptEvent(receiveReply);
                eventReceiptOperationReply.setOperation(operation);
                eventReceiptOperationReply.setName("rcvOp_" + operationName + "_" + reply.getKind().getName());
                reply.getReceivingEnd().setName("rcvMsgEnd_" + operationName + "_" + reply.getKind().getName());
                MessageEnd sendReply = reply.getSendingEnd();
                EventSentOperation eventSentOperationReply = InterfaceHelper.getOrCreateSentEvent(sendReply);
                eventSentOperationReply.setOperation(operation);
                eventSentOperationReply.setName("sndOp_" + operationName + "_" + reply.getKind().getName());
                reply.getSendingEnd().setName("sndMsgEnd_" + operationName + "_" + reply.getKind().getName());
                reply.setName(operationName);
            }
        }
        if (operation instanceof ExchangeItemAllocation && ExchangeMechanism.OPERATION.equals((Object)(item = (allocation = (ExchangeItemAllocation)operation).getAllocatedItem()).getExchangeMechanism()) && !MessageKind.CREATE.equals((Object)(kind = sequenceMessage.getKind())) && !MessageKind.DELETE.equals((Object)kind)) {
            CommunicationLinkProtocol protocol = allocation.getSendProtocol();
            if (CommunicationLinkProtocol.UNSET.equals((Object)protocol) && !MessageKind.UNSET.equals((Object)kind)) {
                sequenceMessage.setKind(MessageKind.UNSET);
            } else if (CommunicationLinkProtocol.SYNCHRONOUS.equals((Object)protocol) && !MessageKind.SYNCHRONOUS_CALL.equals((Object)kind)) {
                sequenceMessage.setKind(MessageKind.SYNCHRONOUS_CALL);
            } else if (CommunicationLinkProtocol.ASYNCHRONOUS.equals((Object)protocol) && !MessageKind.ASYNCHRONOUS_CALL.equals((Object)kind)) {
                sequenceMessage.setKind(MessageKind.ASYNCHRONOUS_CALL);
            }
        }
    }

    private static EventSentOperation getOrCreateSentEvent(MessageEnd messageEnd) {
        EventSentOperation result;
        if (messageEnd.getEvent() instanceof EventSentOperation) {
            result = (EventSentOperation)messageEnd.getEvent();
        } else {
            result = InteractionFactory.eINSTANCE.createEventSentOperation();
            Scenario scenario = (Scenario)messageEnd.eContainer();
            scenario.getOwnedEvents().add((Object)result);
            messageEnd.setEvent((Event)result);
        }
        return result;
    }

    private static EventReceiptOperation getOrCreateReceiptEvent(MessageEnd messageEnd) {
        EventReceiptOperation result;
        if (messageEnd.getEvent() instanceof EventReceiptOperation) {
            result = (EventReceiptOperation)messageEnd.getEvent();
        } else {
            result = InteractionFactory.eINSTANCE.createEventReceiptOperation();
            Scenario scenario = (Scenario)messageEnd.eContainer();
            scenario.getOwnedEvents().add((Object)result);
            messageEnd.setEvent((Event)result);
        }
        return result;
    }

    private List<Interface> getUsedAndRequiredInterfaces(Component component) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.addAll((Collection<Interface>)component.getUsedInterfaces());
        result.addAll((Collection<Interface>)component.getRequiredInterfaces());
        for (Feature f : component.getOwnedFeatures()) {
            if (!(f instanceof ComponentPort)) continue;
            ComponentPort p = (ComponentPort)f;
            result.addAll((Collection<Interface>)p.getRequiredInterfaces());
        }
        return result;
    }

    private List<Interface> getImplementedAndProvidedInterfaces(Component component) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.addAll((Collection<Interface>)component.getImplementedInterfaces());
        result.addAll((Collection<Interface>)component.getProvidedInterfaces());
        for (Feature f : component.getOwnedFeatures()) {
            if (!(f instanceof ComponentPort)) continue;
            ComponentPort p = (ComponentPort)f;
            result.addAll((Collection<Interface>)p.getProvidedInterfaces());
        }
        return result;
    }

    public List<CapellaElement> filterExchangeItemAllocations(List<CapellaElement> elements, InstanceRole sourceIR, InstanceRole targetIR, MessageKind messageKind) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        AbstractType sourceType = sourceIR.getRepresentedInstance().getAbstractType();
        AbstractType targetType = targetIR.getRepresentedInstance().getAbstractType();
        Component component = null;
        ExchangeItem exchangeItem = null;
        if (sourceType instanceof Component && targetType instanceof ExchangeItem) {
            component = (Component)sourceType;
            exchangeItem = (ExchangeItem)targetType;
        } else if (sourceType instanceof ExchangeItem && targetType instanceof Component) {
            exchangeItem = (ExchangeItem)sourceType;
            component = (Component)targetType;
        } else {
            return Collections.emptyList();
        }
        ArrayList<CommunicationLink> communicationLinks = new ArrayList<CommunicationLink>();
        for (CommunicationLink cl : component.getOwnedCommunicationLinks()) {
            if (exchangeItem != cl.getExchangeItem()) continue;
            communicationLinks.add(cl);
        }
        if (!communicationLinks.isEmpty()) {
            for (CapellaElement element : elements) {
                if (!(element instanceof ExchangeItemAllocation)) {
                    result.add(element);
                    continue;
                }
                ExchangeItemAllocation exchangeItemAllocation = (ExchangeItemAllocation)element;
                for (CommunicationLink cl : communicationLinks) {
                    if ((cl.getKind() == CommunicationLinkKind.RECEIVE || cl.getKind() == CommunicationLinkKind.CONSUME || cl.getKind() == CommunicationLinkKind.EXECUTE || cl.getKind() == CommunicationLinkKind.ACCESS) && exchangeItemAllocation.getReceiveProtocol() == cl.getProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if ((cl.getKind() == CommunicationLinkKind.CALL || cl.getKind() == CommunicationLinkKind.PRODUCE || cl.getKind() == CommunicationLinkKind.SEND || cl.getKind() == CommunicationLinkKind.WRITE) && exchangeItemAllocation.getSendProtocol() == cl.getProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (result.contains(exchangeItemAllocation.getAllocatedItem())) continue;
                    result.add((CapellaElement)exchangeItemAllocation.getAllocatedItem());
                }
            }
        } else {
            boolean isSynchronous = MessageKind.SYNCHRONOUS_CALL == messageKind;
            for (CapellaElement element : elements) {
                if (!(element instanceof ExchangeItemAllocation)) {
                    result.add(element);
                    continue;
                }
                ExchangeItemAllocation exchangeItemAllocation = (ExchangeItemAllocation)element;
                if (ExchangeMechanism.SHARED_DATA == exchangeItem.getExchangeMechanism()) {
                    if (sourceType instanceof ExchangeItem && !isSynchronous && CommunicationLinkProtocol.ACCEPT == exchangeItemAllocation.getReceiveProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (targetType instanceof ExchangeItem && isSynchronous && CommunicationLinkProtocol.READ == exchangeItemAllocation.getReceiveProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (targetType instanceof ExchangeItem && !isSynchronous && CommunicationLinkProtocol.UNSET == exchangeItemAllocation.getSendProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (result.contains(exchangeItemAllocation.getAllocatedItem())) continue;
                    result.add((CapellaElement)exchangeItemAllocation.getAllocatedItem());
                    continue;
                }
                if (ExchangeMechanism.EVENT == exchangeItem.getExchangeMechanism()) {
                    if (sourceType instanceof Component && MessageKind.CREATE == messageKind && CommunicationLinkProtocol.UNSET == exchangeItemAllocation.getSendProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (sourceType instanceof ExchangeItem && CommunicationLinkProtocol.UNSET == exchangeItemAllocation.getReceiveProtocol()) {
                        result.add((CapellaElement)exchangeItemAllocation);
                        continue;
                    }
                    if (result.contains(exchangeItemAllocation.getAllocatedItem())) continue;
                    result.add((CapellaElement)exchangeItemAllocation.getAllocatedItem());
                    continue;
                }
                if (result.contains(exchangeItemAllocation.getAllocatedItem())) continue;
                result.add((CapellaElement)exchangeItemAllocation.getAllocatedItem());
            }
        }
        return result;
    }

    public List<CapellaElement> getAvailableExchangeItemsFromInterfaces(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        Interface interf;
        List lst;
        List ancestors;
        AbstractInstance provider;
        ExchangeItem manipulatedItem = null;
        LinkedList clientUsedAndRequiredInterfaces = new LinkedList();
        LinkedList providerImplementedAndProvidedInterfaces = new LinkedList();
        AbstractInstance client = source == null ? null : source.getRepresentedInstance();
        AbstractInstance abstractInstance = provider = target == null ? null : target.getRepresentedInstance();
        if (InterfaceHelper.isSharedDataAccess(source, target) && isSynchronous) {
            AbstractInstance temp = client;
            client = provider;
            provider = temp;
        }
        if (client != null) {
            if (client.getAbstractType() instanceof AbstractActor) {
                ancestors = ActorExt.getAncestors((AbstractActor)((AbstractActor)client.getAbstractType()));
                for (AbstractActor actor : ancestors) {
                    clientUsedAndRequiredInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(this.getUsedAndRequiredInterfaces((Component)actor)));
                }
            } else if (client.getAbstractType() instanceof Component) {
                for (Component component : ComponentExt.getAllAncestors((Component)((Component)client.getAbstractType()))) {
                    clientUsedAndRequiredInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(this.getUsedAndRequiredInterfaces(component)));
                }
            } else if (client.getAbstractType() instanceof ExchangeItem) {
                lst = EObjectExt.getReferencers((EObject)client.getAbstractType(), (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject obj : lst) {
                    interf = (Interface)obj.eContainer();
                    clientUsedAndRequiredInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements((Interface)interf));
                }
                manipulatedItem = (ExchangeItem)client.getAbstractType();
            }
        }
        if (provider != null) {
            if (provider.getAbstractType() instanceof AbstractActor) {
                ancestors = ActorExt.getAncestors((AbstractActor)((AbstractActor)provider.getAbstractType()));
                for (AbstractActor actor : ancestors) {
                    providerImplementedAndProvidedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(this.getImplementedAndProvidedInterfaces((Component)actor)));
                }
            } else if (provider.getAbstractType() instanceof Component) {
                for (Component component : ComponentExt.getAllAncestors((Component)((Component)provider.getAbstractType()))) {
                    providerImplementedAndProvidedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(this.getImplementedAndProvidedInterfaces(component)));
                }
            } else if (provider.getAbstractType() instanceof ExchangeItem) {
                lst = EObjectExt.getReferencers((EObject)provider.getAbstractType(), (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject obj : lst) {
                    interf = (Interface)obj.eContainer();
                    providerImplementedAndProvidedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements((Interface)interf));
                }
                manipulatedItem = (ExchangeItem)provider.getAbstractType();
            }
        }
        ArrayList<CapellaElement> operations = new ArrayList<CapellaElement>();
        for (Interface currentInterface : clientUsedAndRequiredInterfaces) {
            if (!providerImplementedAndProvidedInterfaces.contains(currentInterface)) continue;
            for (ExchangeItemAllocation operation : currentInterface.getOwnedExchangeItemAllocations()) {
                ExchangeItem ei = operation.getAllocatedItem();
                if (manipulatedItem != null && ei != manipulatedItem) continue;
                operations.add((CapellaElement)operation);
            }
        }
        return operations;
    }

    public Collection<CapellaElement> getExchangeItemsFromCommunicationLinks(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        Component client = null;
        Component provider = null;
        if (source != null && source.getRepresentedInstance().getAbstractType() instanceof Component) {
            client = (Component)source.getRepresentedInstance().getAbstractType();
        }
        if (target != null && target.getRepresentedInstance().getAbstractType() instanceof Component) {
            provider = (Component)target.getRepresentedInstance().getAbstractType();
        }
        if ((client == null || provider == null) && isSynchronous) {
            Component temp = client;
            client = provider;
            provider = temp;
        }
        if (client != null && provider != null) {
            HashSet<CapellaElement> clientSendItems = new HashSet<CapellaElement>(CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getSenderCommunicationLink((Component)client)));
            Collection providerReceiveItems = CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getReceiverCommunicationLink((Component)provider));
            clientSendItems.retainAll(providerReceiveItems);
            return clientSendItems;
        }
        return new ArrayList<CapellaElement>();
    }

    public List<CapellaElement> getAllExchangeItems(InstanceRole source, InstanceRole target, MessageKind messageKind) {
        if (source != null && target != null) {
            return ScenarioExt.getAvailableExchangeItemsBetweenInstances((AbstractInstance)source.getRepresentedInstance(), (AbstractInstance)target.getRepresentedInstance(), (MessageKind)messageKind);
        }
        return new ArrayList<CapellaElement>();
    }

    public List<CapellaElement> getRestrictedExchangeItemsFromCommunicationLinks(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        CommunicationLinkProtocol protocol;
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        Component client = null;
        Component provider = null;
        AbstractExchangeItem eiClient = null;
        if (source != null) {
            if (source.getRepresentedInstance().getAbstractType() instanceof Component) {
                client = (Component)source.getRepresentedInstance().getAbstractType();
            } else {
                eiClient = (AbstractExchangeItem)source.getRepresentedInstance().getAbstractType();
            }
        } else {
            client = null;
        }
        if (target != null) {
            if (target.getRepresentedInstance().getAbstractType() instanceof Component) {
                provider = (Component)target.getRepresentedInstance().getAbstractType();
            } else {
                eiClient = (AbstractExchangeItem)target.getRepresentedInstance().getAbstractType();
            }
        } else {
            provider = null;
        }
        if ((client == null || provider == null) && isSynchronous) {
            Component temp = client;
            client = provider;
            provider = temp;
        }
        ArrayList<Object> potentialEI = new ArrayList<Object>();
        if (provider != null) {
            for (CommunicationLink communicationLink : provider.getOwnedCommunicationLinks()) {
                if (communicationLink.getKind() != CommunicationLinkKind.RECEIVE && communicationLink.getKind() != CommunicationLinkKind.CONSUME && communicationLink.getKind() != CommunicationLinkKind.EXECUTE && communicationLink.getKind() != CommunicationLinkKind.ACCESS) continue;
                if (CommunicationLinkKind.ACCESS == communicationLink.getKind()) {
                    protocol = communicationLink.getProtocol();
                    if (isSynchronous && CommunicationLinkProtocol.READ == protocol) {
                        potentialEI.add(communicationLink.getExchangeItem());
                    }
                    if (!isSynchronous && CommunicationLinkProtocol.ACCEPT == protocol) {
                        potentialEI.add(communicationLink.getExchangeItem());
                    }
                    if (CommunicationLinkProtocol.UNSET != protocol) continue;
                    potentialEI.add(communicationLink.getExchangeItem());
                    continue;
                }
                potentialEI.add(communicationLink.getExchangeItem());
            }
        } else if (eiClient != null) {
            potentialEI.add((AbstractExchangeItem)target.getRepresentedInstance().getAbstractType());
        }
        if (client != null) {
            for (CommunicationLink communicationLink : client.getOwnedCommunicationLinks()) {
                if (communicationLink.getKind() != CommunicationLinkKind.CALL && communicationLink.getKind() != CommunicationLinkKind.PRODUCE && communicationLink.getKind() != CommunicationLinkKind.SEND && communicationLink.getKind() != CommunicationLinkKind.WRITE || !potentialEI.contains(communicationLink.getExchangeItem())) continue;
                protocol = communicationLink.getProtocol();
                if (communicationLink.getKind() == CommunicationLinkKind.CALL) {
                    if (isSynchronous && protocol == CommunicationLinkProtocol.SYNCHRONOUS) {
                        result.add((CapellaElement)communicationLink.getExchangeItem());
                    }
                    if (!isSynchronous && protocol == CommunicationLinkProtocol.ASYNCHRONOUS) {
                        result.add((CapellaElement)communicationLink.getExchangeItem());
                    }
                    if (protocol != CommunicationLinkProtocol.UNSET) continue;
                    result.add((CapellaElement)communicationLink.getExchangeItem());
                    continue;
                }
                result.add((CapellaElement)communicationLink.getExchangeItem());
            }
        } else {
            for (AbstractExchangeItem abstractExchangeItem : potentialEI) {
                if (abstractExchangeItem != eiClient) continue;
                result.add((CapellaElement)eiClient);
                List eiaPotentials = EObjectExt.getReferencers((EObject)abstractExchangeItem, (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject eObject : eiaPotentials) {
                    if (!(eObject instanceof ExchangeItemAllocation)) continue;
                    ExchangeItemAllocation eia = (ExchangeItemAllocation)eObject;
                    result.add((CapellaElement)eia);
                }
            }
        }
        return result;
    }

    public static boolean isSharedDataAccess(SequenceMessage message) {
        if (message.getSendingEnd() == null) {
            return false;
        }
        if (message.getReceivingEnd() == null) {
            return false;
        }
        return InterfaceHelper.isSharedDataAccess(message.getSendingEnd().getCovered(), message.getReceivingEnd().getCovered());
    }
}

