/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.ui.notification.TypeNames;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaBuilderState {
    private static final Logger LOG = Logger.getLogger(JavaBuilderState.class);
    private final State state;
    private final IProject project;
    private Integer buildNumber;
    private SimpleLookupTable references;
    private Long lastStructuralBuildTime;
    private Set<QualifiedName> structurallyChangedTypes;

    private JavaBuilderState(IProject project, State state) {
        this.project = project;
        this.state = state;
    }

    public IProject getProject() {
        return this.project;
    }

    public static JavaBuilderState getLastBuiltState(IJavaElement it) {
        JavaBuilderState _xblockexpression = null;
        IJavaProject javaProject = it.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        _xblockexpression = JavaBuilderState.getLastBuiltState(javaProject.getProject());
        return _xblockexpression;
    }

    public static JavaBuilderState getLastBuiltState(IProject it) {
        Object _lastBuiltState;
        State _switchResult = null;
        Object state = _lastBuiltState = JavaModelManager.getJavaModelManager().getLastBuiltState(it, null);
        boolean _matched = false;
        if (state instanceof State) {
            _matched = true;
            _switchResult = (State)state;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return new JavaBuilderState(it, _switchResult);
    }

    public Long getLastStructuralBuildTime() {
        Long _xblockexpression = null;
        if (this.lastStructuralBuildTime != null) {
            return this.lastStructuralBuildTime;
        }
        if (this.state == null) {
            this.lastStructuralBuildTime = -1L;
            return this.lastStructuralBuildTime;
        }
        Object _readField = this.readField(this.state, "lastStructuralBuildTime", -1L);
        _xblockexpression = this.lastStructuralBuildTime = (Long)_readField;
        return _xblockexpression;
    }

    public Integer getBuildNumber() {
        Integer _xblockexpression = null;
        if (this.buildNumber != null) {
            return this.buildNumber;
        }
        if (this.state == null) {
            this.buildNumber = -1;
            return this.buildNumber;
        }
        Object _readField = this.readField(this.state, "buildNumber", -1);
        _xblockexpression = this.buildNumber = (Integer)_readField;
        return _xblockexpression;
    }

    public Set<QualifiedName> getStructurallyChangedTypes() {
        Set<QualifiedName> _xblockexpression = null;
        if (this.structurallyChangedTypes != null) {
            return this.structurallyChangedTypes;
        }
        this.structurallyChangedTypes = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        Object _readField = null;
        if (this.state != null) {
            _readField = this.readField(this.state, "structurallyChangedTypes", null);
        }
        Object types = _readField;
        boolean _matched = false;
        if (types instanceof StringSet) {
            _matched = true;
            String[] stringArray = ((StringSet)types).values;
            int n = ((StringSet)types).values.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name != null) {
                    QualifiedName _create = QualifiedName.create((String[])name.split("/"));
                    this.structurallyChangedTypes.add(_create);
                }
                ++n2;
            }
        }
        _xblockexpression = this.structurallyChangedTypes;
        return _xblockexpression;
    }

    protected TypeNames _getQualifiedTypeNames(IPackageFragment it) {
        TypeNames _xblockexpression = null;
        IJavaProject _javaProject = it.getJavaProject();
        TypeNames qualifiedTypeNames = new TypeNames(_javaProject);
        SimpleLookupTable references = this.getReferences();
        if (references == null) {
            return qualifiedTypeNames;
        }
        String packageName = it.getElementName();
        IResource resource = it.getResource();
        if (resource == null) {
            return qualifiedTypeNames;
        }
        IPath packagePath = resource.getProjectRelativePath();
        int srcPathSegmentCount = this.getPackageFragmentRoot((IJavaElement)it).getResource().getProjectRelativePath().segmentCount();
        Object[] objectArray = references.keyTable;
        int n = references.keyTable.length;
        int n2 = 0;
        while (n2 < n) {
            Object key;
            Object typeLocator = key = objectArray[n2];
            boolean _matched = false;
            if (typeLocator instanceof String) {
                IPath qualifiedPath;
                String typePackageName;
                boolean _equals;
                _matched = true;
                IPath typeLocatorPath = it.getJavaProject().getProject().getFile((String)typeLocator).getProjectRelativePath();
                boolean _isPrefixOf = packagePath.isPrefixOf(typeLocatorPath);
                if (_isPrefixOf && (_equals = packageName.equals(typePackageName = (qualifiedPath = typeLocatorPath.removeFirstSegments(srcPathSegmentCount).removeFileExtension()).removeLastSegments(1).toString().replace("/", ".")))) {
                    String simpleTypeName = qualifiedPath.lastSegment().toString();
                    qualifiedTypeNames.addAll(this.getQualifiedTypeNames((String)typeLocator, packageName, simpleTypeName, it.getJavaProject()));
                }
            }
            ++n2;
        }
        _xblockexpression = qualifiedTypeNames;
        return _xblockexpression;
    }

    protected TypeNames _getQualifiedTypeNames(ICompilationUnit it) {
        return this.getQualifiedTypeNames(this.getTypeLocator(it), this.getPackageName(it), this.getSimplePrimaryTypeName(it), it.getJavaProject());
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaElement it) {
        IJavaElement _parent;
        IPackageFragmentRoot _switchResult = null;
        IJavaElement parent = _parent = it.getParent();
        boolean _matched = false;
        if (parent instanceof IPackageFragmentRoot) {
            _matched = true;
            _switchResult = (IPackageFragmentRoot)parent;
        }
        if (!_matched) {
            _switchResult = this.getPackageFragmentRoot(parent);
        }
        return _switchResult;
    }

    private TypeNames getQualifiedTypeNames(String typeLocator, String packageName, String simpleName, IJavaProject project) {
        char[][] typeNames;
        TypeNames _xblockexpression = null;
        TypeNames qualifiedTypeNames = new TypeNames(project);
        String primaryTypeFqn = this.getQualifedTypeName(packageName, simpleName);
        char[][] _definedTypeNamesFor = null;
        if (this.state != null) {
            _definedTypeNamesFor = this.state.getDefinedTypeNamesFor(typeLocator);
        }
        if ((typeNames = _definedTypeNamesFor) == null) {
            TypeNames _typeNames = new TypeNames(project);
            Procedures.Procedure1 _function = it -> it.addTypeName(primaryTypeFqn, primaryTypeFqn);
            return (TypeNames)ObjectExtensions.operator_doubleArrow((Object)_typeNames, (Procedures.Procedure1)_function);
        }
        Consumer<char[]> _function_1 = it -> {
            String _string = new String((char[])it);
            String typeName = this.getQualifedTypeName(packageName, _string);
            qualifiedTypeNames.addTypeName(typeName, primaryTypeFqn);
        };
        ((List)Conversions.doWrapArray((Object)typeNames)).forEach(_function_1);
        _xblockexpression = qualifiedTypeNames;
        return _xblockexpression;
    }

    private String getQualifedTypeName(String packageName, String simpleTypeName) {
        String _xblockexpression = null;
        if (packageName == null) {
            return simpleTypeName;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(packageName);
        _builder.append(".");
        _builder.append(simpleTypeName);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String getTypeLocator(ICompilationUnit it) {
        IResource _resource = it.getResource();
        IPath _projectRelativePath = null;
        if (_resource != null) {
            _projectRelativePath = _resource.getProjectRelativePath();
        }
        String _string = null;
        if (_projectRelativePath != null) {
            _string = _projectRelativePath.toString();
        }
        return _string;
    }

    private String getPackageName(ICompilationUnit it) {
        IJavaElement _parent;
        String _switchResult = null;
        IJavaElement parent = _parent = it.getParent();
        boolean _matched = false;
        if (parent instanceof IPackageFragment) {
            boolean _not;
            boolean _isDefaultPackage = ((IPackageFragment)parent).isDefaultPackage();
            boolean bl = _not = !_isDefaultPackage;
            if (_not) {
                _matched = true;
                _switchResult = ((IPackageFragment)parent).getElementName();
            }
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private String getSimplePrimaryTypeName(ICompilationUnit it) {
        String _xblockexpression = null;
        String elementName = it.getElementName();
        _xblockexpression = elementName.substring(0, elementName.lastIndexOf("."));
        return _xblockexpression;
    }

    private SimpleLookupTable getReferences() {
        Object _readField;
        SimpleLookupTable _xblockexpression = null;
        if (this.references != null) {
            return this.references;
        }
        if (this.state == null) {
            return null;
        }
        SimpleLookupTable _switchResult = null;
        Object references = _readField = this.readField(this.state, "references", null);
        boolean _matched = false;
        if (references instanceof SimpleLookupTable) {
            _matched = true;
            _switchResult = (SimpleLookupTable)references;
        }
        if (!_matched) {
            _switchResult = null;
        }
        _xblockexpression = this.references = _switchResult;
        return _xblockexpression;
    }

    private Object readField(Object instance, String fieldName, Object defaultValue) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(instance);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                boolean _isEnabledFor = LOG.isEnabledFor((Priority)Level.ERROR);
                if (_isEnabledFor) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                return defaultValue;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public TypeNames getQualifiedTypeNames(Object it) {
        if (it instanceof ICompilationUnit) {
            return this._getQualifiedTypeNames((ICompilationUnit)it);
        }
        if (it instanceof IPackageFragment) {
            return this._getQualifiedTypeNames((IPackageFragment)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

