/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.metric.MetricActivator;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.actions.ProgressMonitoringActionsHelper;
import org.polarsys.capella.core.ui.metric.core.Metric;
import org.polarsys.capella.core.ui.metric.core.MetricTree;
import org.polarsys.capella.core.ui.metric.core.filter.DefaultFilter;
import org.polarsys.capella.core.ui.metric.dialog.MetricDialog;

public class MetricAction
extends BaseSelectionListenerAction {
    MetricTree<EObject> results;

    public MetricAction() {
        super(MetricMessages.metricAction_lbl);
        this.setImageDescriptor(MetricActivator.getDefault().getImageDescriptor("chart_16.gif"));
    }

    public void run() {
        final EObject rootSemanticObject = ProgressMonitoringActionsHelper.getSelectedEObject(this.getStructuredSelection());
        if (rootSemanticObject == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                MetricTree<EObject> tree;
                progressMonitor.beginTask(MetricMessages.progressMonitorMsg, -1);
                MetricAction.this.results = new MetricTree<EObject>(rootSemanticObject, null, null);
                ArrayList<MetricTree<EObject>> nodeWithSes = new ArrayList<MetricTree<EObject>>();
                EClass eRoot = rootSemanticObject.eClass();
                if (eRoot == CapellamodellerPackage.Literals.PROJECT) {
                    Project project = (Project)rootSemanticObject;
                    tree = null;
                    MetricTree<EObject> tree1 = null;
                    for (ModelRoot modelRoot : project.getOwnedModelRoots()) {
                        tree = new MetricTree<EObject>((EObject)modelRoot, null, MetricAction.this.results);
                        MetricAction.this.results.addChild(tree);
                        for (ModellingArchitecture ma : ((SystemEngineering)modelRoot).getOwnedArchitectures()) {
                            tree1 = new MetricTree<EObject>((EObject)ma, null, tree);
                            tree.addChild(tree1);
                            nodeWithSes.add(tree1);
                        }
                    }
                } else if (eRoot == CapellamodellerPackage.Literals.SYSTEM_ENGINEERING) {
                    SystemEngineering se = (SystemEngineering)rootSemanticObject;
                    tree = null;
                    for (ModellingArchitecture ma : se.getOwnedArchitectures()) {
                        tree = new MetricTree<EObject>((EObject)ma, null, MetricAction.this.results);
                        MetricAction.this.results.addChild(tree);
                        nodeWithSes.add(tree);
                    }
                } else if (CapellacorePackage.Literals.MODELLING_ARCHITECTURE.isSuperTypeOf(eRoot)) {
                    nodeWithSes.add(MetricAction.this.results);
                }
                try {
                    EObject root = null;
                    MetricTree<EObject> leaf = null;
                    EObject eobject = null;
                    for (MetricTree metricTree : nodeWithSes) {
                        root = (EObject)metricTree.getId();
                        TreeIterator it = root.eAllContents();
                        Metric<EClass> metric = new Metric<EClass>();
                        metric.addFilter(new DefaultFilter());
                        EObject current = null;
                        while (it.hasNext()) {
                            current = (EObject)it.next();
                            if (metric.accept(current)) {
                                metric.update(current.eClass());
                            }
                            if (!progressMonitor.isCanceled()) continue;
                            MetricAction.this.results.clear();
                            return;
                        }
                        for (EClass eclass : MetricAction.this.sort(metric.getResult().keySet())) {
                            EFactory factory = eclass.getEPackage().getEFactoryInstance();
                            eobject = factory.create(eclass);
                            this.customizeMetricTree(root, eobject);
                            leaf = new MetricTree<EObject>(eobject, null, metricTree);
                            leaf.setData(metric.getResult().get(eclass));
                            metricTree.addChild(leaf);
                        }
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }

            private void customizeMetricTree(EObject root, EObject eobject) {
                if (eobject instanceof FunctionalExchange && root instanceof OperationalAnalysis) {
                    OaFactory oaFactory = OaFactory.eINSTANCE;
                    OperationalActivity operationalActivity = oaFactory.createOperationalActivity();
                    FunctionalExchange interaction = (FunctionalExchange)eobject;
                    interaction.setSource((ActivityNode)operationalActivity);
                    interaction.setTarget((ActivityNode)operationalActivity);
                    interaction.setName("Interaction");
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.results != null && this.results.hasChildren()) {
            this.openMetricsDialog(rootSemanticObject);
        }
        if (this.results != null) {
            this.results.clear();
        }
    }

    private List<EClass> sort(Set<EClass> keySet) {
        ArrayList<EClass> list = new ArrayList<EClass>(keySet);
        Collections.sort(list, new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return list;
    }

    protected void openMetricsDialog(EObject rootSemanticObject) {
        String title = MetricMessages.metricDialogDefaultTitle;
        String resourceName = "";
        Object selectedObject = this.getStructuredSelection().getFirstElement();
        if (selectedObject instanceof IFile) {
            title = NLS.bind((String)MetricMessages.metricDialogTitleFromFile, (Object)((IFile)selectedObject).getName());
            resourceName = ((IFile)selectedObject).getName();
        } else if (selectedObject instanceof EObject) {
            String objectName = selectedObject instanceof NamedElement ? ((NamedElement)selectedObject).getName() : rootSemanticObject.eClass().getName();
            resourceName = rootSemanticObject.eResource().getURI().lastSegment();
            title = NLS.bind((String)MetricMessages.metricDialogTitleFromEObj, (Object[])new Object[]{objectName, resourceName.replace("melodymodeller", "aird")});
        }
        MetricDialog dialog = new MetricDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), title, "", MetricMessages.metricDialogShellTitle);
        dialog.setData(this.results);
        dialog.setResourceName(resourceName);
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            Object selectedObj = selection.getFirstElement();
            if (selectedObj instanceof IFile) {
                Session session = SessionHelper.getSession((IFile)((IFile)selectedObj));
                return session != null && session.isOpen();
            }
            if (selectedObj instanceof EObject) {
                return selectedObj instanceof SystemEngineering || selectedObj instanceof BlockArchitecture;
            }
        }
        return false;
    }
}

