/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.eef.runtime.ui.EEFExtendedRuntime;
import org.eclipse.emf.eef.runtime.ui.editor.messages.MessageProcessor;
import org.eclipse.emf.eef.runtime.ui.editors.pages.tree.EEFTreeMDFormPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveEEFEditor
extends FormEditor
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    public static final String EDITOR_ID = "org.eclipse.emf.eef.runtime.ui.editor.InteractiveEEFEditorID";
    protected EditingDomain editingDomain;
    protected AdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == InteractiveEEFEditor.this.contentOutlinePage) {
                    InteractiveEEFEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)InteractiveEEFEditor.this);
                    InteractiveEEFEditor.this.setCurrentViewer((Viewer)InteractiveEEFEditor.this.contentOutlineViewer);
                }
            } else if (p == InteractiveEEFEditor.this) {
                InteractiveEEFEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = InteractiveEEFEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            InteractiveEEFEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            InteractiveEEFEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!InteractiveEEFEditor.this.updateProblemIndication) return;
                        InteractiveEEFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                InteractiveEEFEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    private IResourceChangeListener resourceChangeListener = null;
    protected MessageProcessor messageProcessor;
    private boolean isSaving = false;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;

    private IResourceChangeListener initResourceChangeListener() {
        IResourceChangeListener resourceChangeListner = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                try {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        protected ResourceSet resourceSet;
                        protected Collection<Resource> changedResources;
                        protected Collection<Resource> removedResources;

                        ResourceDeltaVisitor() {
                            this.resourceSet = (this).InteractiveEEFEditor.this.editingDomain.getResourceSet();
                            this.changedResources = new ArrayList<Resource>();
                            this.removedResources = new ArrayList<Resource>();
                        }

                        public boolean visit(IResourceDelta delta) {
                            Resource resource;
                            if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!(this).InteractiveEEFEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return true;
                        }

                        public Collection<Resource> getChangedResources() {
                            return this.changedResources;
                        }

                        public Collection<Resource> getRemovedResources() {
                            return this.removedResources;
                        }
                    }
                    final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                    if (!visitor.getRemovedResources().isEmpty()) {
                        InteractiveEEFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                (this).InteractiveEEFEditor.this.removedResources.addAll(visitor.getRemovedResources());
                                if (!InteractiveEEFEditor.this.isDirty()) {
                                    InteractiveEEFEditor.this.getSite().getPage().closeEditor((IEditorPart)InteractiveEEFEditor.this, false);
                                }
                            }
                        });
                    }
                    if (!visitor.getChangedResources().isEmpty()) {
                        InteractiveEEFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                (this).InteractiveEEFEditor.this.changedResources.addAll(visitor.getChangedResources());
                                if (InteractiveEEFEditor.this.getSite().getPage().getActiveEditor() == InteractiveEEFEditor.this) {
                                    InteractiveEEFEditor.this.handleActivate();
                                }
                            }
                        });
                    }
                }
                catch (CoreException exception) {
                    EEFExtendedRuntime.INSTANCE.log((Object)exception);
                }
            }
        };
        return resourceChangeListner;
    }

    protected void handleActivate() {
        if (this.editingDomain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap() != null) {
            ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!this.changedResources.isEmpty() && (!this.isDirty() || !this.isSaving && this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.eef.runtime.extended", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    EEFExtendedRuntime.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_FileConflict_label"), (String)InteractiveEEFEditor.getString("WARN_InteractiveEEFEditor_FileConflict"));
    }

    public InteractiveEEFEditor() {
        this.initializeEditingDomain();
        this.messageProcessor = new MessageProcessor();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ((ComposedAdapterFactory)this.adapterFactory).addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        ((ComposedAdapterFactory)this.adapterFactory).addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.resourceChangeListener = this.initResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        InteractiveEEFEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        this.initializeWorkspaceEditingDomain(this.initializeCommandStack());
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    protected BasicCommandStack initializeCommandStack() {
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                InteractiveEEFEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        InteractiveEEFEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            InteractiveEEFEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
        return commandStack;
    }

    protected void initializeWorkspaceEditingDomain(BasicCommandStack commandStack) {
        ResourceSet resourceSet = this.initializeResourceSet();
        this.editingDomain = resourceSet != null ? new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack, resourceSet) : new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack);
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    protected ResourceSet initializeResourceSet() {
        return null;
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.eef.runtime.extended", 0, InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.eef.runtime.extended", 0, InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void addPages() {
        this.createModel();
        this.contributePages();
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    InteractiveEEFEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                InteractiveEEFEditor.this.updateProblemIndication();
            }
        });
    }

    protected void contributePages() {
        try {
            this.addDefaultPage();
        }
        catch (PartInitException e) {
            EEFExtendedRuntime.getPlugin().log((Object)e);
        }
    }

    protected void addDefaultPage() throws PartInitException {
        EEFTreeMDFormPage mainPage = new EEFTreeMDFormPage(this, "main"){

            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                this.setPageTitle("main");
                this.getModelViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        InteractiveEEFEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                });
            }
        };
        mainPage.setAdapterFactory(this.adapterFactory);
        mainPage.setEditingDomain(this.editingDomain);
        mainPage.setInput(this.editingDomain.getResourceSet());
        this.addPage((IFormPage)mainPage);
    }

    public List<FormPage> getPages() {
        ArrayList<FormPage> result = new ArrayList<FormPage>();
        for (Object page : this.pages) {
            if (!(page instanceof FormPage)) continue;
            FormPage formPage = (FormPage)page;
            result.add(formPage);
        }
        return result;
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, InteractiveEEFEditor.getString("UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        this.messageProcessor.init(this);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    InteractiveEEFEditor.this.contentOutlineViewer = this.getTreeViewer();
                    InteractiveEEFEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    InteractiveEEFEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(InteractiveEEFEditor.this.adapterFactory));
                    InteractiveEEFEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(InteractiveEEFEditor.this.adapterFactory));
                    InteractiveEEFEditor.this.contentOutlineViewer.setInput((Object)InteractiveEEFEditor.this.editingDomain.getResourceSet());
                    InteractiveEEFEditor.this.createContextMenuFor((StructuredViewer)InteractiveEEFEditor.this.contentOutlineViewer);
                    if (!InteractiveEEFEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        InteractiveEEFEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(InteractiveEEFEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    InteractiveEEFEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    InteractiveEEFEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    InteractiveEEFEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : InteractiveEEFEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !InteractiveEEFEditor.this.isPersisted(resource) || InteractiveEEFEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            InteractiveEEFEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        InteractiveEEFEditor.this.resourceToDiagnosticMap.put(resource, InteractiveEEFEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            this.isSaving = true;
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, operation);
            this.isSaving = false;
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            EEFExtendedRuntime.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        String[] files = InteractiveEEFEditor.openFilePathDialog(this.getSite().getShell(), 8192, new String[0]);
        if (files.length > 0) {
            URI uri = URI.createFileURI((String)files[0]);
            this.doSaveAs(uri, (IEditorInput)new URIEditorInput(uri));
        }
    }

    public static String[] openFilePathDialog(Shell shell, int style, String[] fileExtensionFilters) {
        return InteractiveEEFEditor.openFilePathDialog(shell, style, fileExtensionFilters, (style & 0x1000) != 0, (style & 0x1000) != 0, (style & 0x2000) != 0);
    }

    public static String[] openFilePathDialog(Shell shell, int style, String[] fileExtensionFilters, boolean includeGroupFilter, boolean includeAllFilter, boolean addExtension) {
        String filter;
        int dot;
        int i;
        int offset;
        FileDialog fileDialog = new FileDialog(shell, style);
        int n = offset = (includeGroupFilter &= fileExtensionFilters.length > 1) ? 1 : 0;
        if (includeGroupFilter || includeAllFilter) {
            int size = fileExtensionFilters.length + offset + (includeAllFilter ? 1 : 0);
            String[] allFilters = new String[size];
            StringBuilder group = includeGroupFilter ? new StringBuilder() : null;
            int i2 = 0;
            while (i2 < fileExtensionFilters.length) {
                if (includeGroupFilter) {
                    if (i2 != 0) {
                        group.append(';');
                    }
                    group.append(fileExtensionFilters[i2]);
                }
                allFilters[i2 + offset] = fileExtensionFilters[i2];
                ++i2;
            }
            if (includeGroupFilter) {
                allFilters[0] = group.toString();
            }
            if (includeAllFilter) {
                allFilters[allFilters.length - 1] = "*.*";
            }
            fileDialog.setFilterExtensions(allFilters);
        } else {
            fileDialog.setFilterExtensions(fileExtensionFilters);
        }
        fileDialog.open();
        String[] filenames = fileDialog.getFileNames();
        String[] result = new String[filenames.length];
        String path = String.valueOf(fileDialog.getFilterPath()) + File.separator;
        String extension = null;
        if (addExtension && (i = fileDialog.getFilterIndex()) != -1 && (!includeAllFilter || i != fileExtensionFilters.length) && (dot = (filter = fileExtensionFilters[i = includeGroupFilter && i == 0 ? 0 : i - offset]).lastIndexOf(46)) == 1 && filter.charAt(0) == '*') {
            extension = filter.substring(dot);
        }
        i = 0;
        while (i < filenames.length) {
            String filename = String.valueOf(path) + filenames[i];
            if (!(extension == null || (dot = filename.lastIndexOf(46)) != -1 && Arrays.asList(fileExtensionFilters).contains("*" + filename.substring(dot)))) {
                filename = String.valueOf(filename) + extension;
            }
            result[i] = filename;
            ++i;
        }
        return result;
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        IActionBars actionBars = this.getActionBars();
        NullProgressMonitor progressMonitor = actionBars != null && actionBars.getStatusLineManager() != null ? actionBars.getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            IStatusLineManager statusLineManager;
            IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : actionBars.getStatusLineManager();
            if (statusLineManager != null) {
                if (selection instanceof IStructuredSelection) {
                    List collection = ((IStructuredSelection)selection).toList();
                    switch (collection.size()) {
                        case 0: {
                            statusLineManager.setMessage(InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_NoObjectSelected"));
                            break;
                        }
                        case 1: {
                            String text = new AdapterFactoryItemDelegator(this.adapterFactory).getText(collection.iterator().next());
                            statusLineManager.setMessage(InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_SingleObjectSelected", text));
                            break;
                        }
                        default: {
                            statusLineManager.setMessage(InteractiveEEFEditor.getString("UI_InteractiveEEFEditor_MultiObjectSelected", Integer.toString(collection.size())));
                            break;
                        }
                    }
                } else {
                    statusLineManager.setMessage("");
                }
            }
        }
    }

    private static String getString(String key) {
        return EEFExtendedRuntime.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EEFExtendedRuntime.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        if (this.getActionBarContributor() != null) {
            if (this.cutAction == null) {
                this.cutAction = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
            }
            if (this.copyAction == null) {
                this.copyAction = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
            }
            if (this.pasteAction == null) {
                this.pasteAction = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
            }
            return this.getActionBarContributor().getActionBars();
        }
        return null;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(((AdapterFactoryEditingDomain)this.editingDomain).getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            EEFExtendedRuntime.INSTANCE.log((Object)exception);
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StructuredViewer modelViewer = InteractiveEEFEditor.this.getModelViewer();
                    if (modelViewer != null) {
                        modelViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    protected StructuredViewer getModelViewer() {
        if (this.getPages() != null && this.getPages().size() > 0 && this.getPages().get(0) instanceof EEFTreeMDFormPage) {
            return ((EEFTreeMDFormPage)this.getPages().get(0)).getModelViewer();
        }
        return null;
    }

    public void activateCCPActions() {
        this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        this.getActionBars().updateActionBars();
    }

    public void deactivateCCPActions() {
        this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        this.getActionBars().updateActionBars();
    }
}

