/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.ScenarioHelper;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;

public class MergeNavigator {
    EClass _mergeLayer = null;
    EClass _nextLayer = null;

    public MergeNavigator(EObject eobject) {
        this.setLayers(eobject);
    }

    public EClass getCurrentLayer() {
        return this._mergeLayer;
    }

    public EClass getNextLayer() {
        return this._nextLayer;
    }

    public List<AbstractTrace> navigateFromDataToTarget(Scenario target, TraceableElement trElt) throws MergeToolException {
        if (trElt == null) {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        ArrayList<AbstractTrace> result = new ArrayList<AbstractTrace>();
        boolean mergeLinkfound = false;
        boolean stop = false;
        TraceableElement current = trElt;
        List<AbstractTrace> list = null;
        block8: while (!mergeLinkfound && !stop) {
            if (LinkUtils.hasIncomingLinksFrom(current, LinkEnum.MERGE_LINK, target)) {
                mergeLinkfound = true;
                continue;
            }
            if (!(trElt.eClass() != InteractionPackage.Literals.MESSAGE_END && trElt.eClass() != InteractionPackage.Literals.EXECUTION_END || LinkUtils.getIncomingLinks(current, LinkEnum.REFINEMENT_LINK).size() <= 1 || LinkUtils.hasIncomingLinks((TraceableElement)((AbstractEnd)trElt).getCovered(), LinkEnum.MERGE_LINK))) {
                AbstractEnd aeCurrent = (AbstractEnd)current;
                InstanceRole irCurrent = aeCurrent.getCovered();
                AbstractInstance aiCurrent = irCurrent.getRepresentedInstance();
                for (TraceableElement elt : LinkUtils.getIncomingLinkTargets(current, LinkEnum.REFINEMENT_LINK)) {
                    AbstractEnd ae = (AbstractEnd)elt;
                    InstanceRole ir = ae.getCovered();
                    AbstractInstance ai = ir.getRepresentedInstance();
                    if (ai.equals(aiCurrent)) continue;
                    current = elt;
                    continue block8;
                }
                continue;
            }
            list = LinkUtils.getOutgoingLinks(current, LinkEnum.REFINEMENT_LINK);
            switch (list.size()) {
                case 0: {
                    result.clear();
                    return result;
                }
                case 1: {
                    current = list.get(0).getTargetElement();
                    if (!this.isContainedIntoTheMergeLayer((EObject)current)) {
                        stop = true;
                    }
                    result.add(list.get(0));
                    break;
                }
                default: {
                    throw new MergeToolException(MergeMessages.genericToolError);
                }
            }
        }
        if (mergeLinkfound) {
            TraceableElement finalTGT = null;
            list = LinkUtils.getIncomingLinksFrom(current, LinkEnum.MERGE_LINK, target);
            switch (list.size()) {
                case 0: {
                    throw new MergeToolException(MergeMessages.genericToolError);
                }
                case 1: {
                    finalTGT = list.get(0).getSourceElement();
                    result.add(list.get(0));
                    break;
                }
                default: {
                    throw new MergeToolException(MergeMessages.genericToolError);
                }
            }
            if (!ScenarioHelper.isContainedInto(target, (EObject)finalTGT)) {
                throw new MergeToolException(MergeMessages.genericToolError);
            }
        } else {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        return result;
    }

    public boolean isContainedIntoTheMergeLayer(EObject eObject) {
        return EcoreUtil2.isContainedBy((EObject)eObject, (EClass)this._mergeLayer);
    }

    public boolean isContainedIntoTheNextLayer(EObject eObject) {
        return EcoreUtil2.isContainedBy((EObject)eObject, (EClass)this._nextLayer);
    }

    private final void setLayers(EObject eObject) {
        if (EcoreUtil2.isContainedBy((EObject)eObject, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) {
            this._mergeLayer = LaPackage.Literals.LOGICAL_ARCHITECTURE;
            this._nextLayer = PaPackage.Literals.PHYSICAL_ARCHITECTURE;
        } else if (EcoreUtil2.isContainedBy((EObject)eObject, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
            this._mergeLayer = PaPackage.Literals.PHYSICAL_ARCHITECTURE;
            this._nextLayer = EpbsPackage.Literals.EPBS_ARCHITECTURE;
        }
    }
}

