/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.services.behaviors;

import java.util.regex.Matcher;
import org.polarsys.capella.common.ui.toolkit.services.behaviors.AbstractInputBehavior;
import org.polarsys.capella.common.ui.toolkit.services.formats.CardinalityBoundariesFormat;
import org.polarsys.capella.common.ui.toolkit.services.validators.CardinalityBoundariesValidator;

public class CardinalityInputBehavior
extends AbstractInputBehavior {
    private static final String UNLIMITED_BOUND = "*";
    private static final String EMPTY_STRING = "";

    public CardinalityInputBehavior() {
        super(new CardinalityBoundariesValidator(EMPTY_STRING, 1), new CardinalityBoundariesFormat(), new String[]{"0..1", "1..1", "1..*", UNLIMITED_BOUND});
    }

    public int[] getValue(String input) {
        int[] bounds = new int[2];
        Matcher matcher = this.getValidator().getPattern().matcher(input);
        if (!matcher.matches()) {
            bounds[0] = Integer.MIN_VALUE;
            bounds[1] = Integer.MIN_VALUE;
            return bounds;
        }
        if (UNLIMITED_BOUND.equalsIgnoreCase(matcher.group(0))) {
            bounds[0] = Integer.MAX_VALUE;
            bounds[1] = Integer.MAX_VALUE;
        } else if (matcher.group(1) == null && matcher.group(0) != null) {
            bounds[0] = Integer.parseInt(matcher.group(0));
            bounds[1] = Integer.parseInt(matcher.group(0));
        } else {
            bounds[0] = UNLIMITED_BOUND.equalsIgnoreCase(matcher.group(1)) ? Integer.MAX_VALUE : Integer.parseInt(matcher.group(1));
            bounds[1] = UNLIMITED_BOUND.equalsIgnoreCase(matcher.group(3)) ? Integer.MAX_VALUE : Integer.parseInt(matcher.group(3));
        }
        return bounds;
    }

    public String convertBounds(int min, int max) {
        String strMin = EMPTY_STRING;
        strMin = Integer.MAX_VALUE == min ? UNLIMITED_BOUND : Integer.toString(min);
        String strMax = EMPTY_STRING;
        strMax = Integer.MAX_VALUE == max ? UNLIMITED_BOUND : Integer.toString(max);
        if (!EMPTY_STRING.equals(strMin) && !EMPTY_STRING.equals(strMax)) {
            return this.format(String.valueOf(strMin) + " " + strMax);
        }
        return EMPTY_STRING;
    }
}

