/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateCallExpression
extends TemplateExpression {
    protected String link;
    protected String prefix;
    protected List arguments = new ArrayList();
    protected TemplateExpression filter = null;
    protected TemplateCallExpression nextCall = null;
    private boolean ignoreNextEval = false;

    public TemplateCallExpression(String link, IScript script) {
        super(script);
        if (link != null) {
            int iDot = link.indexOf(TemplateConstants.LINK_PREFIX_SEPARATOR);
            if (iDot > -1) {
                this.prefix = link.substring(0, iDot).trim();
                this.link = link.substring(iDot + TemplateConstants.LINK_PREFIX_SEPARATOR.length()).trim();
            } else {
                this.prefix = "";
                this.link = link.trim();
            }
        } else {
            this.prefix = "";
            this.link = "";
        }
    }

    public String getLink() {
        return this.link;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TemplateCallExpression getNextCall() {
        return this.nextCall;
    }

    public void setNextCall(TemplateCallExpression nextCall) {
        this.nextCall = nextCall;
    }

    public List getArguments() {
        return this.arguments;
    }

    public TemplateExpression getFilter() {
        return this.filter;
    }

    public void setFilter(TemplateExpression filter) {
        this.filter = filter;
        this.filter.setParent(this);
    }

    public void addArgument(TemplateExpression expression) {
        this.arguments.add(expression);
        expression.setParent(this);
    }

    public int countArguments() {
        return this.arguments.size();
    }

    public TemplateExpression getFirstArgument() {
        if (this.arguments.size() > 0) {
            return (TemplateExpression)this.arguments.get(0);
        }
        return null;
    }

    public void ignoreNextEval() {
        this.ignoreNextEval = true;
    }

    @Override
    public ENode evaluate(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        ENode result = this.evaluateSub(current, script, mode);
        if (this.filter != null) {
            result = this.select(result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ENode evaluateSub(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        block16: {
            if (this.ignoreNextEval) {
                this.ignoreNextEval = false;
                return current;
            }
            argCurrent = (ENode)script.contextPeek(IScript.CURRENT_NODE);
            if (argCurrent == null) {
                argCurrent = current;
            }
            if (this.link.length() != 0) break block16;
            if (this.arguments.size() == 1) {
                arg = (TemplateExpression)this.arguments.get(0);
                return arg.evaluate(argCurrent, script, mode);
            }
            if (this.arguments.size() <= 1) {
                return new ENode(ENode.EMPTY, current);
            }
            result = new ENodeList();
            arguments = this.arguments.iterator();
            if (true) ** GOTO lbl24
        }
        argList = new ArrayList<ENode>();
        arguments = this.arguments.iterator();
        if (true) ** GOTO lbl31
        do {
            arg = (TemplateExpression)arguments.next();
            argEval = arg.evaluate(argCurrent, script, mode);
            result.add(argEval);
lbl24:
            // 2 sources

        } while (arguments.hasNext());
        return new ENode(result, current);
        do {
            arg = (TemplateExpression)arguments.next();
            argEval = arg.evaluate(argCurrent, script, mode);
            argList.add(argEval);
lbl31:
            // 2 sources

        } while (arguments.hasNext());
        args = argList.toArray(new ENode[argList.size()]);
        result = null;
        specifics = script.goToSpecifics();
        if (specifics != null && specifics.length > 0) {
            ENodeException.disableRuntimeMarkersFor(this);
            try {
                i = 0;
                while (result == null && i < specifics.length) {
                    specific = specifics[i];
                    try {
                        result = specific.eGet(this, current, args, mode, false);
                    }
                    catch (ENodeException v0) {}
                    ++i;
                }
            }
            finally {
                ENodeException.enableRuntimeMarkersFor(this);
            }
        }
        if (result == null) {
            result = script.eGet(this, current, args, mode, true);
        }
        if (result == null) {
            throw new ENodeException(AcceleoGenMessages.getString("TemplateCallExpression.UnresolvedCall", new Object[]{this.getLink()}), this.pos, script, current, true);
        }
        return result;
    }

    private ENode select(ENode current) throws FactoryException {
        if (current.isList()) {
            ENodeList res = new ENodeList();
            try {
                ENodeList list = current.getList();
                ENodeIterator it = list.iterator();
                while (it.hasNext()) {
                    res.add(this.select(it.next()));
                }
            }
            catch (ENodeCastException eNodeCastException) {}
            return new ENode(res, current);
        }
        this.script.contextPush(IScript.CURRENT_NODE, current);
        this.script.contextPush(IScript.TEMPLATE_NODE, current);
        try {
            ENode result = this.filter.evaluate(current, this.script, LaunchManager.create("run", true));
            Object boolValue = result.getAdapterValue(Boolean.TYPE);
            if (boolValue instanceof Boolean && ((Boolean)boolValue).booleanValue()) {
                ENode eNode = current;
                return eNode;
            }
            ENode eNode = new ENode(ENode.EMPTY, current);
            return eNode;
        }
        catch (ENodeException eNodeException) {
            ENode eNode = new ENode(ENode.EMPTY, current);
            return eNode;
        }
        catch (ENodeCastException eNodeCastException) {
            ENode eNode = new ENode(ENode.EMPTY, current);
            return eNode;
        }
        finally {
            this.script.contextPop(IScript.CURRENT_NODE);
            this.script.contextPop(IScript.TEMPLATE_NODE);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.prefix != null && this.prefix.length() > 0) {
            buffer.append(this.prefix);
            buffer.append(TemplateConstants.LINK_PREFIX_SEPARATOR);
        }
        buffer.append(this.link);
        if (this.arguments.size() > 0) {
            buffer.append(TemplateConstants.PARENTH[0]);
            Iterator arguments = this.arguments.iterator();
            while (arguments.hasNext()) {
                TemplateExpression argument = (TemplateExpression)arguments.next();
                buffer.append(argument.toString());
                if (!arguments.hasNext()) continue;
                buffer.append(TemplateConstants.ARG_SEP);
            }
            buffer.append(TemplateConstants.PARENTH[1]);
        }
        if (this.filter != null) {
            buffer.append(TemplateConstants.BRACKETS[0]);
            buffer.append(this.filter.toString());
            buffer.append(TemplateConstants.BRACKETS[1]);
        }
        return buffer.toString();
    }

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        TemplateCallExpression expression;
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        TemplateExpression filter = null;
        Int2 begin = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.BRACKETS[0], limits.b(), limits.e(), TemplateConstants.SPEC, new String[][]{TemplateConstants.LITERAL, TemplateConstants.PARENTH});
        if (begin.b() > -1) {
            Int2 end = TextSearch.getDefaultSearch().blockIndexEndIn(buffer, TemplateConstants.BRACKETS[0], TemplateConstants.BRACKETS[1], begin.b(), limits.e(), false, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
            if (end.b() == -1) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingCloseBracket"), script, begin.b());
            }
            if (buffer.substring(end.e(), limits.e()).trim().length() > 0) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidSequence"), script, end.e());
            }
            Int2 pos = new Int2(begin.e(), end.b());
            filter = TemplateExpression.fromString(buffer, pos, script);
            filter.setPos(pos);
            limits = new Int2(limits.b(), begin.b());
            trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
            if (trim.b() == -1) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
            }
            limits = trim;
        }
        if ((begin = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.PARENTH[0], limits.b(), limits.e(), TemplateConstants.SPEC, new String[][]{TemplateConstants.LITERAL})).b() > -1) {
            Int2 end = TextSearch.getDefaultSearch().blockIndexEndIn(buffer, TemplateConstants.PARENTH[0], TemplateConstants.PARENTH[1], begin.b(), limits.e(), false, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
            if (end.b() == -1) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingCloseParenthesis"), script, begin.b());
            }
            if (buffer.substring(end.e(), limits.e()).trim().length() > 0) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidSequence"), script, end.e());
            }
            Int2[] positions = TextSearch.getDefaultSearch().splitPositionsIn(buffer, begin.e(), end.b(), new String[]{TemplateConstants.ARG_SEP}, false, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
            expression = new TemplateCallExpression(buffer.substring(limits.b(), begin.b()), script);
            expression.setPos(new Int2(limits.b(), begin.b()));
            Int2[] int2Array = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                Int2 pos = int2Array[n2];
                expression.addArgument(TemplateExpression.fromString(buffer, pos, script));
                ++n2;
            }
        } else {
            expression = new TemplateCallExpression(buffer.substring(limits.b(), limits.e()), script);
            expression.setPos(new Int2(limits.b(), limits.e()));
        }
        expression.setPos(limits);
        if (filter != null) {
            expression.setFilter(filter);
        }
        return expression;
    }
}

