/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.postgeneration.egf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractModifyMethodBody
implements ITaskProduction {
    protected abstract String getMethodBody();

    protected abstract String getMethodName();

    protected abstract String getFilePath();

    protected abstract Block buildNewBlock(ASTParser var1, MethodDeclaration var2, IProgressMonitor var3);

    protected ASTRewrite doModify(ASTParser astParser_p, MethodDeclaration method_p, IProgressMonitor monitor_p) {
        Block newBlock = this.buildNewBlock(astParser_p, method_p, monitor_p);
        ASTRewrite astRewrite = ASTRewrite.create((AST)method_p.getAST());
        astRewrite.replace((ASTNode)method_p.getBody(), (ASTNode)newBlock, null);
        return astRewrite;
    }

    protected void writeFile(String content_p, ASTRewrite astRewrite_p) {
        try {
            Document document = new Document(content_p);
            TextEdit edits = astRewrite_p.rewriteAST((IDocument)document, Collections.EMPTY_MAP);
            edits.apply((IDocument)document);
            this.writeFile(this.getFilePath(), document.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String content = this.readFile(this.getFilePath());
        ASTParser astParser = ASTParser.newParser((int)3);
        astParser.setSource(content.toCharArray());
        ASTNode astNode = astParser.createAST(monitor);
        MethodVisitor visitor = new MethodVisitor();
        astNode.accept((ASTVisitor)visitor);
        ASTRewrite astRewrite = this.doModify(astParser, visitor.getMyMethod(), monitor);
        this.writeFile(content, astRewrite);
    }

    private String readFile(String filePath) throws InvocationException {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
            InputStream inputStream = file.getContents();
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            return new String(data);
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
    }

    private void writeFile(String filePath, String string) throws InvocationException {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(string.getBytes());
            file.setContents((InputStream)inputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private final class MethodVisitor
    extends ASTVisitor {
        private MethodDeclaration _method;

        private MethodVisitor() {
        }

        public MethodDeclaration getMyMethod() {
            return this._method;
        }

        public void endVisit(MethodDeclaration method) {
            if (AbstractModifyMethodBody.this.getMethodName().equals(method.getName().toString())) {
                this._method = method;
            }
        }
    }
}

