/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.postgeneration.egf;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.polarsys.capella.core.postgeneration.egf.UpdateIconsUtil;

public class IconsUpdater
implements IRunnableWithProgress {
    private ResourceSet _resourceSet;
    private IFile _metamodelFile;
    private IFolder _srcIconsFolder;
    private IFolder _destIconsFolder;
    private boolean _clearFirst;
    private boolean _verbose;
    private int _mcHandled;
    private int _mcSuccessful;
    private int _iconsCreated;
    private Map<EClass, Set<EReference>> _class2Refs;

    public IconsUpdater(ResourceSet rs_p, Map<EClass, Set<EReference>> class2Refs_p, IFile metamodelFile_p, IFolder srcIconsFolder_p, IFolder destIconsFolder_p, boolean verbose_p) {
        Assert.isNotNull((Object)rs_p);
        Assert.isNotNull(class2Refs_p);
        Assert.isNotNull((Object)metamodelFile_p);
        Assert.isNotNull((Object)srcIconsFolder_p);
        Assert.isNotNull((Object)destIconsFolder_p);
        this._resourceSet = rs_p;
        this._class2Refs = class2Refs_p;
        this._metamodelFile = metamodelFile_p;
        this._srcIconsFolder = srcIconsFolder_p;
        this._destIconsFolder = destIconsFolder_p;
        this._clearFirst = false;
        this._verbose = verbose_p;
        this._mcSuccessful = 0;
        this._mcHandled = 0;
        this._iconsCreated = 0;
        this._class2Refs = class2Refs_p;
    }

    public int getHandledMetaclassesNb() {
        return this._mcHandled;
    }

    public int getSuccesfullyHandledMetaclassesNb() {
        return this._mcSuccessful;
    }

    public int getCreatedIconsNb() {
        return this._iconsCreated;
    }

    public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        try {
            String msg = UpdateIconsUtil.buildString("Getting metamodel fragment ", this._metamodelFile.getName(), "...");
            monitor_p.beginTask(msg, 1);
            monitor_p.worked(1);
            Resource res = UpdateIconsUtil.getResourceFrom(this._metamodelFile, this._resourceSet, this._verbose);
            if (monitor_p.isCanceled() || res == null) {
                throw new OperationCanceledException();
            }
            if (this._clearFirst) {
                block12: {
                    try {
                        IResource[] members = this._destIconsFolder.members();
                        int nb = members.length;
                        monitor_p.beginTask("Clearing target icons folder...", nb);
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            member.delete(true, null);
                            ++n2;
                        }
                        monitor_p.worked(1);
                    }
                    catch (CoreException e) {
                        if (!this._verbose) break block12;
                        e.printStackTrace();
                    }
                }
                if (monitor_p.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            monitor_p.beginTask("Computing workload...", 1);
            monitor_p.worked(1);
            if (monitor_p.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<EClass> allConcrete = this.getConcreteMetaclassesInResource(res);
            if (!allConcrete.isEmpty()) {
                monitor_p.beginTask("Handling metaclasses...", allConcrete.size());
                for (EClass eClass : allConcrete) {
                    ++this._mcHandled;
                    this.handleMetaclass(eClass);
                    monitor_p.worked(1);
                    if (!monitor_p.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
        }
        finally {
            monitor_p.done();
        }
    }

    private List<EClass> getConcreteMetaclassesInResource(Resource res_p) {
        LinkedList<EClass> result = new LinkedList<EClass>();
        TreeIterator it = res_p.getAllContents();
        while (it.hasNext()) {
            EClass eClass;
            EObject current = (EObject)it.next();
            if (!(current instanceof EClass) || (eClass = (EClass)current).isAbstract()) continue;
            result.add(eClass);
        }
        return result;
    }

    private Set<EReference> getContainmentsTo(EClass eClass_p) {
        HashSet<EReference> result = new HashSet<EReference>();
        LinkedList<EClass> clan = new LinkedList<EClass>((Collection<EClass>)eClass_p.getEAllSuperTypes());
        clan.add(eClass_p);
        for (EClass currentClass : clan) {
            Set<EReference> currentRefs = this._class2Refs.get(currentClass);
            if (currentRefs == null) continue;
            result.addAll(currentRefs);
        }
        return result;
    }

    private void handleMetaclass(EClass eClass_p) {
        block7: {
            try {
                IFile source = this.getSourceIcon(eClass_p);
                if (source != null) {
                    Set<EReference> applicableContainments = this.getContainmentsTo(eClass_p);
                    for (EReference cont : applicableContainments) {
                        IPath destination = this.getDestinationIcon(eClass_p, cont);
                        try {
                            source.copy(destination, true, null);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        ++this._iconsCreated;
                    }
                    ++this._mcSuccessful;
                    break block7;
                }
                if (this._verbose) {
                    System.out.println("Cannot find icon file for class " + eClass_p.getName());
                }
            }
            catch (Exception e) {
                if (!this._verbose) break block7;
                e.printStackTrace();
            }
        }
    }

    private IFile getSourceIcon(EClass eClass_p) {
        IFile result = null;
        String iconName = this.getSourceIconName(eClass_p);
        IResource res = this._srcIconsFolder.findMember(iconName);
        if (res != null && res instanceof IFile && res.exists()) {
            result = (IFile)res;
        }
        return result;
    }

    private IPath getDestinationIcon(EClass eClass_p, EReference containment_p) {
        String iconName = this.getDestinationIconName(eClass_p, containment_p);
        IPath result = this._destIconsFolder.getFullPath().append(iconName);
        return result;
    }

    private String getSourceIconName(EClass eClass_p) {
        return UpdateIconsUtil.buildString(eClass_p.getName(), ".gif");
    }

    private String getDestinationIconName(EClass eClass_p, EReference containment_p) {
        return UpdateIconsUtil.buildString("Create", containment_p.getEContainingClass().getName(), "_", containment_p.getName(), "_", eClass_p.getName(), ".gif");
    }
}

