/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.postgeneration.egf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.core.postgeneration.egf.IconsUpdater;
import org.polarsys.capella.core.postgeneration.egf.MetamodelLoader;
import org.polarsys.capella.core.postgeneration.egf.UpdateIconsUtil;

public class UpdateIconsAction
implements IObjectActionDelegate {
    public static final String __LABEL = "CTools Icons Update for Capella";
    private static final int __DATA_PROJECT_SUFFIX_LENGTH = 1;
    private static final String __SEPARATOR = ".";
    private static final String __ICONS_PROJECT_SUFFIX = "res.edit";
    private static final String[] __DESTINATION_ICONS_FOLDER_PATH = new String[]{"icons", "full", "ctool16"};
    private static final String[] __SOURCE_ICONS_FOLDER_PATH = new String[]{"icons", "full", "obj16"};
    private IStructuredSelection _selection = null;

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
    }

    public void run(IAction action_p) {
        try {
            List<IFile> selectedFiles = this.getValidSelectedFiles();
            if (selectedFiles.isEmpty()) {
                System.out.println("Selection must contain at least one ecore file.");
                return;
            }
            MetamodelLoader loader = new MetamodelLoader(selectedFiles, true);
            loader.run((IProgressMonitor)new NullProgressMonitor());
            ResourceSet rs = loader.getResultingResourceSet();
            Map<EClass, Set<EReference>> cr = loader.getResultingContainmentIncomingReferences();
            try {
                IFolder folder = this.getDestinationIconsFolder(this.getDestinationProject(selectedFiles.get(0).getProject()));
                this.clearFolder(folder);
            }
            catch (NullPointerException folder) {
                // empty catch block
            }
            int mcsInt = 0;
            int createdInt = 0;
            for (IFile selectedFile : selectedFiles) {
                IProject sourceProject = selectedFile.getProject();
                IProject destinationProject = this.getDestinationProject(sourceProject);
                if (destinationProject == null || !destinationProject.exists()) {
                    System.out.println("Cannot find corresponding icons project.");
                    return;
                }
                IFolder srcIconsFolder = this.getSourceIconsFolder(destinationProject);
                if (srcIconsFolder == null || !srcIconsFolder.exists()) {
                    System.out.println("Cannot find source icons folder.");
                    return;
                }
                IFolder destIconsFolder = this.getDestinationIconsFolder(destinationProject);
                if (destIconsFolder == null || !destIconsFolder.exists()) {
                    System.out.println("Cannot find destination icons folder.");
                    return;
                }
                IconsUpdater updater = new IconsUpdater(rs, cr, selectedFile, srcIconsFolder, destIconsFolder, true);
                updater.run((IProgressMonitor)new NullProgressMonitor());
                mcsInt += updater.getHandledMetaclassesNb();
                createdInt += updater.getCreatedIconsNb();
            }
            Integer mcs = new Integer(mcsInt);
            Integer created = new Integer(createdInt);
            String msg = UpdateIconsUtil.buildString("Found ", mcs, " concrete metaclasses, created ", created, " icons.");
            System.out.println(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        this._selection = selection_p instanceof IStructuredSelection ? (IStructuredSelection)selection_p : null;
    }

    private List<IFile> getValidSelectedFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (this._selection != null) {
            for (Object selected : this._selection) {
                IFile file;
                if (!(selected instanceof IFile) || !this.fileIsValid(file = (IFile)selected)) continue;
                result.add(file);
            }
        }
        return result;
    }

    private boolean fileIsValid(IFile file_p) {
        return "ecore".equals(file_p.getFileExtension());
    }

    private IProject getDestinationProject(IProject sourceProject_p) {
        IProject result = null;
        String spName = sourceProject_p.getName();
        String[] nameParts = spName.split("\\.");
        IWorkspace wk = sourceProject_p.getWorkspace();
        IWorkspaceRoot root = wk.getRoot();
        int length = nameParts.length - 1;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append(nameParts[i]);
            builder.append(__SEPARATOR);
            ++i;
        }
        builder.append(__ICONS_PROJECT_SUFFIX);
        String dpName = builder.toString();
        result = root.getProject(dpName);
        return result;
    }

    private IPath makePath(String[] pathParts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        String[] stringArray = pathParts;
        int n = pathParts.length;
        int n2 = 0;
        while (n2 < n) {
            String pathPart = stringArray[n2];
            if (first) {
                first = false;
            } else {
                builder.append("/");
            }
            builder.append(pathPart);
            ++n2;
        }
        Path result = new Path(builder.toString());
        return result;
    }

    private IFolder getSourceIconsFolder(IProject project_p) {
        IFolder result = null;
        IPath sifPath = this.makePath(__SOURCE_ICONS_FOLDER_PATH);
        IResource res = project_p.findMember(sifPath);
        if (res instanceof IFolder) {
            result = (IFolder)res;
        }
        return result;
    }

    private IFolder getDestinationIconsFolder(IProject project_p) {
        IFolder result = null;
        IPath sifPath = this.makePath(__DESTINATION_ICONS_FOLDER_PATH);
        IResource res = project_p.findMember(sifPath);
        if (res instanceof IFolder) {
            result = (IFolder)res;
        }
        return result;
    }

    private void clearFolder(IFolder folder_p) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder_p.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                member.delete(true, null);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

