/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets.filter;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.progress.WorkbenchJob;
import org.polarsys.capella.common.ui.MdeCommonUiActivator;
import org.polarsys.capella.common.ui.services.swt.events.AbstractKeyAdapter;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.Messages;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.PatternFilter;

public class FilteredTree
extends Composite {
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private boolean isAutoFiltering;
    protected Composite filterComposite;
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected String initialText;
    private boolean narrowingDown;
    protected Composite parent;
    private PatternFilter patternFilter;
    private String previousFilterText;
    private Job refreshJob;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    protected TreeViewer treeViewer;
    protected String lastAppliedPattern = "";

    protected FilteredTree(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        this.isAutoFiltering = false;
    }

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.parent = parent;
        this.isAutoFiltering = false;
        this.init(treeStyle, filter);
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected boolean hasNativeClearButton() {
        return (this.filterText.getStyle() & 0x100) != 0;
    }

    protected void createClearText(Composite parent) {
        if (!this.hasNativeClearButton()) {
            if (this.filterToolBar == null) {
                this.filterToolBar = new ToolBarManager(0x800100);
                this.filterToolBar.createControl(parent);
            }
            Action clearTextAction = new Action("", 1){

                public void run() {
                    FilteredTree.this.clearText();
                }
            };
            clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearTextAction.setImageDescriptor(MdeCommonUiActivator.getDefault().getImageDescriptor("full/etool16/clear.gif"));
            clearTextAction.setDisabledImageDescriptor(MdeCommonUiActivator.getDefault().getImageDescriptor("full/etool16/clear.gif"));
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            this.filterComposite = this.createFilterGroup(this);
            GridLayout filterLayout = new GridLayout(2, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    protected Composite createFilterGroup(Composite parent) {
        this.filterComposite = new Group(parent, 0);
        ((Group)this.filterComposite).setText(Messages.FilteredTree_Group_Title);
        return this.filterComposite;
    }

    protected Composite createFilterControls(Composite parent) {
        this.createMessageArea(parent);
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            if (this.filterToolBar.getSize() == 1) {
                this.filterToolBar.getControl().setVisible(false);
            }
        }
        return parent;
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.filterText.getText();
                e.result = filterTextString.length() == 0 ? FilteredTree.this.initialText : filterTextString;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = FilteredTree.this.filterText.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).FilteredTree.this.filterText.isDisposed() && FilteredTree.this.getInitialText().equals((this).FilteredTree.this.filterText.getText().trim())) {
                            (this).FilteredTree.this.filterText.selectAll();
                        }
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                if (!FilteredTree.this.getFilterString().equals(FilteredTree.this.previousFilterText)) {
                    FilteredTree.this.previousFilterText = FilteredTree.this.getFilterString();
                    FilteredTree.this.refreshJob.cancel();
                    long delay = 0L;
                    if (FilteredTree.this.isAutoFiltering()) {
                        delay = FilteredTree.this.getAutoFilteringDelay();
                    }
                    FilteredTree.this.refreshJob.schedule(delay);
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new AbstractKeyAdapter(){

            public void keyPressed(KeyEvent event) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && event.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                } else if (event.character == '\r' && (this.handle(event, "CR") || this.handle(event, "NUMPAD_ENTER")) && !FilteredTree.this.isAutoFiltering()) {
                    FilteredTree.this.handleCRKeyStoke();
                }
            }
        });
        if (this.isAutoFiltering()) {
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilteredTree.this.textChanged();
                }
            });
        } else {
            this.filterText.setToolTipText(Messages.FilteredTree_Tooltip);
        }
        GridData gridData = new GridData(4, 1, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Label createMessageArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FilteredTree_Title);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        return label;
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FilteredTree.this.treeViewer.isBusy() || FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTree.this.getFilterString();
                if (text == null || FilteredTree.this.lastAppliedPattern.equals(text)) {
                    return Status.OK_STATUS;
                }
                boolean initial = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(text);
                String newPatternToApply = "";
                if (!initial && text.length() > 0) {
                    newPatternToApply = text;
                }
                FilteredTree.this.lastAppliedPattern = newPatternToApply;
                FilteredTree.this.patternFilter.setPattern(newPatternToApply);
                Composite redrawFalseControl = FilteredTree.this.treeComposite != null ? FilteredTree.this.treeComposite : FilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    ISelection currentSelection = FilteredTree.this.treeViewer.getSelection();
                    Object[] expandedElements = FilteredTree.this.treeViewer.getExpandedElements();
                    if (!FilteredTree.this.narrowingDown) {
                        TreeItem[] is;
                        TreeItem[] treeItemArray = is = FilteredTree.this.treeViewer.getTree().getItems();
                        int n = is.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++n2;
                        }
                    }
                    FilteredTree.this.treeViewer.refresh(false);
                    if (!initial) {
                        if (text.length() > 0) {
                            FilteredTree.this.updateToolbar(true);
                            TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                            int treeHeight = FilteredTree.this.getViewer().getTree().getBounds().height;
                            int numVisibleItems = treeHeight / FilteredTree.this.getViewer().getTree().getItemHeight();
                            long stopTime = 200L + System.currentTimeMillis();
                            if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                        } else {
                            FilteredTree.this.updateToolbar(false);
                            FilteredTree.this.handleTreeViewerExpansionWhenNoFilter(currentSelection, expandedElements);
                        }
                    } else {
                        FilteredTree.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FilteredTree.this.refreshJob != null) {
                    FilteredTree.this.refreshJob.cancel();
                }
            }
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2180);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    protected long getAutoFilteringDelay() {
        return 200L;
    }

    protected int getExpansionLevelWhenNoFilter() {
        return 0;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void handleCRKeyStoke() {
        this.textChanged();
    }

    protected void handleTreeViewerExpansionWhenNoFilter(Object[] expandedElements) {
        this.handleTreeViewerExpansionWhenNoFilter(null, expandedElements);
    }

    protected void handleTreeViewerExpansionWhenNoFilter(ISelection currentSelection, Object[] expandedElements) {
        if (expandedElements.length == 0) {
            this.treeViewer.expandToLevel(this.getExpansionLevelWhenNoFilter());
        } else {
            this.treeViewer.setExpandedElements(expandedElements);
        }
        if (currentSelection != null) {
            this.treeViewer.setSelection(currentSelection, true);
        }
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.patternFilter = filter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected boolean isAutoFiltering() {
        return this.isAutoFiltering;
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected void setAutoFiltering(boolean isAutoFiltering) {
        this.isAutoFiltering = isAutoFiltering;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.setFilterText(this.initialText);
        this.textChanged();
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        long delay = 0L;
        if (this.isAutoFiltering()) {
            delay = this.getAutoFilteringDelay();
        }
        this.refreshJob.schedule(delay);
    }

    protected void updateToolbar(boolean visible) {
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    public static Font getBoldFont(Object element, FilteredTree tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!"".equals(filterText) && !initialText.equals(filterText)) {
            boolean initial;
            boolean bl = initial = initialText != null && initialText.equals(filterText);
            if (initial) {
                filter.setPattern(null);
            } else {
                filter.setPattern(filterText);
            }
            TreeViewer viewer = tree.getViewer();
            Object parent = ((ITreeContentProvider)viewer.getContentProvider()).getParent(element);
            if (filter.isElementVisible((Viewer)viewer, parent, element) && filter.isLeafMatch((Viewer)viewer, parent, element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.setUseHashlookup(true);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object[] elements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

