/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FunctionalChainKind implements Enumerator
{
    SIMPLE(0, "SIMPLE", "SIMPLE"),
    COMPOSITE(1, "COMPOSITE", "COMPOSITE"),
    FRAGMENT(2, "FRAGMENT", "FRAGMENT");

    public static final int SIMPLE_VALUE = 0;
    public static final int COMPOSITE_VALUE = 1;
    public static final int FRAGMENT_VALUE = 2;
    private static final FunctionalChainKind[] VALUES_ARRAY;
    public static final List<FunctionalChainKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FunctionalChainKind[]{SIMPLE, COMPOSITE, FRAGMENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FunctionalChainKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionalChainKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionalChainKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionalChainKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionalChainKind get(int value) {
        switch (value) {
            case 0: {
                return SIMPLE;
            }
            case 1: {
                return COMPOSITE;
            }
            case 2: {
                return FRAGMENT;
            }
        }
        return null;
    }

    private FunctionalChainKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

