/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterDirection implements Enumerator
{
    IN(0, "IN", "IN"),
    OUT(1, "OUT", "OUT"),
    INOUT(2, "INOUT", "INOUT"),
    RETURN(3, "RETURN", "RETURN"),
    EXCEPTION(4, "EXCEPTION", "EXCEPTION"),
    UNSET(5, "UNSET", "UNSET");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    public static final int RETURN_VALUE = 3;
    public static final int EXCEPTION_VALUE = 4;
    public static final int UNSET_VALUE = 5;
    private static final ParameterDirection[] VALUES_ARRAY;
    public static final List<ParameterDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterDirection[]{IN, OUT, INOUT, RETURN, EXCEPTION, UNSET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterDirection get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
            case 3: {
                return RETURN;
            }
            case 4: {
                return EXCEPTION;
            }
            case 5: {
                return UNSET;
            }
        }
        return null;
    }

    private ParameterDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

