/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.specifications;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.INamedElement;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.Messages;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AdditionKind;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModifiableTemplatePatternSpecification
extends AbstractBijectiveTemplatePatternSpecification
implements IModifiableTemplatePatternSpecification {
    protected static final String VERSION_SEPARATOR = ".";
    protected static final String VERSION_SEPARATOR_REGEX = Pattern.quote(".");
    private boolean _acceptNewPatternImage;
    private boolean _includeLayout;
    private TemplatePatternComparison _comparison;
    private final EMap<EObject, TemplatePatternRole> _sourceElementToRole = new FHashMap();
    private final Collection<ITemplateElementsChangedListener> _listeners = new HashSet<ITemplateElementsChangedListener>();
    private final WeakReference<EObject> _defaultScopeElement;
    protected LinkedHashMap<EObject, EObject> _noIdsMap;

    public AbstractModifiableTemplatePatternSpecification(boolean acceptNewPatternImage_p, boolean includeLayout_p, EObject scopeElement_p) {
        this._acceptNewPatternImage = acceptNewPatternImage_p;
        this._includeLayout = includeLayout_p;
        this._defaultScopeElement = new WeakReference<EObject>(scopeElement_p);
        this._noIdsMap = new LinkedHashMap();
    }

    @Override
    public boolean acceptNewPatternImage() {
        return this._acceptNewPatternImage;
    }

    public void addElements(Collection<? extends EObject> elements_p, boolean includeChildren_p, boolean asDependencies_p) {
        if (!elements_p.isEmpty()) {
            FilteredModelScope sourceScope = (FilteredModelScope)this.getModelScope();
            for (EObject eObject : elements_p) {
                sourceScope.add(eObject, includeChildren_p);
            }
            this.updateComparison();
            if (asDependencies_p) {
                this.updateRolesFor(elements_p);
            }
        }
    }

    public void addTemplateElementsChangedListener(ITemplateElementsChangedListener listener_p) {
        this._listeners.add(listener_p);
    }

    protected void mergeDifferences() {
        this.getComparison().merge(TemplatePatternComparison.getPatternRole(), true, null);
    }

    @Override
    public TemplatePatternRole addRole(String roleName_p) {
        TemplatePatternRole result = TemplatepatternsFactory.eINSTANCE.createTemplatePatternRole();
        result.setName(roleName_p);
        result.setDescription("");
        result.setAdditionKind(AdditionKind.ANY_CONTAINMENT);
        result.setExclusive(true);
        this.getPattern().getRoles().add((Object)result);
        return result;
    }

    protected TemplatePatternRole addRoleFor(EObject sourceElement_p) {
        String defaultName = this.getText(sourceElement_p);
        TemplatePatternRole result = this.addRole(defaultName);
        this.mapToRole(result, sourceElement_p);
        return result;
    }

    public TemplatePatternRole addRoleFor(String roleName_p, Collection<EObject> sourceElements_p) {
        String roleName = roleName_p;
        if (roleName == null) {
            if (sourceElements_p.size() > 1) {
                EClass commonType = ModelsUtil.getCommonType(sourceElements_p);
                roleName = this.getRoleNameForType(commonType);
            }
            if (roleName == null) {
                roleName = this.getText(sourceElements_p.iterator().next());
            }
        }
        TemplatePatternRole result = this.addRole(roleName_p);
        for (EObject sourceElement : sourceElements_p) {
            this.mapToRole(result, sourceElement);
        }
        return result;
    }

    protected TemplatePatternRole addRoleFor(Collection<EObject> sourceElements_p, IReferenceLocation origin_p) {
        TemplatePatternRole result;
        if (sourceElements_p.size() == 1) {
            result = this.addRoleFor(sourceElements_p.iterator().next());
        } else {
            String defaultName;
            EClass commonType = ModelsUtil.getCommonType(sourceElements_p);
            String string = defaultName = commonType != null ? this.getRoleNameForType(commonType) : null;
            if (defaultName == null || this.collidesWithRoleName(defaultName)) {
                defaultName = this.getText(origin_p.getElement());
            }
            if (this.collidesWithRoleName(defaultName)) {
                defaultName = String.valueOf(defaultName) + "::" + origin_p.getReference().getName();
            }
            result = this.addRole(defaultName);
            for (EObject sourceElement : sourceElements_p) {
                this.mapToRole(result, sourceElement);
            }
        }
        return result;
    }

    protected boolean collidesWithRoleName(String name_p) {
        if (name_p == null || this.getPattern() == null) {
            return false;
        }
        for (IPatternRole role : this.getPattern().getRoles()) {
            if (!name_p.equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    public List<EObject> filterNonModelElements(Collection<? extends EObject> elements_p) {
        FArrayList result = new FArrayList();
        for (EObject eObject : elements_p) {
            if (!this.isInModelScope(eObject)) continue;
            result.add(eObject);
        }
        return result;
    }

    public List<EObject> filterNonModelNonInstanceElements(Collection<? extends EObject> elements_p) {
        FArrayList result = new FArrayList();
        for (EObject eObject : elements_p) {
            if (!this.isInModelScope(eObject) || this.isInstanceRelated(eObject)) continue;
            result.add(eObject);
        }
        return result;
    }

    @Override
    public Collection<EObject> getAllElements() {
        return this.getModelScope().getAllContentsAsSet();
    }

    public TemplatePatternComparison getComparison() {
        return this._comparison;
    }

    public EObject getCounterpart(EObject element_p, boolean fromPattern_p) {
        Role elementRole = fromPattern_p ? TemplatePatternComparison.getPatternRole() : TemplatePatternComparison.getPatternRole().opposite();
        IMatch match = this._comparison.getMapping().getMatchFor(element_p, elementRole);
        EObject result = match != null ? match.get(elementRole.opposite()) : null;
        return result;
    }

    public Collection<EObject> getDependencies() {
        FOrderedSet result = new FOrderedSet();
        if (this.getComparison() != null) {
            IModelScope sourceScope = this.getModelScope();
            TreeIterator it = sourceScope.getAllContents();
            while (it.hasNext()) {
                EObject sourceElement = (EObject)it.next();
                if (INSTANCE_FILTER.accepts(sourceElement)) {
                    result.addAll(this.getDependencies(sourceElement));
                    continue;
                }
                it.prune();
                if (sourceElement == sourceScope.getContents().get(sourceScope.getContents().size() - 1)) break;
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<EObject> getDependencies(Collection<? extends EObject> sourceElements_p) {
        FOrderedSet result = new FOrderedSet();
        if (this.getComparison() != null) {
            for (EObject eObject : sourceElements_p) {
                if (!INSTANCE_FILTER.accepts(eObject)) continue;
                result.addAll(this.getDependencies(eObject));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<EObject> getDependencies(EObject sourceElement_p) {
        FOrderedSet result = new FOrderedSet();
        if (this.getComparison() != null && INSTANCE_FILTER.accepts(sourceElement_p) && this.isInModelScope(sourceElement_p)) {
            IModelScope sourceScope = this.getModelScope();
            ISemanticRuleProvider ruleProvider = this.getSemanticRuleProvider();
            List<EObject> candidates = ruleProvider.getDependencies(sourceElement_p);
            for (EObject candidate : candidates) {
                if (sourceScope.covers(candidate)) continue;
                result.add(candidate);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected Collection<IPatternInstance> getIncludedInstances() {
        FArrayList result = new FArrayList();
        for (EObject root : this.getModelScope().getContents()) {
            if (!(root instanceof IPatternInstance)) continue;
            result.add((IPatternInstance)root);
        }
        return result;
    }

    protected Collection<IPatternInstance> getInstancesToIgnore() {
        return this.getIncludedInstances();
    }

    @Override
    public IModelScope getModelScope() {
        return this._comparison.getScope(TemplatePatternComparison.getPatternRole().opposite());
    }

    @Override
    public IModelScope getPatternScope() {
        return this._comparison.getScope(TemplatePatternComparison.getPatternRole());
    }

    public Collection<AbstractPatternInstance> getRelatedInstances() {
        FOrderedSet result = new FOrderedSet();
        if (this.getComparison() != null) {
            IModelScope sourceScope = this.getModelScope();
            TreeIterator it = sourceScope.getAllContents();
            while (it.hasNext()) {
                EObject sourceElement = (EObject)it.next();
                result.addAll(this.getRelatedInstances(sourceElement));
            }
        }
        return result;
    }

    public Collection<AbstractPatternInstance> getRelatedInstances(Collection<? extends EObject> sourceElements_p) {
        FOrderedSet result = new FOrderedSet();
        if (this.getComparison() != null) {
            for (EObject eObject : sourceElements_p) {
                result.addAll(this.getRelatedInstances(eObject));
            }
        }
        return result;
    }

    public Collection<AbstractPatternInstance> getRelatedInstances(EObject sourceElement_p) {
        FOrderedSet result = new FOrderedSet();
        Collection<IPatternInstance> toIgnore = this.getInstancesToIgnore();
        IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor(sourceElement_p);
        if (support != null) {
            List instances = support.getRelatedInstances(sourceElement_p);
            for (IPatternInstance instance : instances) {
                if (!(instance instanceof AbstractPatternInstance) || toIgnore.contains(instance)) continue;
                result.add((AbstractPatternInstance)instance);
            }
        }
        return result;
    }

    public String getRoleNameForType(EClass type_p) {
        String typeName = type_p.getName();
        String result = typeName.endsWith("s") || typeName.endsWith("x") ? String.format(Messages.AbstractModifiableTemplatePatternSpecification_SpecialRoleNameFromType, type_p.getName()) : String.format(Messages.AbstractModifiableTemplatePatternSpecification_RoleNameFromType, type_p.getName());
        return result;
    }

    public List<TemplatePatternRole> getRolesOf(EObject sourceElement_p) {
        TemplatePatternRole role = (TemplatePatternRole)this._sourceElementToRole.get((Object)sourceElement_p);
        List<Object> result = role == null ? Collections.emptyList() : Collections.singletonList(role);
        return result;
    }

    public EObject getScopeElement() {
        EObject result = null;
        List contents = this.getModelScope().getContents();
        result = !contents.isEmpty() ? (EObject)contents.get(0) : (EObject)this._defaultScopeElement.get();
        return result;
    }

    protected ISemanticRuleProvider getSemanticRuleProvider() {
        ISemanticRuleProvider result = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this.getScopeElement());
        return result;
    }

    public String getText(EObject element_p) {
        IItemLabelProvider labelProvider;
        String result = element_p.toString();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element_p);
        if (domain != null && (labelProvider = (IItemLabelProvider)((AdapterFactoryEditingDomain)domain).getAdapterFactory().adapt((Notifier)element_p, IItemLabelProvider.class)) != null) {
            result = labelProvider.getText((Object)element_p);
        }
        return result;
    }

    public boolean hasDependencies() {
        if (this.getComparison() != null) {
            IModelScope sourceScope = this.getModelScope();
            TreeIterator it = sourceScope.getAllContents();
            while (it.hasNext()) {
                EObject sourceElement = (EObject)it.next();
                if (INSTANCE_FILTER.accepts(sourceElement)) {
                    if (!this.hasDependencies(sourceElement)) continue;
                    return true;
                }
                it.prune();
                if (sourceElement == sourceScope.getContents().get(sourceScope.getContents().size() - 1)) break;
            }
        }
        return false;
    }

    public boolean hasDependencies(Collection<? extends EObject> sourceElements_p) {
        if (this.getComparison() != null) {
            for (EObject eObject : sourceElements_p) {
                if (!this.hasDependencies(eObject)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDependencies(EObject sourceElement_p) {
        if (this.getComparison() != null && this.isInModelScope(sourceElement_p)) {
            IModelScope sourceScope = this.getModelScope();
            ISemanticRuleProvider ruleProvider = this.getSemanticRuleProvider();
            return ruleProvider.hasNotInScopeDependencies(sourceElement_p, sourceScope);
        }
        return false;
    }

    public boolean hasRelatedInstances() {
        IPatternSupport support;
        if (this.getComparison() != null && (support = CorePatternsPlugin.getDefault().getPatternSupportFor(this.getScopeElement())) != null) {
            Collection<IPatternInstance> instancesToIgnore = this.getInstancesToIgnore();
            IModelScope sourceScope = this.getModelScope();
            TreeIterator it = sourceScope.getAllContents();
            while (it.hasNext()) {
                EObject sourceElement = (EObject)it.next();
                if (!this.hasRelatedInstances(sourceElement, support, instancesToIgnore)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasRelatedInstances(EObject sourceElement_p, IPatternSupport support_p, Collection<? extends IPatternInstance> instancesToIgnore_p) {
        boolean result = false;
        if (this.getComparison() != null && this.isInModelScope(sourceElement_p)) {
            List relatedInstances = support_p.getRelatedInstances(sourceElement_p);
            ArrayList copy = new ArrayList(relatedInstances);
            copy.removeAll(instancesToIgnore_p);
            result = !copy.isEmpty();
        }
        return result;
    }

    public boolean hasUnmappedElements() {
        TreeIterator it = this.getModelScope().getAllContents();
        while (it.hasNext()) {
            EObject sourceElement = (EObject)it.next();
            if (!this.getRolesOf(sourceElement).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean includeLayoutData() {
        return this._includeLayout;
    }

    public boolean isComplete() {
        boolean result;
        TemplatePattern pattern = this.getPattern();
        boolean bl = result = this.isSignificant(pattern.getName()) && this.isSignificant(pattern.getVersion()) && !pattern.getRoles().isEmpty() && NamingUtil.haveUniqueNames((Collection<? extends INamedElement>)pattern.getRoles());
        if (result) {
            for (TemplatePatternRole role : pattern.getRoles()) {
                if (!role.getTemplateElements().isEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isTemplate() {
        return this.getPattern() != null && this.getPattern().isTemplate();
    }

    public boolean isInModelScope(EObject element_p) {
        IMatch match = this.getComparison().getMapping().getMatchFor(element_p, TemplatePatternComparison.getPatternRole().opposite());
        boolean result = match != null;
        return result;
    }

    public void mapToRole(TemplatePatternRole role_p, EObject sourceElement_p) {
        EObject templateElement = this.getCounterpart(sourceElement_p, false);
        if (templateElement != null) {
            this.removeFromRole(sourceElement_p);
            role_p.getTemplateElements().add((Object)templateElement);
            this._sourceElementToRole.put((Object)sourceElement_p, (Object)role_p);
            this.roleUpdated();
        }
    }

    protected void newComparison(TemplatePatternComparison comparison_p) {
        this._comparison = comparison_p;
    }

    protected void registerRoleElements() {
        if (this.getPattern() != null) {
            for (TemplatePatternRole role : this.getPattern().getRoles()) {
                for (EObject templateElement : role.getTemplateElements()) {
                    EObject sourceElement = this.getCounterpart(templateElement, true);
                    if (sourceElement == null) continue;
                    this._sourceElementToRole.put((Object)sourceElement, (Object)role);
                }
            }
        }
    }

    public void removeElements(Collection<? extends EObject> elements_p, boolean removeChildren_p) {
        for (EObject eObject : elements_p) {
            boolean removeChildren = removeChildren_p || this.isInstanceRelated(eObject);
            ((FilteredModelScope)this.getModelScope()).removeFromScope(eObject, removeChildren);
            this.removeFromRole(eObject);
            if (!removeChildren_p) continue;
            TreeIterator technicalIterator = eObject.eAllContents();
            while (technicalIterator.hasNext()) {
                EObject child = (EObject)technicalIterator.next();
                this.removeFromRole(child);
            }
        }
        this.updateComparison();
    }

    public void removeFromRole(EObject sourceElement_p) {
        EObject templateElement;
        TemplatePatternRole role = (TemplatePatternRole)this._sourceElementToRole.get((Object)sourceElement_p);
        if (role != null && (templateElement = this.getCounterpart(sourceElement_p, false)) != null) {
            role.getTemplateElements().remove((Object)templateElement);
            this._sourceElementToRole.removeKey((Object)sourceElement_p);
            this.roleUpdated();
        }
    }

    @Override
    public void removeRole(TemplatePatternRole role_p) {
        this.getPattern().getRoles().remove((Object)role_p);
        for (Map.Entry entry : new HashSet(this._sourceElementToRole.entrySet())) {
            if (entry.getValue() != role_p) continue;
            this._sourceElementToRole.remove((Object)entry);
        }
        this.roleUpdated();
    }

    @Override
    public void setAcceptNewPatternImage(boolean accept_p) {
        this._acceptNewPatternImage = accept_p;
    }

    @Override
    public void setIncludeLayoutData(boolean include_p) {
        this._includeLayout = include_p;
    }

    public void updateComparison() {
        this.getComparison().update(this._noIdsMap);
        this.mergeDifferences();
        Collection completedMatches = this.getComparison().getMapping().getCompletedMatches(Role.REFERENCE);
        for (IMatch match : completedMatches) {
            EObject ref = match.get(Role.REFERENCE);
            if (ref == null) continue;
            this._noIdsMap.put(ref, match.get(Role.TARGET));
        }
        for (ITemplateElementsChangedListener listener : this._listeners) {
            listener.templateElementsChanged();
        }
    }

    protected void updateRolesFor(Collection<? extends EObject> newSourceElements_p) {
        boolean rolesUpdated = false;
        ISemanticRuleProvider ruleProvider = this.getSemanticRuleProvider();
        for (EObject eObject : newSourceElements_p) {
            if (!this.getModelScope().getContents().contains(eObject) || !this.getModelScope().getContents(eObject).isEmpty() || !ruleProvider.isMergeDependency(eObject) || ruleProvider.canBeAutomaticallyMerged(eObject)) continue;
            TemplatePatternRole role = this.addRoleFor(eObject);
            role.setAdditionKind(AdditionKind.FORBIDDEN);
            rolesUpdated = true;
        }
        if (rolesUpdated) {
            this.roleUpdated();
        }
    }

    public static interface ITemplateElementsChangedListener {
        public void templateElementsChanged();
    }
}

