/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;

public class CapellaDataListenerForPropertySections
extends CapellaModelDataListener {
    private Set<TabbedPropertySheetPage> pages;

    public void notifyChanged(Notification notification) {
        if (this.filterNotification(notification)) {
            return;
        }
        if (notification.getEventType() != 1 && notification.getEventType() != 2) {
            return;
        }
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject && !this.getPages().isEmpty()) {
            UIJob refreshView = new UIJob(Display.getDefault(), "Refresh properties view"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    for (TabbedPropertySheetPage page : CapellaDataListenerForPropertySections.this.getPages()) {
                        page.refresh();
                        page.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)new BaseLabelProvider(), null));
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshView.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void registerPropertySheetPage(TabbedPropertySheetPage page) {
        if (!this.getPages().contains(page)) {
            this.getPages().add(page);
        }
    }

    public void unregisterPropertySheetPage(TabbedPropertySheetPage page) {
        this.getPages().remove(page);
    }

    public Set<TabbedPropertySheetPage> getPages() {
        if (this.pages == null) {
            this.pages = new HashSet<TabbedPropertySheetPage>();
        }
        return this.pages;
    }
}

